/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class BlockStatesDatagen
extends BlockStateProvider {
    public BlockStatesDatagen(DataGenerator gen, String modid, ExistingFileHelper exFileHelper) {
        super(gen, modid, exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.registerNormalCube(BlockRegistry.ARCANE_STONE, "arcane_stone");
        this.registerNormalCube(BlockRegistry.ARCANE_BRICKS, "arcane_bricks");
        this.registerNormalCube(BlockRegistry.AB_ALTERNATE, "ab_alternating");
        this.registerNormalCube(BlockRegistry.AB_BASKET, "ab_basket");
        this.registerNormalCube(BlockRegistry.AB_HERRING, "ab_herring");
        this.registerNormalCube(BlockRegistry.AB_MOSAIC, "ab_mosaic");
        this.registerNormalCube(BlockRegistry.AB_CLOVER, "ab_clover");
        this.registerNormalCube(BlockRegistry.AB_SMOOTH, "ab_smooth");
        this.registerNormalCube(BlockRegistry.AB_SMOOTH_SLAB, "ab_smooth_slab");
        this.registerNormalCube(BlockRegistry.SOURCE_GEM_BLOCK, "source_gem_block");
        this.registerNormalCube(BlockRegistry.AB_SMOOTH_BASKET, "sas_basket");
        this.registerNormalCube(BlockRegistry.AB_SMOOTH_CLOVER, "sas_clover");
        this.registerNormalCube(BlockRegistry.AB_SMOOTH_HERRING, "sas_herring");
        this.registerNormalCube(BlockRegistry.AB_SMOOTH_MOSAIC, "sas_mosaic");
        this.registerNormalCube(BlockRegistry.AB_SMOOTH_ALTERNATING, "sas_alternating");
        this.registerNormalCube(BlockRegistry.AB_SMOOTH_ASHLAR, "sas_ashlar");
        this.registerNormalCube(BlockRegistry.AS_GOLD_ALT, "as_gold_alt");
        this.registerNormalCube(BlockRegistry.AS_GOLD_ASHLAR, "as_gold_ashlar");
        this.registerNormalCube(BlockRegistry.AS_GOLD_BASKET, "as_gold_basket");
        this.registerNormalCube(BlockRegistry.AS_GOLD_CLOVER, "as_gold_clover");
        this.registerNormalCube(BlockRegistry.AS_GOLD_HERRING, "as_gold_herring");
        this.registerNormalCube(BlockRegistry.AS_GOLD_MOSAIC, "as_gold_mosaic");
        this.registerNormalCube(BlockRegistry.AS_GOLD_SLAB, "as_gold_slab");
        this.registerNormalCube(BlockRegistry.AS_GOLD_STONE, "as_gold_stone");
        this.registerNormalCube(BlockRegistry.RED_SBED, "red_sbed");
        this.registerNormalCube(BlockRegistry.BLUE_SBED, "blue_sbed");
        this.registerNormalCube(BlockRegistry.GREEN_SBED, "green_sbed");
        this.registerNormalCube(BlockRegistry.YELLOW_SBED, "yellow_sbed");
        this.registerNormalCube(BlockRegistry.ORANGE_SBED, "orange_sbed");
        this.registerNormalCube(BlockRegistry.PURPLE_SBED, "purple_sbed");
    }

    public void registerNormalCube(Block block, String registry) {
        this.buildNormalCube(registry);
        this.simpleBlock(block, BlockStatesDatagen.getUncheckedModel(registry));
    }

    public static ModelFile getUncheckedModel(String registry) {
        return new ModelFile.UncheckedModelFile("ars_nouveau:block/" + registry);
    }

    public void buildNormalCube(String registryName) {
        ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(registryName)).parent((ModelFile)new ModelFile.UncheckedModelFile("block/cube_all"))).texture("all", this.getBlockLoc(registryName));
    }

    public ResourceLocation getBlockLoc(String registryName) {
        return new ResourceLocation("ars_nouveau", "blocks/" + registryName);
    }
}

