/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.crafting.recipes;

import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.common.crafting.recipes.RecipeUtil;
import com.hollingsworth.arsnouveau.common.items.PotionFlask;
import com.hollingsworth.arsnouveau.setup.RecipeRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class PotionFlaskRecipe
extends ShapelessRecipe {
    public PotionFlaskRecipe(ResourceLocation idIn, String groupIn, ItemStack recipeOutputIn, NonNullList<Ingredient> recipeItemsIn) {
        super(idIn, groupIn, recipeOutputIn, recipeItemsIn);
    }

    public ItemStack m_5874_(CraftingContainer inv) {
        ItemStack ingredient;
        int i;
        ItemStack output = super.m_5874_(inv);
        int newCount = 0;
        Potion flaskPotion = Potions.f_43598_;
        List effectsList = new ArrayList();
        List flaskEffects = new ArrayList();
        if (output.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack flaskPotionStack = ItemStack.f_41583_;
        for (i = 0; i < inv.m_6643_(); ++i) {
            ingredient = inv.m_8020_(i);
            if (ingredient.m_41619_() || !(ingredient.m_41720_() instanceof PotionFlask)) continue;
            if (((PotionFlask)ingredient.m_41720_()).isMax(ingredient)) {
                return ItemStack.f_41583_;
            }
            CompoundTag tag = ingredient.m_41782_() ? ingredient.m_41783_() : new CompoundTag();
            newCount = tag.m_128451_("count") + 1;
            flaskPotion = PotionUtils.m_43579_((ItemStack)ingredient);
            flaskPotionStack = ingredient;
            flaskEffects = PotionUtils.m_43573_((CompoundTag)ingredient.m_41783_());
        }
        for (i = 0; i < inv.m_6643_(); ++i) {
            ingredient = inv.m_8020_(i);
            if (ingredient.m_41619_() || !(ingredient.m_41720_() instanceof PotionItem)) continue;
            Potion stackPotion = PotionUtils.m_43579_((ItemStack)ingredient);
            effectsList = PotionUtils.m_43573_((CompoundTag)ingredient.m_41783_());
            if (flaskPotion != Potions.f_43598_ && !PotionUtils.m_43573_((CompoundTag)ingredient.m_41783_()).equals(PotionUtils.m_43573_((CompoundTag)flaskPotionStack.m_41783_()))) {
                return ItemStack.f_41583_;
            }
            if (flaskPotion == Potions.f_43598_) {
                flaskPotion = stackPotion;
                System.out.println(effectsList.size());
            }
            if (flaskPotion.equals(stackPotion)) continue;
            return ItemStack.f_41583_;
        }
        if (!output.m_41782_()) {
            output.m_41751_(new CompoundTag());
            output.m_41783_().m_128405_("count", newCount);
            PotionUtils.m_43549_((ItemStack)output, (Potion)flaskPotion);
            PotionUtils.m_43552_((ItemStack)output, effectsList);
        }
        return output;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack item = inv.m_8020_(i);
            if (item.hasContainerItem()) {
                nonnulllist.set(i, (Object)item.getContainerItem());
                continue;
            }
            if (!(item.m_41720_() instanceof PotionItem)) continue;
            nonnulllist.set(i, (Object)new ItemStack((ItemLike)Items.f_42590_));
        }
        return nonnulllist;
    }

    public RecipeSerializer<?> m_7707_() {
        return RecipeRegistry.POTION_FLASK_RECIPE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<PotionFlaskRecipe> {
        public PotionFlaskRecipe fromJson(ResourceLocation recipeID, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> ingredients = RecipeUtil.parseShapeless(json);
            ItemStack result = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true);
            return new PotionFlaskRecipe(recipeID, group, result, ingredients);
        }

        public PotionFlaskRecipe fromNetwork(ResourceLocation recipeID, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            int numIngredients = buffer.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)numIngredients, (Object)Ingredient.f_43901_);
            for (int j = 0; j < ingredients.size(); ++j) {
                ingredients.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack result = buffer.m_130267_();
            return new PotionFlaskRecipe(recipeID, group, result, (NonNullList<Ingredient>)ingredients);
        }

        public void toNetwork(FriendlyByteBuf buffer, PotionFlaskRecipe recipe) {
            buffer.m_130070_(recipe.m_6076_());
            buffer.m_130130_(recipe.m_7527_().size());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.m_8043_());
        }
    }
}

