/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.spell.ILightable;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.SconceBlock;
import com.hollingsworth.arsnouveau.common.block.ScribesBlock;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class SconceTile
extends ModdedTile
implements ILightable,
ITickable {
    public int red = 255;
    public int green = 125;
    public int blue = 255;
    public boolean lit;

    public SconceTile(BlockPos pos, BlockState state) {
        super(BlockRegistry.SCONCE_TILE, pos, state);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.red = nbt.m_128451_("red");
        this.red = this.red > 0 ? this.red : 255;
        this.green = nbt.m_128451_("green");
        this.green = this.green > 0 ? this.green : 125;
        this.blue = nbt.m_128451_("blue");
        this.blue = this.blue > 0 ? this.blue : 255;
        this.lit = nbt.m_128471_("lit");
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        compound.m_128405_("red", this.red);
        compound.m_128405_("green", this.green);
        compound.m_128405_("blue", this.blue);
        compound.m_128379_("lit", this.lit);
    }

    @Override
    public void onLight(HitResult rayTraceResult, Level world, LivingEntity shooter, SpellStats stats, SpellContext spellContext) {
        this.red = spellContext.colors.r;
        this.green = spellContext.colors.g;
        this.blue = spellContext.colors.b;
        this.lit = true;
        if (rayTraceResult instanceof BlockHitResult) {
            BlockState state = world.m_8055_(((BlockHitResult)rayTraceResult).m_82425_());
            world.m_7731_(this.m_58899_(), (BlockState)state.m_61124_(SconceBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(Math.min(Math.max(0, 15 - stats.getBuffCount(AugmentDampen.INSTANCE)), 15))), 3);
            world.m_7260_(((BlockHitResult)rayTraceResult).m_82425_(), state, (BlockState)state.m_61124_(SconceBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(15)), 3);
            this.m_6596_();
        }
    }

    @Override
    public void tick() {
        if (!this.f_58857_.f_46443_ || !this.lit) {
            return;
        }
        Level world = this.m_58904_();
        BlockPos pos = this.m_58899_();
        Random rand = world.f_46441_;
        double xzOffset = 0.15;
        BlockState state = this.m_58904_().m_8055_(this.m_58899_());
        if (!(state.m_60734_() instanceof SconceBlock)) {
            return;
        }
        double centerX = 0.0;
        double centerZ = 0.0;
        if (state.m_61143_((Property)ScribesBlock.FACING) == Direction.NORTH) {
            centerX = (double)pos.m_123341_() + 0.5 + ParticleUtil.inRange(-xzOffset / 4.0, xzOffset / 4.0);
            centerZ = (double)pos.m_123343_() + 0.8 + ParticleUtil.inRange(-xzOffset / 4.0, xzOffset / 4.0);
        }
        if (state.m_61143_((Property)ScribesBlock.FACING) == Direction.SOUTH) {
            centerX = (double)pos.m_123341_() + 0.5 + ParticleUtil.inRange(-xzOffset / 4.0, xzOffset / 4.0);
            centerZ = (double)pos.m_123343_() + 0.2 + ParticleUtil.inRange(-xzOffset / 4.0, xzOffset / 4.0);
        }
        if (state.m_61143_((Property)ScribesBlock.FACING) == Direction.EAST) {
            centerX = (double)pos.m_123341_() + 0.2 + ParticleUtil.inRange(-xzOffset / 4.0, xzOffset / 4.0);
            centerZ = (double)pos.m_123343_() + 0.5 + ParticleUtil.inRange(-xzOffset / 4.0, xzOffset / 4.0);
        }
        if (state.m_61143_((Property)ScribesBlock.FACING) == Direction.WEST) {
            centerX = (double)pos.m_123341_() + 0.8 + ParticleUtil.inRange(-xzOffset / 4.0, xzOffset / 4.0);
            centerZ = (double)pos.m_123343_() + 0.5 + ParticleUtil.inRange(-xzOffset / 4.0, xzOffset / 4.0);
        }
        ParticleColor color = new ParticleColor(rand.nextInt(this.red), rand.nextInt(this.green), rand.nextInt(this.blue));
        int intensity = 10;
        for (int i = 0; i < intensity; ++i) {
            world.m_7106_(GlowParticleData.createData(color), centerX, (double)pos.m_123342_() + 0.8 + ParticleUtil.inRange(-0.0, 0.1), centerZ, 0.0, ParticleUtil.inRange(0.0, 0.03f), 0.0);
        }
    }
}

