/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.BookwyrmLectern;
import com.hollingsworth.arsnouveau.common.block.SourceBlock;
import com.hollingsworth.arsnouveau.common.block.tile.SummoningTile;
import com.hollingsworth.arsnouveau.common.entity.EntityBookwyrm;
import com.hollingsworth.arsnouveau.common.entity.EntityFollowProjectile;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class BookwyrmLecternTile
extends SummoningTile
implements IWandable {
    int tier = 1;
    public boolean isOff;
    int taskIndex;

    public BookwyrmLecternTile(BlockPos pos, BlockState state) {
        super(BlockRegistry.BOOKWYRM_LECTERN_TILE, pos, state);
    }

    @Override
    public void convertedEffect() {
        super.convertedEffect();
        if (this.tickCounter >= 120 && !this.f_58857_.f_46443_) {
            this.converted = true;
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)SummoningTile.CONVERTED, (Comparable)Boolean.valueOf(true)));
            EntityBookwyrm bookwyrm = new EntityBookwyrm(this.f_58857_, this.f_58858_);
            bookwyrm.m_6034_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.0, (double)this.f_58858_.m_123343_() + 0.5);
            this.f_58857_.m_7967_((Entity)bookwyrm);
            ParticleUtil.spawnPoof((ServerLevel)this.f_58857_, this.f_58858_.m_7494_());
            this.tickCounter = 0;
            return;
        }
        if (this.tickCounter % 10 == 0 && !this.f_58857_.f_46443_) {
            Random r = this.f_58857_.f_46441_;
            int min = -2;
            int max = 2;
            EntityFollowProjectile proj1 = new EntityFollowProjectile(this.f_58857_, this.f_58858_.m_142082_(r.nextInt(max - min) + min, 3, r.nextInt(max - min) + min), this.f_58858_, r.nextInt(255), r.nextInt(255), r.nextInt(255));
            this.f_58857_.m_7967_((Entity)proj1);
        }
    }

    public void changeTier(Player entity) {
        if (this.tier == 1 || this.tier == 0) {
            this.tier = 2;
            entity.m_6352_((Component)new TranslatableComponent("ars_nouveau.bookwyrm_lectern.set", new Object[]{"5 x 5"}), Util.f_137441_);
        } else if (this.tier == 2) {
            this.tier = 3;
            entity.m_6352_((Component)new TranslatableComponent("ars_nouveau.bookwyrm_lectern.set", new Object[]{"9 x 9"}), Util.f_137441_);
        } else if (this.tier == 3) {
            this.tier = 4;
            entity.m_6352_((Component)new TranslatableComponent("ars_nouveau.bookwyrm_lectern.set", new Object[]{"13 x 13"}), Util.f_137441_);
        } else if (this.tier == 4) {
            this.tier = 5;
            entity.m_6352_((Component)new TranslatableComponent("ars_nouveau.bookwyrm_lectern.set", new Object[]{"17 x 17"}), Util.f_137441_);
        } else if (this.tier == 5) {
            this.tier = 1;
            entity.m_6352_((Component)new TranslatableComponent("ars_nouveau.bookwyrm_lectern.adjacent"), Util.f_137441_);
        }
    }

    public boolean enoughMana(@Nullable Spell spell) {
        if (spell == null) {
            return false;
        }
        return SourceUtil.hasSourceNearby(this.f_58858_, this.f_58857_, 7, spell.getCastingCost() / 4);
    }

    public boolean removeManaAround(@Nullable Spell spell) {
        if (spell == null) {
            return false;
        }
        return SourceUtil.takeSourceNearbyWithParticles(this.f_58858_, this.f_58857_, 7, spell.getCastingCost() / 4) != null;
    }

    @Nullable
    public BlockPos getNextTaskLoc(@Nullable Spell spell, EntityBookwyrm caster) {
        if (this.isOff || spell == null) {
            return null;
        }
        List<BlockPos> posList = this.getTargets();
        if (posList == null || posList.isEmpty()) {
            return null;
        }
        BlockPos taskPos = null;
        boolean wouldSucceed = false;
        for (int i = 0; i < posList.size(); ++i) {
            SpellResolver resolver;
            Block block;
            if (this.taskIndex >= posList.size()) {
                this.taskIndex = 0;
            }
            taskPos = posList.get(this.taskIndex);
            ++this.taskIndex;
            if (this.f_58857_.m_8055_(taskPos.m_7494_()).m_60767_() != Material.f_76296_ && !BlockUtil.isTreeBlock(this.f_58857_.m_8055_(taskPos))) {
                for (int j = 1; j < 4; ++j) {
                    if (this.f_58857_.m_8055_(taskPos.m_6630_(i)).m_60767_() == Material.f_76296_ && !BlockUtil.isTreeBlock(this.f_58857_.m_8055_(taskPos.m_7494_()))) continue;
                    taskPos = taskPos.m_6630_(i);
                    break;
                }
            }
            if ((block = this.f_58857_.m_8055_(taskPos).m_60734_()) instanceof BookwyrmLectern || block instanceof BaseEntityBlock || block instanceof SourceBlock || block instanceof Container || ((Boolean)caster.m_20088_().m_135370_(EntityBookwyrm.STRICT_MODE)).booleanValue() && !(resolver = new SpellResolver(new SpellContext(spell, (LivingEntity)caster))).wouldCastOnBlockSuccessfully(new BlockHitResult(new Vec3((double)taskPos.m_123341_(), (double)taskPos.m_123342_(), (double)taskPos.m_123343_()), Direction.UP, taskPos, false), (LivingEntity)caster)) continue;
            wouldSucceed = true;
            break;
        }
        return wouldSucceed ? taskPos : null;
    }

    public List<BlockPos> getTargets() {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        if (this.tier == 1) {
            positions.add(this.m_58899_().m_142127_().m_7495_());
            positions.add(this.m_58899_().m_142128_().m_7495_());
            positions.add(this.m_58899_().m_142126_().m_7495_());
            positions.add(this.m_58899_().m_142125_().m_7495_());
        }
        if (this.tier == 2) {
            BlockPos.m_121990_((BlockPos)this.m_58899_().m_142390_(2).m_142385_(2).m_6625_(1), (BlockPos)this.m_58899_().m_142383_(2).m_142386_(2).m_7495_()).forEach(t -> positions.add(new BlockPos((Vec3i)t)));
        }
        if (this.tier == 3) {
            BlockPos.m_121990_((BlockPos)this.m_58899_().m_142390_(4).m_142385_(4).m_6625_(1), (BlockPos)this.m_58899_().m_142383_(4).m_142386_(4).m_7495_()).forEach(t -> positions.add(new BlockPos((Vec3i)t)));
        }
        if (this.tier == 4) {
            BlockPos.m_121990_((BlockPos)this.m_58899_().m_142390_(6).m_142385_(6).m_6625_(1), (BlockPos)this.m_58899_().m_142383_(6).m_142386_(6).m_7495_()).forEach(t -> positions.add(new BlockPos((Vec3i)t)));
        }
        if (this.tier == 5) {
            BlockPos.m_121990_((BlockPos)this.m_58899_().m_142390_(8).m_142385_(8).m_6625_(1), (BlockPos)this.m_58899_().m_142383_(8).m_142386_(8).m_7495_()).forEach(t -> positions.add(new BlockPos((Vec3i)t)));
        }
        return positions;
    }

    public ItemStack insertItem(ItemStack stack) {
        return BlockUtil.insertItemAdjacent(this.f_58857_, this.f_58858_, stack);
    }

    public ItemStack getItem(Item item) {
        return BlockUtil.getItemAdjacent(this.f_58857_, this.f_58858_, stack -> stack.m_41720_() == item, 1);
    }

    @Override
    public void onWanded(Player playerEntity) {
        this.changeTier(playerEntity);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.taskIndex = tag.m_128451_("task_index");
        this.tier = tag.m_128451_("tier");
        this.isOff = tag.m_128471_("is_off");
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("task_index", this.taskIndex);
        tag.m_128405_("tier", this.tier);
        tag.m_128379_("is_off", this.isOff);
    }
}

