/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.entity;

import com.hollingsworth.arsnouveau.api.client.CosmeticRenderUtil;
import com.hollingsworth.arsnouveau.client.renderer.entity.StarbuncleModel;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoEntityRenderer;
import software.bernie.geckolib3.util.RenderUtils;

public class StarbuncleRenderer
extends GeoEntityRenderer<Starbuncle> {
    private static final ResourceLocation ORANGE = new ResourceLocation("ars_nouveau", "textures/entity/carbuncle_orange.png");
    private static final ResourceLocation PURPLE = new ResourceLocation("ars_nouveau", "textures/entity/carbuncle_purple.png");
    private static final ResourceLocation GREEN = new ResourceLocation("ars_nouveau", "textures/entity/carbuncle_green.png");
    private static final ResourceLocation WILD_TEXTURE = new ResourceLocation("ars_nouveau", "textures/entity/carbuncle_wild_orange.png");
    Starbuncle carbuncle;
    MultiBufferSource buffer;
    ResourceLocation text;

    public StarbuncleRenderer(EntityRendererProvider.Context manager) {
        super(manager, (AnimatedGeoModel)new StarbuncleModel());
    }

    protected void applyRotations(Starbuncle entityLiving, PoseStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        super.applyRotations((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
    }

    public void renderEarly(Starbuncle animatable, PoseStack stackIn, float ticks, MultiBufferSource renderTypeBuffer, VertexConsumer vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float partialTicks) {
        this.carbuncle = animatable;
        this.buffer = renderTypeBuffer;
        this.text = this.getTextureLocation(animatable);
        super.renderEarly((LivingEntity)animatable, stackIn, ticks, renderTypeBuffer, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, partialTicks);
    }

    public void render(Starbuncle entity, float entityYaw, float p_225623_3_, PoseStack matrixStack, MultiBufferSource iRenderTypeBuffer, int p_225623_6_) {
        super.render((LivingEntity)entity, entityYaw, p_225623_3_, matrixStack, iRenderTypeBuffer, p_225623_6_);
    }

    public void renderRecursively(GeoBone bone, PoseStack stack, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (bone.getName().equals("item")) {
            stack.m_85836_();
            RenderUtils.moveToPivot((GeoBone)bone, (PoseStack)stack);
            stack.m_85837_(0.0, -0.1, 0.0);
            stack.m_85841_(0.75f, 0.75f, 0.75f);
            ItemStack itemstack = this.carbuncle.getHeldStack();
            Minecraft.m_91087_().m_91291_().m_174269_(itemstack, ItemTransforms.TransformType.GROUND, packedLightIn, OverlayTexture.f_118083_, stack, this.buffer, (int)this.carbuncle.m_20097_().m_121878_());
            stack.m_85849_();
            bufferIn = this.buffer.m_6299_(RenderType.m_110458_((ResourceLocation)this.text));
        }
        if (bone.getName().equals("head")) {
            CosmeticRenderUtil.renderCosmetic(bone, stack, this.buffer, this.carbuncle, packedLightIn);
            bufferIn = this.buffer.m_6299_(RenderType.m_110458_((ResourceLocation)this.text));
        }
        super.renderRecursively(bone, stack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    public ResourceLocation getColor(Starbuncle e) {
        String color = ((String)e.m_20088_().m_135370_(Starbuncle.COLOR)).toLowerCase();
        if (color.isEmpty()) {
            return ORANGE;
        }
        return new ResourceLocation("ars_nouveau", "textures/entity/carbuncle_" + color + ".png");
    }

    public ResourceLocation getTextureLocation(Starbuncle entity) {
        return entity.isTamed() ? this.getColor(entity) : WILD_TEXTURE;
    }

    public RenderType getRenderType(Starbuncle animatable, float partialTicks, PoseStack stack, @Nullable MultiBufferSource renderTypeBuffer, @Nullable VertexConsumer vertexBuilder, int packedLightIn, ResourceLocation textureLocation) {
        return RenderType.m_110458_((ResourceLocation)textureLocation);
    }
}

