/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.hollingsworth.arsnouveau.api.sound.ConfiguredSpellSound;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SpellCaster
implements ISpellCaster {
    private Map<Integer, Spell> spells = new HashMap<Integer, Spell>();
    private Map<Integer, String> spellNames = new HashMap<Integer, String>();
    private Map<Integer, ParticleColor.IntWrapper> spellColors = new HashMap<Integer, ParticleColor.IntWrapper>();
    private Map<Integer, ConfiguredSpellSound> spellSounds = new HashMap<Integer, ConfiguredSpellSound>();
    private int slot;
    public ItemStack stack = ItemStack.f_41583_;
    public String flavorText = "";

    public SpellCaster(ItemStack stack) {
        this(stack.m_41784_());
        this.stack = stack;
    }

    @Override
    @Nonnull
    public Spell getSpell() {
        return this.spells.getOrDefault(this.getCurrentSlot(), Spell.EMPTY);
    }

    @Override
    @Nonnull
    public Spell getSpell(int slot) {
        return this.spells.getOrDefault(slot, Spell.EMPTY);
    }

    @Override
    public int getMaxSlots() {
        return 1;
    }

    @Override
    public int getCurrentSlot() {
        return this.slot;
    }

    @Override
    public void setCurrentSlot(int slot) {
        this.slot = slot;
        this.writeItem(this.stack);
    }

    @Override
    public void setSpell(Spell spell, int slot) {
        this.spells.put(slot, spell);
        this.writeItem(this.stack);
    }

    @Override
    public void setSpell(Spell spell) {
        this.spells.put(this.getCurrentSlot(), spell);
        this.writeItem(this.stack);
    }

    @Override
    @NotNull
    public ParticleColor.IntWrapper getColor(int slot) {
        return this.spellColors.getOrDefault(slot, ParticleUtil.defaultParticleColorWrapper());
    }

    @Override
    public void setFlavorText(String str) {
        this.flavorText = str;
        this.writeItem(this.stack);
    }

    @Override
    public String getSpellName(int slot) {
        return this.spellNames.getOrDefault(slot, "");
    }

    @Override
    public String getSpellName() {
        return this.spellNames.getOrDefault(this.getCurrentSlot(), "");
    }

    @Override
    public void setSpellName(String name) {
        this.spellNames.put(this.getCurrentSlot(), name);
        this.writeItem(this.stack);
    }

    @Override
    public void setSpellName(String name, int slot) {
        this.spellNames.put(slot, name);
        this.writeItem(this.stack);
    }

    @Override
    public String getFlavorText() {
        return this.flavorText == null ? "" : this.flavorText;
    }

    @Override
    public void setColor(ParticleColor.IntWrapper color) {
        this.spellColors.put(this.getCurrentSlot(), color);
        this.writeItem(this.stack);
    }

    @Override
    public void setColor(ParticleColor.IntWrapper color, int slot) {
        this.spellColors.put(slot, color);
        this.writeItem(this.stack);
    }

    @Override
    @Nonnull
    public ConfiguredSpellSound getSound(int slot) {
        return this.spellSounds.get(slot) == null ? ConfiguredSpellSound.DEFAULT : this.spellSounds.get(slot);
    }

    @Override
    public void setSound(ConfiguredSpellSound sound, int slot) {
        this.spellSounds.put(slot, sound);
        this.writeItem(this.stack);
    }

    @Override
    @Nonnull
    public ParticleColor.IntWrapper getColor() {
        return this.spellColors.getOrDefault(this.getCurrentSlot(), ParticleUtil.defaultParticleColorWrapper());
    }

    @Override
    public Map<Integer, Spell> getSpells() {
        return this.spells;
    }

    @Override
    public Map<Integer, String> getSpellNames() {
        return this.spellNames;
    }

    @Override
    public Map<Integer, ParticleColor.IntWrapper> getColors() {
        return this.spellColors;
    }

    public CompoundTag writeTag(CompoundTag tag) {
        tag.m_128405_("current_slot", this.getCurrentSlot());
        tag.m_128359_("flavor", this.getFlavorText());
        for (int i = 0; i < this.getMaxSlots() + 1; ++i) {
            tag.m_128359_("spell_" + i, this.getSpell(i).serialize());
            tag.m_128359_("spell_name_" + i, this.getSpellName(i));
            tag.m_128359_("spell_color_" + i, this.getColor(i).serialize());
            tag.m_128365_("spell_sound_" + i, (Tag)this.getSound(i).serialize());
        }
        return tag;
    }

    public SpellCaster(CompoundTag itemTag) {
        CompoundTag tag = itemTag.m_128469_(this.getTagID());
        this.slot = tag.m_128441_("current_slot") ? tag.m_128451_("current_slot") : 1;
        this.flavorText = tag.m_128461_("flavor");
        for (int i = 0; i < this.getMaxSlots() + 1; ++i) {
            if (tag.m_128441_("spell_" + i)) {
                this.setSpell(Spell.deserialize(tag.m_128461_("spell_" + i)), i);
            }
            if (tag.m_128441_("spell_name_" + i)) {
                this.setSpellName(tag.m_128461_("spell_name_" + i), i);
            }
            if (tag.m_128441_("spell_color_" + i)) {
                this.setColor(ParticleColor.IntWrapper.deserialize(tag.m_128461_("spell_color_" + i)), i);
            }
            if (!tag.m_128441_("spell_sound_" + i)) continue;
            this.setSound(ConfiguredSpellSound.fromTag(tag.m_128469_("spell_sound_" + i)), i);
        }
    }

    public void writeItem(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        CompoundTag casterTag = new CompoundTag();
        this.writeTag(casterTag);
        tag.m_128365_(this.getTagID(), (Tag)casterTag);
        stack.m_41751_(tag);
    }

    public void serializeOnTag(CompoundTag tag) {
        CompoundTag thisData = this.writeTag(new CompoundTag());
        tag.m_128365_(this.getTagID(), (Tag)thisData);
    }

    @Override
    public String getTagID() {
        return "ars_nouveau_spellCaster";
    }
}

