/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.itemfilters.item;

import dev.latvian.mods.itemfilters.api.FilterInfo;
import dev.latvian.mods.itemfilters.api.StringValueFilterVariant;
import dev.latvian.mods.itemfilters.item.StringValueData;
import dev.latvian.mods.itemfilters.item.StringValueFilterItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ItemGroupFilterItem
extends StringValueFilterItem {
    private static Map<String, CreativeModeTab> groups = null;

    @Nullable
    private static CreativeModeTab getItemGroup(String v) {
        if (groups == null) {
            groups = new HashMap<String, CreativeModeTab>();
            for (CreativeModeTab group : CreativeModeTab.f_40748_) {
                groups.put(group.m_40783_(), group);
            }
        }
        return groups.get(v);
    }

    public StringValueData createData(ItemStack stack) {
        return new ItemGroupData(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<StringValueFilterVariant> getValueVariants(ItemStack filter) {
        ArrayList<StringValueFilterVariant> variants = new ArrayList<StringValueFilterVariant>();
        for (CreativeModeTab t : CreativeModeTab.f_40748_) {
            if (t == CreativeModeTab.f_40754_ || t == CreativeModeTab.f_40761_) continue;
            StringValueFilterVariant variant = new StringValueFilterVariant(t.m_40783_());
            variant.title = t.m_40786_();
            variant.icon = t.m_40787_();
            variants.add(variant);
        }
        return variants;
    }

    @Override
    public boolean filter(ItemStack filter, ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        ItemGroupData data = (ItemGroupData)this.getStringValueData(filter);
        if (data.getValue() == null) {
            return false;
        }
        for (CreativeModeTab t : Collections.singleton(stack.m_41720_().m_41471_())) {
            if (t != data.getValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void getDisplayItemStacks(ItemStack filter, List<ItemStack> list) {
        ItemGroupData data = (ItemGroupData)this.getStringValueData(filter);
        if (data.getValue() != null) {
            NonNullList allItems = NonNullList.m_122779_();
            for (Item item : Registry.f_122827_) {
                try {
                    item.m_6787_((CreativeModeTab)data.getValue(), allItems);
                }
                catch (Throwable throwable) {}
            }
            list.addAll((Collection<ItemStack>)allItems);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addInfo(ItemStack filter, FilterInfo info, boolean expanded) {
        ItemGroupData data = (ItemGroupData)this.getStringValueData(filter);
        if (data != null && data.getValue() != null) {
            info.add(((CreativeModeTab)data.getValue()).m_40786_());
        }
    }

    public static class ItemGroupData
    extends StringValueData<CreativeModeTab> {
        public ItemGroupData(ItemStack is) {
            super(is);
        }

        @Override
        @Nullable
        protected CreativeModeTab fromString(String s) {
            return ItemGroupFilterItem.getItemGroup(s);
        }

        @Override
        protected String toString(CreativeModeTab value) {
            return value == null ? "" : value.m_40783_();
        }
    }
}

