/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.itemfilters.gui;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.latvian.mods.itemfilters.api.IStringValueFilter;
import dev.latvian.mods.itemfilters.api.StringValueFilterVariant;
import dev.latvian.mods.itemfilters.net.MessageUpdateFilterItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class StringValueFilterScreen
extends Screen {
    public final IStringValueFilter filter;
    public final ItemStack stack;
    public final InteractionHand hand;
    private final Map<String, StringValueFilterVariant> variants;
    private final ArrayList<StringValueFilterVariant> visibleVariants;
    private EditBox nameField;
    private int selectedVariant = -1;

    public StringValueFilterScreen(IStringValueFilter f, ItemStack is, InteractionHand h) {
        super(is.m_41611_());
        this.filter = f;
        this.stack = is;
        this.hand = h;
        this.variants = new HashMap<String, StringValueFilterVariant>();
        for (StringValueFilterVariant variant : this.filter.getValueVariants(this.stack)) {
            this.variants.put(variant.id, variant);
        }
        this.visibleVariants = new ArrayList<StringValueFilterVariant>(this.variants.values());
        this.visibleVariants.sort(null);
    }

    public void m_7856_() {
        super.m_7856_();
        this.f_96541_.f_91068_.m_90926_(true);
        int i = this.f_96543_ / 2;
        int j = this.f_96544_ / 2;
        this.nameField = new EditBox(this.f_96547_, i - 52, j - 6, 104, 12, TextComponent.f_131282_);
        this.nameField.m_94202_(-1);
        this.nameField.m_94205_(-1);
        this.nameField.m_94182_(false);
        this.nameField.m_94151_(this::updateVariants);
        this.nameField.m_94144_(this.filter.getValue(this.stack));
        this.nameField.m_94178_(true);
    }

    public void m_7379_() {
        super.m_7379_();
        this.f_96541_.f_91068_.m_90926_(true);
    }

    private void updateVariants(String txt) {
        if (!this.variants.isEmpty()) {
            this.visibleVariants.clear();
            txt = this.nameField.m_94155_().toLowerCase();
            if (txt.isEmpty()) {
                this.visibleVariants.addAll(this.variants.values());
            } else {
                for (StringValueFilterVariant variant : this.variants.values()) {
                    if (!variant.id.toLowerCase().contains(txt) && !variant.title.getString().toLowerCase().contains(txt)) continue;
                    this.visibleVariants.add(variant);
                }
            }
            this.visibleVariants.sort(null);
            this.selectedVariant = -1;
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257) {
            String text;
            String string = this.visibleVariants.size() == 1 ? this.visibleVariants.get((int)0).id : (text = this.selectedVariant == -1 ? this.nameField.m_94155_() : this.visibleVariants.get((int)this.selectedVariant).id);
            if (this.variants.isEmpty() || text.isEmpty() || this.variants.containsKey(text)) {
                this.filter.setValue(this.stack, text);
                this.f_96541_.m_91152_(null);
                StringValueFilterVariant variant = this.variants.get(text);
                this.f_96541_.m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.TUTORIAL_HINT, (Component)new TextComponent("Value changed!"), text.isEmpty() ? null : (variant == null ? new TextComponent(text) : variant.title.m_6881_())));
                this.f_96541_.f_91074_.m_21008_(this.hand, this.stack);
                new MessageUpdateFilterItem(this.hand, this.stack).send();
            } else {
                this.f_96541_.m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.TUTORIAL_HINT, (Component)new TextComponent("Invalid string!"), null));
            }
            return true;
        }
        if (keyCode == 258) {
            ++this.selectedVariant;
            if (this.selectedVariant == this.visibleVariants.size() || 14 + this.selectedVariant * 10 >= this.f_96544_) {
                this.selectedVariant = 0;
            }
            return true;
        }
        if (this.nameField.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char typedChar, int keyCode) {
        if (this.nameField.m_5534_(typedChar, keyCode)) {
            return true;
        }
        return super.m_5534_(typedChar, keyCode);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (super.m_6375_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (mouseButton == 1) {
            this.nameField.m_94144_("");
            return true;
        }
        this.nameField.m_6375_(mouseX, mouseY, mouseButton);
        this.nameField.m_94178_(true);
        return true;
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        RenderSystem.m_69461_();
        if (!this.variants.isEmpty()) {
            StringValueFilterScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)("Variants [" + this.visibleVariants.size() + "] [Press Tab]"), (int)4, (int)4, (int)-1);
            for (int i = 0; i < this.visibleVariants.size(); ++i) {
                StringValueFilterVariant variant = this.visibleVariants.get(i);
                StringValueFilterScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)variant.title.getString(), (int)(variant.icon.m_41619_() ? 4 : 14), (int)(14 + i * 10), (int)(i == this.selectedVariant ? -256 : -1));
                if (!variant.icon.m_41619_()) {
                    PoseStack modelViewStack = RenderSystem.m_157191_();
                    modelViewStack.m_85836_();
                    modelViewStack.m_85837_(4.0, (double)(14 + i * 10), 0.0);
                    modelViewStack.m_85841_(0.5f, 0.5f, 1.0f);
                    RenderSystem.m_157182_();
                    this.f_96542_.f_115093_ = 100.0f;
                    RenderSystem.m_69482_();
                    Lighting.m_84931_();
                    this.f_96542_.m_115203_(variant.icon, 0, 0);
                    this.f_96542_.m_115174_(this.f_96547_, variant.icon, 0, 0, "");
                    this.f_96542_.f_115093_ = 0.0f;
                    modelViewStack.m_85849_();
                    RenderSystem.m_157182_();
                }
                if (14 + i * 10 >= this.f_96544_) break;
            }
        }
        this.nameField.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }
}

