/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.itemfilters.api;

import dev.latvian.mods.itemfilters.api.CustomFilter;
import dev.latvian.mods.itemfilters.api.IItemFilter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ItemFiltersAPI {
    public static final TagKey<Item> FILTERS_ITEM_TAG = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation("itemfilters", "filters"));
    public static final TagKey<Item> CHECK_NBT_ITEM_TAG = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation("itemfilters", "check_nbt"));
    public static final Map<String, CustomFilter> CUSTOM_FILTERS = new LinkedHashMap<String, CustomFilter>();

    @Nullable
    public static IItemFilter getFilter(ItemStack stack) {
        if (stack.m_41720_() instanceof IItemFilter) {
            return (IItemFilter)stack.m_41720_();
        }
        return null;
    }

    public static boolean isFilter(ItemStack stack) {
        return stack.m_41720_() instanceof IItemFilter;
    }

    public static boolean areItemStacksEqual(ItemStack stackA, ItemStack stackB) {
        if (stackA == stackB) {
            return true;
        }
        if (stackA.m_41720_() != stackB.m_41720_()) {
            return false;
        }
        if (!stackA.m_41782_() && !stackB.m_41782_()) {
            return true;
        }
        return !stackA.m_204117_(CHECK_NBT_ITEM_TAG) || ItemStack.m_41658_((ItemStack)stackA, (ItemStack)stackB);
    }

    public static boolean filter(ItemStack filter, ItemStack stack) {
        if (filter.m_41619_()) {
            return true;
        }
        IItemFilter f = ItemFiltersAPI.getFilter(filter);
        return f == null ? ItemFiltersAPI.areItemStacksEqual(filter, stack) : f.filter(filter, stack);
    }

    public static void getDisplayItemStacks(ItemStack filter, List<ItemStack> list) {
        if (filter.m_41619_()) {
            return;
        }
        IItemFilter f = ItemFiltersAPI.getFilter(filter);
        if (f == null) {
            list.add(filter);
        } else {
            f.getDisplayItemStacks(filter, list);
        }
    }

    public static void getItems(ItemStack filter, Set<Item> list) {
        if (filter.m_41619_()) {
            return;
        }
        IItemFilter f = ItemFiltersAPI.getFilter(filter);
        if (f == null) {
            list.add(filter.m_41720_());
        } else {
            f.getItems(filter, list);
        }
    }

    public static CustomFilter registerCustomFilter(String id, Predicate<ItemStack> predicate) {
        CustomFilter filter = new CustomFilter(id, predicate);
        CUSTOM_FILTERS.put(id, filter);
        return filter;
    }
}

