/*
 * Decompiled with CFR 0.152.
 */
package observable.server;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import observable.Observable;
import observable.Props;
import observable.server.Profiler;
import observable.server.ServerSettingsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\u000f\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004R(\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0017\u0010\u000e\u001a\u00020\r8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lobservable/server/TaggedSampler;", "Ljava/lang/Runnable;", "", "run", "()V", "Lkotlin/collections/ArrayDeque;", "Lobservable/server/TaggedSampler$Sample;", "entries", "Lkotlin/collections/ArrayDeque;", "getEntries", "()Lkotlin/collections/ArrayDeque;", "setEntries", "(Lkotlin/collections/ArrayDeque;)V", "Ljava/lang/Thread;", "thread", "Ljava/lang/Thread;", "getThread", "()Ljava/lang/Thread;", "<init>", "(Ljava/lang/Thread;)V", "Sample", "SamplerProcessor", "observable"})
public final class TaggedSampler
implements Runnable {
    @NotNull
    private final Thread thread;
    @NotNull
    private ArrayDeque<Sample> entries;

    public TaggedSampler(@NotNull Thread thread) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        this.thread = thread;
        this.entries = new ArrayDeque();
    }

    @NotNull
    public final Thread getThread() {
        return this.thread;
    }

    @NotNull
    public final ArrayDeque<Sample> getEntries() {
        return this.entries;
    }

    public final void setEntries(@NotNull ArrayDeque<Sample> arrayDeque) {
        Intrinsics.checkNotNullParameter(arrayDeque, (String)"<set-?>");
        this.entries = arrayDeque;
    }

    @Override
    public void run() {
        Observable.INSTANCE.getLOGGER().info("Started sampler thread");
        long interval = ServerSettingsKt.getServerSettings().getTraceInterval();
        long deviation = ServerSettingsKt.getServerSettings().getDeviation();
        Object[] trace = null;
        Profiler.TimingData target = null;
        if (interval > 0L) {
            while (!Props.notProcessing) {
                if (Props.currentTarget.get() == null) continue;
                Object[] objectArray = this.thread.getStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"thread.stackTrace");
                trace = objectArray;
                target.getTraces().add(ArraysKt.toList((Object[])trace));
                Thread.sleep(interval + Random.Default.nextLong(-deviation, deviation));
            }
        } else {
            while (!Props.notProcessing) {
                if (Props.currentTarget.get() == null) continue;
                StackTraceElement[] stackTraceElementArray = this.thread.getStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"thread.stackTrace");
                trace = stackTraceElementArray;
                target.getTraces().add(ArraysKt.toList((Object[])trace));
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0002\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ,\u0010\u000b\u001a\u00020\u00002\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00022\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001a\u0010\u000f\u001a\u00020\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0012\u001a\u00020\u0011H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0015\u001a\u00020\u0014H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0019\u0010\t\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0017\u001a\u0004\b\u0018\u0010\u0004R\u001d\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u0019\u001a\u0004\b\u001a\u0010\b\u00a8\u0006\u001d"}, d2={"Lobservable/server/TaggedSampler$Sample;", "", "Lobservable/server/Profiler$TimingData;", "component1", "()Lobservable/server/Profiler$TimingData;", "", "Ljava/lang/StackTraceElement;", "component2", "()[Ljava/lang/StackTraceElement;", "target", "trace", "copy", "(Lobservable/server/Profiler$TimingData;[Ljava/lang/StackTraceElement;)Lobservable/server/TaggedSampler$Sample;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lobservable/server/Profiler$TimingData;", "getTarget", "[Ljava/lang/StackTraceElement;", "getTrace", "<init>", "(Lobservable/server/Profiler$TimingData;[Ljava/lang/StackTraceElement;)V", "observable"})
    public static final class Sample {
        @Nullable
        private final Profiler.TimingData target;
        @NotNull
        private final StackTraceElement[] trace;

        public Sample(@Nullable Profiler.TimingData target, @NotNull StackTraceElement[] trace) {
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            this.target = target;
            this.trace = trace;
        }

        @Nullable
        public final Profiler.TimingData getTarget() {
            return this.target;
        }

        @NotNull
        public final StackTraceElement[] getTrace() {
            return this.trace;
        }

        @Nullable
        public final Profiler.TimingData component1() {
            return this.target;
        }

        @NotNull
        public final StackTraceElement[] component2() {
            return this.trace;
        }

        @NotNull
        public final Sample copy(@Nullable Profiler.TimingData target, @NotNull StackTraceElement[] trace) {
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            return new Sample(target, trace);
        }

        public static /* synthetic */ Sample copy$default(Sample sample, Profiler.TimingData timingData, StackTraceElement[] stackTraceElementArray, int n, Object object) {
            if ((n & 1) != 0) {
                timingData = sample.target;
            }
            if ((n & 2) != 0) {
                stackTraceElementArray = sample.trace;
            }
            return sample.copy(timingData, stackTraceElementArray);
        }

        @NotNull
        public String toString() {
            return "Sample(target=" + this.target + ", trace=" + Arrays.toString(this.trace) + ')';
        }

        public int hashCode() {
            int result2 = this.target == null ? 0 : this.target.hashCode();
            result2 = result2 * 31 + Arrays.hashCode(this.trace);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Sample)) {
                return false;
            }
            Sample sample = (Sample)other;
            if (!Intrinsics.areEqual((Object)this.target, (Object)sample.target)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.trace, (Object)sample.trace);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u001d\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR\"\u0010\f\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lobservable/server/TaggedSampler$SamplerProcessor;", "Ljava/lang/Runnable;", "", "run", "()V", "Lkotlin/collections/ArrayDeque;", "Lobservable/server/TaggedSampler$Sample;", "entries", "Lkotlin/collections/ArrayDeque;", "getEntries", "()Lkotlin/collections/ArrayDeque;", "", "running", "Z", "getRunning", "()Z", "setRunning", "(Z)V", "<init>", "(Lkotlin/collections/ArrayDeque;)V", "observable"})
    public static final class SamplerProcessor
    implements Runnable {
        @NotNull
        private final ArrayDeque<Sample> entries;
        private volatile boolean running;

        public SamplerProcessor(@NotNull ArrayDeque<Sample> entries) {
            Intrinsics.checkNotNullParameter(entries, (String)"entries");
            this.entries = entries;
            this.running = true;
        }

        @NotNull
        public final ArrayDeque<Sample> getEntries() {
            return this.entries;
        }

        public final boolean getRunning() {
            return this.running;
        }

        public final void setRunning(boolean bl) {
            this.running = bl;
        }

        @Override
        public void run() {
            Object sample = null;
            while (this.running) {
                Sample sample2;
                if ((Sample)this.entries.removeLastOrNull() == null) continue;
                Profiler.TimingData target = sample2.component1();
                StackTraceElement[] trace = sample2.component2();
                if (target == null) continue;
            }
        }
    }
}

