/*
 * Decompiled with CFR 0.152.
 */
package glm_.quat;

import glm_.ext.ext_QuaternionGeometric;
import glm_.glm;
import glm_.mat3x3.Mat3;
import glm_.mat4x4.Mat4;
import glm_.quat.Quat;
import glm_.vec3.Vec3;
import glm_.vec4.Vec4;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001J'\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ'\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\tJ\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u0010\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J'\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0017\u0010\fJ\u0019\u0010\u0018\u001a\u00020\u00042\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001f\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001dJ\u001f\u0010 \u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b \u0010!J'\u0010\"\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\"\u0010\u0011J7\u0010(\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b(\u0010)J\u0017\u0010+\u001a\u00020*2\u0006\u0010\r\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b+\u0010,J\u0017\u0010.\u001a\u00020-2\u0006\u0010\r\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b.\u0010/J\u0017\u00100\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020*H\u0016\u00a2\u0006\u0004\b0\u00101J\u0017\u00100\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020-H\u0016\u00a2\u0006\u0004\b0\u00102\u00a8\u00063"}, d2={"Lglm_/quat/gtx_quaternion;", "", "Lglm_/vec3/Vec3;", "res", "Lglm_/quat/Quat;", "q", "v", "cross", "(Lglm_/vec3/Vec3;Lglm_/quat/Quat;Lglm_/vec3/Vec3;)Lglm_/vec3/Vec3;", "(Lglm_/vec3/Vec3;Lglm_/vec3/Vec3;Lglm_/quat/Quat;)Lglm_/vec3/Vec3;", "", "extractRealComponent", "(Lglm_/quat/Quat;)F", "x", "y", "a", "fastMix", "(Lglm_/quat/Quat;Lglm_/quat/Quat;F)Lglm_/quat/Quat;", "prev", "curr", "next", "intermediate", "(Lglm_/quat/Quat;Lglm_/quat/Quat;Lglm_/quat/Quat;)Lglm_/quat/Quat;", "length2", "quatIdentity", "(Lglm_/quat/Quat;)Lglm_/quat/Quat;", "rotate", "(Lglm_/quat/Quat;Lglm_/vec3/Vec3;)Lglm_/vec3/Vec3;", "Lglm_/vec4/Vec4;", "(Lglm_/quat/Quat;Lglm_/vec4/Vec4;)Lglm_/quat/Quat;", "orig", "dest", "rotation", "(Lglm_/vec3/Vec3;Lglm_/vec3/Vec3;)Lglm_/quat/Quat;", "shortMix", "q1", "q2", "s1", "s2", "h", "squad", "(Lglm_/quat/Quat;Lglm_/quat/Quat;Lglm_/quat/Quat;Lglm_/quat/Quat;F)Lglm_/quat/Quat;", "Lglm_/mat3x3/Mat3;", "toMat3", "(Lglm_/quat/Quat;)Lglm_/mat3x3/Mat3;", "Lglm_/mat4x4/Mat4;", "toMat4", "(Lglm_/quat/Quat;)Lglm_/mat4x4/Mat4;", "toQuat", "(Lglm_/mat3x3/Mat3;)Lglm_/quat/Quat;", "(Lglm_/mat4x4/Mat4;)Lglm_/quat/Quat;", "glm-jdk8"})
public interface gtx_quaternion {
    @NotNull
    public Quat quatIdentity(@NotNull Quat var1);

    @NotNull
    public Vec3 cross(@NotNull Vec3 var1, @NotNull Quat var2, @NotNull Vec3 var3);

    @NotNull
    public Vec3 cross(@NotNull Vec3 var1, @NotNull Vec3 var2, @NotNull Quat var3);

    @NotNull
    public Quat squad(@NotNull Quat var1, @NotNull Quat var2, @NotNull Quat var3, @NotNull Quat var4, float var5);

    @NotNull
    public Quat intermediate(@NotNull Quat var1, @NotNull Quat var2, @NotNull Quat var3);

    @NotNull
    public Vec3 rotate(@NotNull Quat var1, @NotNull Vec3 var2);

    @NotNull
    public Quat rotate(@NotNull Quat var1, @NotNull Vec4 var2);

    public float extractRealComponent(@NotNull Quat var1);

    @NotNull
    public Mat3 toMat3(@NotNull Quat var1);

    @NotNull
    public Mat4 toMat4(@NotNull Quat var1);

    @NotNull
    public Quat toQuat(@NotNull Mat3 var1);

    @NotNull
    public Quat toQuat(@NotNull Mat4 var1);

    @NotNull
    public Quat shortMix(@NotNull Quat var1, @NotNull Quat var2, float var3);

    @NotNull
    public Quat fastMix(@NotNull Quat var1, @NotNull Quat var2, float var3);

    @NotNull
    public Quat rotation(@NotNull Vec3 var1, @NotNull Vec3 var2);

    public float length2(@NotNull Quat var1);

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @NotNull
        public static Quat quatIdentity(@NotNull gtx_quaternion $this, @NotNull Quat res2) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            return res2.put(1.0f, 0.0f, 0.0f, 0.0f);
        }

        public static /* synthetic */ Quat quatIdentity$default(gtx_quaternion gtx_quaternion2, Quat quat, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: quatIdentity");
            }
            if ((n & 1) != 0) {
                quat = new Quat();
            }
            return gtx_quaternion2.quatIdentity(quat);
        }

        @NotNull
        public static Vec3 cross(@NotNull gtx_quaternion $this, @NotNull Vec3 res2, @NotNull Quat q, @NotNull Vec3 v2) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            Intrinsics.checkNotNullParameter((Object)v2, (String)"v");
            float dot = glm.INSTANCE.dot(q, q);
            float w = q.w.floatValue() / dot;
            float x = -q.x.floatValue() / dot;
            float y = -q.y.floatValue() / dot;
            float z = -q.z.floatValue() / dot;
            float uvX = y * v2.getZ().floatValue() - v2.getY().floatValue() * z;
            float uvY = z * v2.getX().floatValue() - v2.getZ().floatValue() * x;
            float uvZ = x * v2.getY().floatValue() - v2.getX().floatValue() * y;
            float uuvX = y * uvZ - uvY * z;
            float uuvY = z * uvX - uvZ * x;
            float uuvZ = x * uvY - uvX * y;
            float resX = v2.getX().floatValue() + (uvX * w + uuvX) * 2.0f;
            float resY = v2.getY().floatValue() + (uvY * w + uuvY) * 2.0f;
            float resZ = v2.getZ().floatValue() + (uvZ * w + uuvZ) * 2.0f;
            return res2.invoke(resX, resY, resZ);
        }

        @NotNull
        public static Vec3 cross(@NotNull gtx_quaternion $this, @NotNull Vec3 res2, @NotNull Vec3 v2, @NotNull Quat q) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)v2, (String)"v");
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            float uvX = q.y.floatValue() * v2.getZ().floatValue() - v2.getY().floatValue() * q.z.floatValue();
            float uvY = q.z.floatValue() * v2.getX().floatValue() - v2.getZ().floatValue() * q.x.floatValue();
            float uvZ = q.x.floatValue() * v2.getY().floatValue() - v2.getX().floatValue() * q.y.floatValue();
            float uuvX = q.y.floatValue() * uvZ - uvY * q.z.floatValue();
            float uuvY = q.z.floatValue() * uvX - uvZ * q.x.floatValue();
            float uuvZ = q.x.floatValue() * uvY - uvX * q.y.floatValue();
            float resX = v2.getX().floatValue() + (uvX * q.w.floatValue() + uuvX) * 2.0f;
            float resY = v2.getY().floatValue() + (uvY * q.w.floatValue() + uuvY) * 2.0f;
            float resZ = v2.getZ().floatValue() + (uvZ * q.w.floatValue() + uuvZ) * 2.0f;
            return res2.invoke(resX, resY, resZ);
        }

        @NotNull
        public static Quat squad(@NotNull gtx_quaternion $this, @NotNull Quat q1, @NotNull Quat q2, @NotNull Quat s1, @NotNull Quat s2, float h) {
            Intrinsics.checkNotNullParameter((Object)q1, (String)"q1");
            Intrinsics.checkNotNullParameter((Object)q2, (String)"q2");
            Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
            Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
            return glm.INSTANCE.mix(glm.INSTANCE.mix(q1, q2, h), glm.INSTANCE.mix(s1, s2, h), (float)2 * (1.0f - h) * h);
        }

        @NotNull
        public static Quat intermediate(@NotNull gtx_quaternion $this, @NotNull Quat prev, @NotNull Quat curr, @NotNull Quat next) {
            Intrinsics.checkNotNullParameter((Object)prev, (String)"prev");
            Intrinsics.checkNotNullParameter((Object)curr, (String)"curr");
            Intrinsics.checkNotNullParameter((Object)next, (String)"next");
            Quat invQuat = Quat.inverse$default(curr, null, 1, null);
            return glm.INSTANCE.exp(glm.INSTANCE.log(next.times(invQuat)).plus(glm.INSTANCE.log(prev.times(invQuat))).div(-4.0f)).times(curr);
        }

        @NotNull
        public static Vec3 rotate(@NotNull gtx_quaternion $this, @NotNull Quat q, @NotNull Vec3 v2) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            Intrinsics.checkNotNullParameter((Object)v2, (String)"v");
            return q.times(v2);
        }

        @NotNull
        public static Quat rotate(@NotNull gtx_quaternion $this, @NotNull Quat q, @NotNull Vec4 v2) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            Intrinsics.checkNotNullParameter((Object)v2, (String)"v");
            return q.times(v2);
        }

        public static float extractRealComponent(@NotNull gtx_quaternion $this, @NotNull Quat q) {
            float f2;
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            float w = 1.0f - q.x.floatValue() * q.x.floatValue() - q.y.floatValue() * q.y.floatValue() - q.z.floatValue() * q.z.floatValue();
            if (w < 0.0f) {
                f2 = 0.0f;
            } else {
                boolean bl = false;
                f2 = -((float)Math.sqrt(w));
            }
            return f2;
        }

        @NotNull
        public static Mat3 toMat3(@NotNull gtx_quaternion $this, @NotNull Quat x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            return x.toMat3();
        }

        @NotNull
        public static Mat4 toMat4(@NotNull gtx_quaternion $this, @NotNull Quat x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            return x.toMat4();
        }

        @NotNull
        public static Quat toQuat(@NotNull gtx_quaternion $this, @NotNull Mat3 x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            return x.toQuat();
        }

        @NotNull
        public static Quat toQuat(@NotNull gtx_quaternion $this, @NotNull Mat4 x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            return x.toQuat();
        }

        @NotNull
        public static Quat shortMix(@NotNull gtx_quaternion $this, @NotNull Quat x, @NotNull Quat y, float a) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter((Object)y, (String)"y");
            if (a <= 0.0f) {
                return x;
            }
            if (a >= 1.0f) {
                return y;
            }
            float fCos = x.dot(y);
            Quat y2 = new Quat(y);
            if (fCos < 0.0f) {
                y2 = y.unaryMinus();
                fCos = -fCos;
            }
            float k0 = 0.0f;
            float k1 = 0.0f;
            if (fCos > 1.0f - glm.epsilonF) {
                k0 = 1.0f - a;
                k1 = 0.0f + a;
            } else {
                float f2 = 1.0f - fCos * fCos;
                boolean bl = false;
                float fSin = (float)Math.sqrt(f2);
                float fAngle = glm.INSTANCE.atan(fSin, fCos);
                float fOneOverSin = 1.0f / fSin;
                float f3 = (1.0f - a) * fAngle;
                boolean bl2 = false;
                k0 = (float)Math.sin(f3) * fOneOverSin;
                f3 = (0.0f + a) * fAngle;
                bl2 = false;
                k1 = (float)Math.sin(f3) * fOneOverSin;
            }
            return new Quat(k0 * x.w.floatValue() + k1 * y2.w.floatValue(), k0 * x.x.floatValue() + k1 * y2.x.floatValue(), k0 * x.y.floatValue() + k1 * y2.y.floatValue(), k0 * x.z.floatValue() + k1 * y2.z.floatValue());
        }

        @NotNull
        public static Quat fastMix(@NotNull gtx_quaternion $this, @NotNull Quat x, @NotNull Quat y, float a) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter((Object)y, (String)"y");
            return ext_QuaternionGeometric.DefaultImpls.normalize$default((ext_QuaternionGeometric)glm.INSTANCE, x.times(1.0f - a).plus(y.times(a)), null, 2, null);
        }

        @NotNull
        public static Quat rotation(@NotNull gtx_quaternion $this, @NotNull Vec3 orig, @NotNull Vec3 dest) {
            Intrinsics.checkNotNullParameter((Object)orig, (String)"orig");
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            float cosTheta = orig.dot(dest);
            if (cosTheta >= 1.0f - glm.epsilonF) {
                return DefaultImpls.quatIdentity$default($this, null, 1, null);
            }
            if (cosTheta < (float)-1 + glm.epsilonF) {
                Vec3 rotationAxis = new Vec3((Number)0, (Number)0, (Number)1).cross(orig);
                if (rotationAxis.length2() < glm.epsilonF) {
                    rotationAxis = new Vec3((Number)1, (Number)0, (Number)0).cross(orig);
                }
                rotationAxis = Vec3.normalize$default(rotationAxis, null, 1, null);
                return glm.INSTANCE.angleAxis(glm.PIf, rotationAxis);
            }
            Vec3 rotationAxis = orig.cross(dest);
            float f2 = (1.0f + cosTheta) * (float)2;
            boolean bl = false;
            float s = (float)Math.sqrt(f2);
            float invs = 1.0f / s;
            return new Quat(s * 0.5f, rotationAxis.getX().floatValue() * invs, rotationAxis.getY().floatValue() * invs, rotationAxis.getZ().floatValue() * invs);
        }

        public static float length2(@NotNull gtx_quaternion $this, @NotNull Quat q) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            return q.dot(q);
        }
    }
}

