/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wirelesschargers;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.wirelesschargers.ChargerBakedItemModel;
import com.supermartijn642.wirelesschargers.ChargerModelType;
import com.supermartijn642.wirelesschargers.ChargerRenderer;
import com.supermartijn642.wirelesschargers.ChargerType;
import com.supermartijn642.wirelesschargers.screen.ChargerScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientProxy {
    @SubscribeEvent
    public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers e) {
        for (ChargerType type : ChargerType.values()) {
            e.registerBlockEntityRenderer(type.getTileEntityType(), context -> new ChargerRenderer());
        }
    }

    @SubscribeEvent
    public static void onModelRegistry(ModelRegistryEvent e) {
        for (ChargerModelType type : ChargerModelType.values()) {
            ForgeModelBakery.addSpecialModel((ResourceLocation)type.ringModel);
        }
    }

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent e) {
        for (ChargerType type : ChargerType.values()) {
            ModelResourceLocation location = new ModelResourceLocation("wirelesschargers:" + type.getRegistryName(), "inventory");
            BakedModel model = (BakedModel)e.getModelRegistry().get(location);
            if (model == null) continue;
            e.getModelRegistry().put(location, new ChargerBakedItemModel(model));
        }
    }

    public static void openChargerScreen(Component title, BlockPos pos) {
        ClientUtils.displayScreen((Screen)new ChargerScreen(title, pos));
    }
}

