/*
 * Decompiled with CFR 0.152.
 */
package appbot.ae2;

import appbot.ae2.P2PModels;
import appeng.api.config.PowerUnits;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.parts.p2p.CapabilityP2PTunnelPart;
import com.google.common.base.Predicates;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaForgeCapabilities;
import vazkii.botania.api.mana.IManaCollector;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.mana.spark.IManaSpark;
import vazkii.botania.api.mana.spark.ISparkAttachable;

public class ManaP2PTunnelPart
extends CapabilityP2PTunnelPart<ManaP2PTunnelPart, IManaReceiver> {
    private static final P2PModels MODELS = new P2PModels("part/mana_p2p_tunnel");
    private final ISparkAttachable sparkAttachable = new ISparkAttachable(){

        public boolean canAttachSpark(ItemStack stack) {
            return true;
        }

        public int getAvailableSpaceForMana() {
            int space = 0;
            for (ManaP2PTunnelPart output : ManaP2PTunnelPart.this.getOutputs()) {
                CapabilityP2PTunnelPart.CapabilityGuard guard = output.getAdjacentCapability();
                try {
                    IManaReceiver receiver = ManaP2PTunnelPart.this.get(guard);
                    if (receiver instanceof ISparkAttachable) {
                        ISparkAttachable sparkAttachable = (ISparkAttachable)receiver;
                        space += sparkAttachable.getAvailableSpaceForMana();
                        continue;
                    }
                    if (receiver instanceof IManaCollector) {
                        IManaCollector collector = (IManaCollector)receiver;
                        space += collector.getMaxMana() - receiver.getCurrentMana();
                        continue;
                    }
                    if (receiver.isFull()) continue;
                    space += 1000;
                }
                finally {
                    if (guard == null) continue;
                    guard.close();
                }
            }
            return space;
        }

        public IManaSpark getAttachedSpark() {
            BlockPos sparkPos = ManaP2PTunnelPart.this.getHost().getLocation().getPos().m_7494_();
            List sparks = ManaP2PTunnelPart.this.getLevel().m_6443_(Entity.class, new AABB(sparkPos, sparkPos.m_142082_(1, 1, 1)), (Predicate)Predicates.instanceOf(IManaSpark.class));
            if (sparks.size() == 1) {
                return (IManaSpark)sparks.get(0);
            }
            return null;
        }

        public boolean areIncomingTranfersDone() {
            for (ManaP2PTunnelPart output : ManaP2PTunnelPart.this.getOutputs()) {
                CapabilityP2PTunnelPart.CapabilityGuard guard = output.getAdjacentCapability();
                try {
                    IManaReceiver receiver = ManaP2PTunnelPart.this.get(guard);
                    if (!receiver.canReceiveManaFromBursts() || receiver.isFull()) continue;
                    boolean bl = true;
                    return bl;
                }
                finally {
                    if (guard == null) continue;
                    guard.close();
                }
            }
            return false;
        }
    };
    private static final MethodHandle GET = (MethodHandle)Util.m_137537_(() -> {
        try {
            Method get = CapabilityP2PTunnelPart.CapabilityGuard.class.getDeclaredMethod("get", new Class[0]);
            get.setAccessible(true);
            return MethodHandles.lookup().unreflect(get);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    });

    public ManaP2PTunnelPart(IPartItem<?> partItem) {
        super(partItem, BotaniaForgeCapabilities.MANA_RECEIVER);
        this.inputHandler = new InputHandler();
        this.outputHandler = this.emptyHandler = new EmptyHandler();
    }

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    @Nullable
    public ISparkAttachable getSparkAttachable() {
        return this.isOutput() ? null : this.sparkAttachable;
    }

    private IManaReceiver get(CapabilityP2PTunnelPart.CapabilityGuard guard) {
        try {
            return (IManaReceiver)GET.invokeExact(guard);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private class InputHandler
    implements IManaReceiver,
    IManaPool {
        private InputHandler() {
        }

        public Level getManaReceiverLevel() {
            return ManaP2PTunnelPart.this.getLevel();
        }

        public BlockPos getManaReceiverPos() {
            return ManaP2PTunnelPart.this.getHost().getLocation().getPos();
        }

        public int getCurrentMana() {
            return 0;
        }

        public boolean isFull() {
            for (ManaP2PTunnelPart output : ManaP2PTunnelPart.this.getOutputs()) {
                CapabilityP2PTunnelPart.CapabilityGuard guard = output.getAdjacentCapability();
                try {
                    if (ManaP2PTunnelPart.this.get(guard).isFull()) continue;
                    boolean bl = false;
                    return bl;
                }
                finally {
                    if (guard == null) continue;
                    guard.close();
                }
            }
            return true;
        }

        public void receiveMana(int mana) {
            List outputs = ManaP2PTunnelPart.this.getOutputStream().filter(part -> {
                try (CapabilityP2PTunnelPart.CapabilityGuard guard = ((ManaP2PTunnelPart)part).getAdjacentCapability();){
                    IManaReceiver receiver = ManaP2PTunnelPart.this.get(guard);
                    boolean bl = receiver.canReceiveManaFromBursts() && !receiver.isFull();
                    return bl;
                }
            }).collect(Collectors.toList());
            if (outputs.isEmpty()) {
                return;
            }
            Collections.shuffle(outputs);
            ManaP2PTunnelPart.this.queueTunnelDrain(PowerUnits.AE, (double)mana / 100.0);
            int manaForEach = mana / outputs.size();
            int spill = mana % outputs.size();
            for (ManaP2PTunnelPart output : outputs) {
                CapabilityP2PTunnelPart.CapabilityGuard guard = output.getAdjacentCapability();
                try {
                    ManaP2PTunnelPart.this.get(guard).receiveMana(manaForEach + (spill-- > 0 ? 1 : 0));
                }
                finally {
                    if (guard == null) continue;
                    guard.close();
                }
            }
        }

        public boolean canReceiveManaFromBursts() {
            for (ManaP2PTunnelPart output : ManaP2PTunnelPart.this.getOutputs()) {
                CapabilityP2PTunnelPart.CapabilityGuard guard = output.getAdjacentCapability();
                try {
                    if (!ManaP2PTunnelPart.this.get(guard).canReceiveManaFromBursts()) continue;
                    boolean bl = true;
                    return bl;
                }
                finally {
                    if (guard == null) continue;
                    guard.close();
                }
            }
            return false;
        }

        public boolean isOutputtingPower() {
            return false;
        }

        public DyeColor getColor() {
            return DyeColor.PURPLE;
        }

        public void setColor(DyeColor color) {
        }
    }

    private class EmptyHandler
    implements IManaReceiver {
        private EmptyHandler() {
        }

        public Level getManaReceiverLevel() {
            return ManaP2PTunnelPart.this.getLevel();
        }

        public BlockPos getManaReceiverPos() {
            return ManaP2PTunnelPart.this.getHost().getLocation().getPos();
        }

        public int getCurrentMana() {
            return 0;
        }

        public boolean isFull() {
            return true;
        }

        public void receiveMana(int mana) {
        }

        public boolean canReceiveManaFromBursts() {
            return false;
        }
    }
}

