/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.world;

import dev.ftb.mods.ftbic.world.ResourceType;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum ResourceElements {
    TIN(Requirements.builder().all().remove(ResourceType.WIRE)),
    LEAD(Requirements.builder().all().remove(ResourceType.WIRE)),
    URANIUM(Requirements.builder().all().remove(ResourceType.WIRE)),
    IRIDIUM(Requirements.builder().all().remove(ResourceType.WIRE)),
    ALUMINUM,
    DEEPSLATE_TIN(Requirements.builder().add(ResourceType.ORE)),
    DEEPSLATE_LEAD(Requirements.builder().add(ResourceType.ORE)),
    DEEPSLATE_URANIUM(Requirements.builder().add(ResourceType.ORE)),
    DEEPSLATE_IRIDIUM(Requirements.builder().add(ResourceType.ORE)),
    DEEPSLATE_ALUMINUM(Requirements.builder().add(ResourceType.ORE)),
    ENDERIUM(Requirements.builder().all().remove(ResourceType.ORE, ResourceType.CHUNK)),
    DIAMOND(Requirements.builder().add(ResourceType.DUST)),
    BRONZE(Requirements.builder().all().remove(ResourceType.ORE, ResourceType.CHUNK, ResourceType.WIRE)),
    IRON(Requirements.builder().all().remove(ResourceType.ORE, ResourceType.INGOT, ResourceType.BLOCK, ResourceType.CHUNK, ResourceType.NUGGET, ResourceType.WIRE)),
    COPPER(Requirements.builder().all().remove(ResourceType.ORE, ResourceType.INGOT, ResourceType.BLOCK, ResourceType.CHUNK)),
    GOLD(Requirements.builder().all().remove(ResourceType.ORE, ResourceType.INGOT, ResourceType.BLOCK, ResourceType.CHUNK, ResourceType.NUGGET)),
    OBSIDIAN(Requirements.builder().add(ResourceType.DUST)),
    ENDER(Requirements.builder().add(ResourceType.DUST)),
    COAL(Requirements.builder().add(ResourceType.DUST)),
    CHARCOAL(Requirements.builder().add(ResourceType.DUST));

    public static final List<ResourceElements> VALUES;
    public static final Map<ResourceType, List<ResourceElements>> RESOURCES_BY_REQUIREMENT;
    private final Requirements requirements;

    private ResourceElements(Requirements requirements) {
        this.requirements = requirements;
    }

    private ResourceElements() {
        this(Requirements.builder().all());
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    public Requirements requirements() {
        return this.requirements;
    }

    public static Optional<ResourceElements> getNonDeepslateVersion(ResourceElements element) {
        String name = element.getName().replace("deepslate_", "");
        return VALUES.stream().filter(e -> e.getName().equals(name)).findFirst();
    }

    static {
        VALUES = Arrays.stream(ResourceElements.values()).sorted(Comparator.comparing(ResourceElements::getName)).toList();
        RESOURCES_BY_REQUIREMENT = ResourceType.VALUES.stream().collect(Collectors.toMap(Function.identity(), e -> VALUES.stream().filter(a -> a.requirements.has((ResourceType)((Object)e))).collect(Collectors.toList())));
    }

    public static class Requirements {
        private int requirements = 0;

        private Requirements() {
        }

        public boolean has(ResourceType type) {
            return (this.requirements & type.bit) != 0;
        }

        public static Requirements builder() {
            return new Requirements();
        }

        public Requirements all() {
            this.requirements = -1;
            return this;
        }

        public Requirements add(ResourceType ... type) {
            for (ResourceType resourceType : type) {
                this.requirements |= resourceType.bit;
            }
            return this;
        }

        public Requirements remove(ResourceType ... type) {
            for (ResourceType resourceType : type) {
                this.requirements &= ~resourceType.bit;
            }
            return this;
        }
    }
}

