/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.util;

import com.mojang.authlib.GameProfile;
import dev.ftb.mods.ftbic.FTBIC;
import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.block.FTBICBlocks;
import dev.ftb.mods.ftbic.util.FTBChunksIntegration;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.FakePlayer;

public class NuclearExplosion
extends Thread
implements Comparator<NukeTask> {
    public static final int FLAG_IN_EXPLOSION = 1;
    public static final int FLAG_IS_REINFORCED = 2;
    public static final int FLAG_DESTROY = 4;
    public static final int FLAG_IS_AIR = 8;
    public static final int FLAG_IS_BLOCK = 16;
    public static final int FLAG_INSIDE = 32;
    public static final int FLAG_OUTSIDE = 64;
    public static final Runnable NO_ACTION = () -> {};
    public final MinecraftServer server;
    public final ServerLevel level;
    public final BlockPos pos;
    public final double radius;
    public final List<NukeTask> tasks;
    public final UUID owner;
    public final String ownerName;
    public final long delay;
    public final Runnable preExplosion;

    public static boolean hasFlag(int flags, int flag) {
        return (flags & flag) != 0;
    }

    public static boolean hasFlag(int flags, int flag1, int flag2) {
        return NuclearExplosion.hasFlag(flags, flag1) && NuclearExplosion.hasFlag(flags, flag2);
    }

    public static boolean hasFlag(int flags, int flag1, int flag2, int flag3) {
        return NuclearExplosion.hasFlag(flags, flag1) && NuclearExplosion.hasFlag(flags, flag2) && NuclearExplosion.hasFlag(flags, flag3);
    }

    public static int removeFlag(int flags, int flag) {
        return flags & ~flag;
    }

    public static Builder builder(ServerLevel level, BlockPos pos, double radius, UUID owner, String ownerName) {
        return new Builder(level, pos, radius, owner, ownerName);
    }

    private NuclearExplosion(ServerLevel level, BlockPos pos, double radius, UUID owner, String ownerName, long delay, Runnable preExplosion) {
        super("NuclearExplosion/dn=" + level.m_46472_().m_135782_().m_135827_() + "/dp=" + level.m_46472_().m_135782_().m_135815_() + "/p=" + pos.m_123341_() + "," + pos.m_123342_() + "," + pos.m_123343_() + "/r=" + radius + "/o=" + owner + "/on=" + ownerName);
        this.server = level.m_142572_();
        this.level = level;
        this.pos = pos;
        this.radius = Math.min(radius, 100.0);
        this.tasks = new ArrayList<NukeTask>();
        this.owner = owner;
        this.ownerName = ownerName;
        this.delay = delay;
        this.preExplosion = preExplosion;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        void var33_47;
        int oldLight;
        int flags;
        long startTime = System.currentTimeMillis();
        int rxz = Mth.m_14165_((double)this.radius);
        double ry = Math.min(this.radius * 0.75, 60.0);
        double rys = ry / this.radius;
        int ry0 = Math.max(this.pos.m_123342_() - Mth.m_14165_((double)(ry * 2.0)), this.level.m_141937_());
        int ry1 = Math.min(this.pos.m_123342_() + Mth.m_14165_((double)(ry * 2.0)), this.level.m_141928_()) - 1;
        double rsq = this.radius * this.radius;
        double rsqc = this.radius * 0.65 * (this.radius * 0.65);
        long seed = System.currentTimeMillis() + (long)this.pos.hashCode();
        Random random0 = new Random(seed);
        Random random = new Random(seed);
        int volume = 0;
        for (int x = -rxz; x <= rxz; ++x) {
            for (int z = -rxz; z <= rxz; ++z) {
                for (int y = ry1; y >= ry0; --y) {
                    int y0 = y - this.pos.m_123342_();
                    double y1 = (double)y0 / rys;
                    double dist = ((double)(x * x) + y1 * y1 + (double)(z * z)) / (1.0 - random0.nextDouble() * 0.25);
                    if (!(dist <= rsq)) continue;
                    ++volume;
                }
            }
        }
        FTBIC.LOGGER.warn(String.format("%s/%s created a nuclear explosion with radius %f at %s:%d,%d,%d with up to %d blocks to check", this.ownerName, this.owner, this.radius, this.level.m_46472_().m_135782_(), this.pos.m_123341_(), this.pos.m_123342_(), this.pos.m_123343_(), volume));
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
        Object2IntOpenHashMap blocks = new Object2IntOpenHashMap(volume);
        blocks.defaultReturnValue(0);
        ArrayList<BlockPos> crust = new ArrayList<BlockPos>();
        FakePlayer player = new FakePlayer(this.level, new GameProfile(this.owner, this.ownerName));
        player.m_6034_((double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 0.5, (double)this.pos.m_123343_() + 0.5);
        for (int x = -rxz; x <= rxz; ++x) {
            for (int z = -rxz; z <= rxz; ++z) {
                boolean blockProtected;
                mpos.m_122178_(this.pos.m_123341_() + x, 0, this.pos.m_123343_() + z);
                boolean bl = blockProtected = FTBChunksIntegration.instance.isProtected(this.level, (BlockPos)mpos, this.owner) || !this.level.m_7966_((Player)player, (BlockPos)mpos);
                if (!this.level.m_46739_((BlockPos)mpos)) continue;
                for (int y = ry1; y >= ry0; --y) {
                    int y0 = y - this.pos.m_123342_();
                    double y1 = (double)y0 / rys;
                    double dist = ((double)(x * x) + y1 * y1 + (double)(z * z)) / (1.0 - random.nextDouble() * 0.25);
                    if (!(dist <= rsq)) continue;
                    mpos.m_142448_(y);
                    if (this.level.m_151570_((BlockPos)mpos)) continue;
                    BlockPos ipos = mpos.m_7949_();
                    try {
                        BlockState blockState = this.level.m_8055_((BlockPos)mpos);
                        if (blockProtected) {
                            blocks.put((Object)ipos, 35);
                        } else if (blockState.m_60795_()) {
                            blocks.put((Object)ipos, 41);
                        } else if (blockState.m_204336_(FTBICUtils.REINFORCED) || blockState.m_60800_((BlockGetter)this.level, (BlockPos)mpos) < 0.0f) {
                            blocks.put((Object)ipos, 35);
                        } else {
                            blocks.put((Object)ipos, 49);
                        }
                    }
                    catch (Exception exception) {
                        FTBIC.LOGGER.warn("Error while calculating nuclear explosion", (Throwable)exception);
                        blocks.put((Object)ipos, 35);
                    }
                    if (!(dist >= rsqc)) continue;
                    crust.add(ipos);
                }
            }
        }
        crust.removeIf(new CrustFilter((Object2IntMap<BlockPos>)blocks, mpos));
        ArrayList<NukeTask> tasks = new ArrayList<NukeTask>();
        BlockState air = Blocks.f_50016_.m_49966_();
        BlockState podzol = Blocks.f_50599_.m_49966_();
        BlockState coarseDirt = Blocks.f_50546_.m_49966_();
        BlockState fire = Blocks.f_50083_.m_49966_();
        BlockState cobble = Blocks.f_50652_.m_49966_();
        BlockState exfluid = FTBICBlocks.EXFLUID.get().m_49966_();
        if (!NuclearExplosion.hasFlag(blocks.getOrDefault((Object)this.pos, 0), 2)) {
            tasks.add(new BlockModification(this.pos, air, 3, rxz));
        }
        double step = 0.5;
        block18: for (BlockPos blockPos : crust) {
            int flags2 = blocks.getOrDefault((Object)blockPos, 0);
            if (NuclearExplosion.hasFlag(flags2, 1)) {
                blocks.put((Object)blockPos, NuclearExplosion.removeFlag(flags2 | 0x40, 32));
            }
            int x0 = this.pos.m_123341_() - blockPos.m_123341_();
            int y0 = this.pos.m_123342_() - blockPos.m_123342_();
            int z0 = this.pos.m_123343_() - blockPos.m_123343_();
            int distSq = x0 * x0 + y0 * y0 + z0 * z0;
            double dist = Math.sqrt(distSq);
            int px = 0;
            int py = 0;
            int pz = 0;
            for (double l = 0.0; l <= dist; l += step) {
                int x = Mth.m_14107_((double)((double)x0 * l / dist + 0.5));
                int y = Mth.m_14107_((double)((double)y0 * l / dist + 0.5));
                int z = Mth.m_14107_((double)((double)z0 * l / dist + 0.5));
                if (px == x && py == y && pz == z) continue;
                px = x;
                py = y;
                pz = z;
                mpos.m_122178_(this.pos.m_123341_() + x, this.pos.m_123342_() + y, this.pos.m_123343_() + z);
                int flags1 = blocks.getOrDefault((Object)mpos, 0);
                if (NuclearExplosion.hasFlag(flags1, 2)) continue block18;
                if (!NuclearExplosion.hasFlag(flags1, 1) || NuclearExplosion.hasFlag(flags1, 4)) continue;
                BlockPos p1 = mpos.m_7949_();
                blocks.put((Object)p1, flags1 | 4);
            }
        }
        ArrayList<Object2IntMap.Entry> destroyEntries = new ArrayList<Object2IntMap.Entry>();
        block20: for (Object2IntMap.Entry entry : blocks.object2IntEntrySet()) {
            flags = entry.getIntValue();
            if (NuclearExplosion.hasFlag(flags, 2) || NuclearExplosion.hasFlag(flags, 4)) continue;
            BlockPos p = (BlockPos)entry.getKey();
            int x0 = this.pos.m_123341_() - p.m_123341_();
            int y0 = this.pos.m_123342_() - p.m_123342_();
            int z0 = this.pos.m_123343_() - p.m_123343_();
            int distSq = x0 * x0 + y0 * y0 + z0 * z0;
            double dist = Math.sqrt(distSq);
            int px = 0;
            int py = 0;
            int pz = 0;
            for (double l = 0.0; l <= dist; l += step) {
                int x = Mth.m_14107_((double)((double)x0 * l / dist + 0.5));
                int y = Mth.m_14107_((double)((double)y0 * l / dist + 0.5));
                int z = Mth.m_14107_((double)((double)z0 * l / dist + 0.5));
                if (px == x && py == y && pz == z) continue;
                px = x;
                py = y;
                pz = z;
                mpos.m_122178_(this.pos.m_123341_() + x, this.pos.m_123342_() + y, this.pos.m_123343_() + z);
                int flags1 = blocks.getOrDefault((Object)mpos, 0);
                if (NuclearExplosion.hasFlag(flags1, 2)) continue block20;
                if (!NuclearExplosion.hasFlag(flags1, 1) || NuclearExplosion.hasFlag(flags1, 4)) continue;
                destroyEntries.add(entry);
            }
        }
        for (Object2IntMap.Entry entry : destroyEntries) {
            entry.setValue(entry.getIntValue() | 4);
        }
        for (Object2IntMap.Entry entry : blocks.object2IntEntrySet()) {
            flags = entry.getIntValue();
            if (!NuclearExplosion.hasFlag(flags, 4, 32, 16)) continue;
            try {
                BlockPos p = (BlockPos)entry.getKey();
                BlockState state = this.level.m_8055_(p);
                oldLight = state.getLightEmission((BlockGetter)this.level, this.pos);
                int oldOpacity = state.m_60739_((BlockGetter)this.level, this.pos);
                tasks.add(new BlockModification(p, air, 2, 0));
                tasks.add(new LightUpdate(p, state, air, oldLight, oldOpacity));
            }
            catch (Exception ex) {
                FTBIC.LOGGER.warn("Error while calculating nuclear explosion", (Throwable)ex);
            }
        }
        for (Object2IntMap.Entry entry : blocks.object2IntEntrySet()) {
            int oldOpacity;
            BlockState state;
            BlockPos p;
            flags = entry.getIntValue();
            if (NuclearExplosion.hasFlag(flags, 4, 16, 64)) {
                try {
                    p = (BlockPos)entry.getKey();
                    state = this.level.m_8055_(p);
                    oldLight = state.getLightEmission((BlockGetter)this.level, this.pos);
                    oldOpacity = state.m_60739_((BlockGetter)this.level, this.pos);
                    if (state.m_60734_() instanceof GrassBlock) {
                        tasks.add(new BlockModification(p, podzol));
                        tasks.add(new LightUpdate(p, state, podzol, oldLight, oldOpacity));
                        continue;
                    }
                    if (state.m_204336_(BlockTags.f_144274_)) {
                        tasks.add(new BlockModification(p, coarseDirt));
                        tasks.add(new LightUpdate(p, state, coarseDirt, oldLight, oldOpacity));
                        continue;
                    }
                    if (state.m_60767_() == Material.f_76278_ || state.m_204336_(Tags.Blocks.GRAVEL) || state.m_204336_(Tags.Blocks.SAND)) {
                        if (random.nextInt(10) == 0) {
                            BlockPos above;
                            int aboveFlags;
                            BlockState burnt = this.getBurntBlock(random);
                            tasks.add(new BlockModification(p, burnt));
                            tasks.add(new LightUpdate(p, state, burnt, oldLight, oldOpacity));
                            if (random.nextInt(8) != 0 || !NuclearExplosion.hasFlag(aboveFlags = blocks.getOrDefault((Object)(above = p.m_7494_()), 0), 32) || NuclearExplosion.hasFlag(aboveFlags, 2)) continue;
                            tasks.add(new BlockModification(above, fire, 3, 64));
                            continue;
                        }
                        tasks.add(new BlockModification(p, cobble));
                        tasks.add(new LightUpdate(p, state, cobble, oldLight, oldOpacity));
                        continue;
                    }
                    if (state.m_60767_().m_76332_() || this.level.m_6425_(p).m_76152_() != Fluids.f_76191_) {
                        tasks.add(new BlockModification(p, exfluid));
                        tasks.add(new LightUpdate(p, state, exfluid, oldLight, oldOpacity));
                        continue;
                    }
                    tasks.add(new LightUpdate(p, state, state, oldLight, oldOpacity));
                }
                catch (Exception ex) {
                    FTBIC.LOGGER.warn("Error while calculating nuclear explosion", (Throwable)ex);
                }
                continue;
            }
            if (!NuclearExplosion.hasFlag(flags, 4, 8, 64)) continue;
            try {
                p = (BlockPos)entry.getKey();
                state = this.level.m_8055_(p);
                oldLight = state.getLightEmission((BlockGetter)this.level, this.pos);
                oldOpacity = state.m_60739_((BlockGetter)this.level, this.pos);
                if (random.nextInt(60) == 0) {
                    tasks.add(new BlockModification(p, exfluid));
                    tasks.add(new LightUpdate(p, state, exfluid, oldLight, oldOpacity));
                    continue;
                }
                tasks.add(new LightUpdate(p, state, state, oldLight, oldOpacity));
            }
            catch (Exception ex) {
                FTBIC.LOGGER.warn("Error while calculating nuclear explosion", (Throwable)ex);
            }
        }
        boolean bl = false;
        for (NukeTask task : tasks) {
            if (!(task instanceof BlockModification)) continue;
            ++var33_47;
        }
        long endTime = System.currentTimeMillis();
        FTBIC.LOGGER.warn(String.format("It modified %d/%d blocks and it took %d ms to calculate", (int)var33_47, blocks.size(), endTime - startTime));
        long delay1 = this.delay - (System.currentTimeMillis() - startTime);
        if (delay1 > 0L) {
            try {
                Thread.sleep(delay1);
            }
            catch (Exception ex) {
                FTBIC.LOGGER.warn("Error while calculating nuclear explosion", (Throwable)ex);
            }
        }
        this.server.m_18689_(this.preExplosion);
        while (!tasks.isEmpty()) {
            int i;
            tasks.sort(this);
            int highestOrder = ((NukeTask)tasks.get(0)).getOrder();
            ArrayList<NukeTask> lowPriority = new ArrayList<NukeTask>();
            ArrayList<List> lists = new ArrayList<List>();
            double group = 1.5;
            for (i = Mth.m_14165_((double)(this.radius / group)); i >= 0; --i) {
                lists.add(new ArrayList());
            }
            for (NukeTask task : tasks) {
                if (task.getOrder() > highestOrder) {
                    lowPriority.add(task);
                    continue;
                }
                ((List)lists.get(Mth.m_14045_((int)Mth.m_14107_((double)task.group(this, group)), (int)0, (int)(lists.size() - 1)))).add(task);
            }
            tasks.clear();
            tasks.addAll(lowPriority);
            lists.removeIf(List::isEmpty);
            int listsSize = lists.size();
            for (i = 0; i < listsSize; ++i) {
                List list = (List)lists.get(i);
                if (!this.server.m_130010_()) {
                    return;
                }
                this.server.m_18689_(() -> this.execute(list));
                if (i == listsSize - 1) continue;
                try {
                    Thread.sleep(Math.min(Math.max((long)((List)lists.get(i + 1)).size() / 20L, 50L), 150L));
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void execute(List<NukeTask> list) {
        boolean blockDrops = this.level.m_46469_().m_46207_(GameRules.f_46136_);
        ((GameRules.BooleanValue)this.level.m_46469_().m_46170_(GameRules.f_46136_)).m_46246_(false, this.server);
        for (NukeTask task : list) {
            task.execute(this);
        }
        ((GameRules.BooleanValue)this.level.m_46469_().m_46170_(GameRules.f_46136_)).m_46246_(blockDrops, this.server);
    }

    private BlockState getBurntBlock(Random random) {
        return switch (random.nextInt(3)) {
            case 0 -> Blocks.f_50450_.m_49966_();
            case 1 -> Blocks.f_50137_.m_49966_();
            default -> Blocks.f_50730_.m_49966_();
        };
    }

    @Override
    public int compare(NukeTask o1, NukeTask o2) {
        int i = o1.getOrder() - o2.getOrder();
        return i == 0 ? o1.compare(this, o2) : i;
    }

    public static final class Builder {
        private final ServerLevel level;
        private final BlockPos pos;
        private final double radius;
        private final UUID owner;
        private final String ownerName;
        private long delay;
        private Runnable preExplosion;

        private Builder(ServerLevel level, BlockPos pos, double radius, UUID owner, String ownerName) {
            this.level = level;
            this.pos = pos;
            this.radius = Math.min(radius, 100.0);
            this.owner = owner;
            this.ownerName = ownerName;
            this.delay = 0L;
            this.preExplosion = NO_ACTION;
        }

        public Builder delay(long delay) {
            this.delay = delay;
            return this;
        }

        public Builder preExplosion(Runnable preExplosion) {
            this.preExplosion = preExplosion;
            return this;
        }

        public void create() {
            NuclearExplosion explosion = new NuclearExplosion(this.level, this.pos, this.radius, this.owner, this.ownerName, this.delay, this.preExplosion);
            if (((Boolean)FTBICConfig.NUCLEAR.NUCLEAR_EXPLOSION_DAEMON_THREAD.get()).booleanValue()) {
                explosion.setDaemon(true);
            }
            explosion.start();
        }
    }

    private record CrustFilter(Object2IntMap<BlockPos> blocks, BlockPos.MutableBlockPos mpos) implements Predicate<BlockPos>
    {
        @Override
        public boolean test(BlockPos pos) {
            for (Direction dir : FTBICUtils.DIRECTIONS) {
                this.mpos.m_122178_(pos.m_123341_() + dir.m_122429_(), pos.m_123342_() + dir.m_122430_(), pos.m_123343_() + dir.m_122431_());
                if (this.blocks.containsKey((Object)this.mpos)) continue;
                return false;
            }
            return true;
        }
    }

    public static class BlockModification
    extends NukeTask {
        public final BlockState state;
        public final int flags;
        public final int neighborUpdates;

        public BlockModification(BlockPos pos, BlockState state, int flags, int neighborUpdates) {
            super(pos);
            this.state = state;
            this.flags = flags;
            this.neighborUpdates = neighborUpdates;
        }

        public BlockModification(BlockPos pos, BlockState state) {
            this(pos, state, 2, 64);
        }

        @Override
        public int getOrder() {
            return this.state.m_60734_() instanceof FireBlock ? 2 : (this.flags != 2 || this.neighborUpdates != 0 ? 0 : 1);
        }

        @Override
        public void execute(NuclearExplosion explosion) {
            explosion.level.m_6933_(this.pos, this.state, (this.flags & 1) != 0 ? this.flags : this.flags | 0x80, this.neighborUpdates);
        }
    }

    public static class LightUpdate
    extends NukeTask {
        private final BlockState old;
        private final BlockState state;
        private final int oldLight;
        private final int oldOpacity;

        public LightUpdate(BlockPos pos, BlockState old, BlockState state, int oldLight, int oldOpacity) {
            super(pos);
            this.old = old;
            this.state = state;
            this.oldLight = oldLight;
            this.oldOpacity = oldOpacity;
        }

        @Override
        public int getOrder() {
            return 10;
        }

        @Override
        public int compare(NuclearExplosion explosion, NukeTask o) {
            int i = this.horizontalDistance(explosion) - o.horizontalDistance(explosion);
            int y1 = this.pos.m_123342_() - explosion.pos.m_123342_();
            int y2 = o.pos.m_123342_() - explosion.pos.m_123342_();
            return i == 0 ? y1 - y2 : i;
        }

        @Override
        public double group(NuclearExplosion explosion, double group) {
            return Math.sqrt(this.horizontalDistance(explosion)) / group;
        }

        @Override
        public void execute(NuclearExplosion explosion) {
            if (this.state.m_60787_() || this.old.m_60787_() || this.state.m_60739_((BlockGetter)explosion.level, this.pos) != this.oldOpacity || this.state.getLightEmission((BlockGetter)explosion.level, this.pos) != this.oldLight) {
                explosion.level.m_46473_().m_6180_("queueCheckLight");
                explosion.level.m_5518_().m_142202_(this.pos);
                explosion.level.m_46473_().m_7238_();
            }
        }
    }

    public static class NukeTask {
        public final BlockPos pos;

        public NukeTask(BlockPos pos) {
            this.pos = pos;
        }

        public int distance(NuclearExplosion explosion) {
            int x = explosion.pos.m_123341_() - this.pos.m_123341_();
            int y = explosion.pos.m_123342_() - this.pos.m_123342_();
            int z = explosion.pos.m_123343_() - this.pos.m_123343_();
            return x * x + y * y + z * z;
        }

        public int horizontalDistance(NuclearExplosion explosion) {
            int x = explosion.pos.m_123341_() - this.pos.m_123341_();
            int z = explosion.pos.m_123343_() - this.pos.m_123343_();
            return x * x + z * z;
        }

        public int getOrder() {
            return 0;
        }

        public int compare(NuclearExplosion explosion, NukeTask o) {
            return this.distance(explosion) - o.distance(explosion);
        }

        public double group(NuclearExplosion explosion, double group) {
            return Math.sqrt(this.distance(explosion)) / group;
        }

        public void execute(NuclearExplosion explosion) {
        }
    }
}

