/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.util.BurntBlockCondition;
import dev.ftb.mods.ftbic.util.EnergyItemHandler;
import dev.ftb.mods.ftbic.util.FTBChunksIntegration;
import dev.ftb.mods.ftbic.util.FTBChunksIntegrationImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class FTBICUtils {
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setLenient().create();
    public static final TagKey<Block> REINFORCED = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation("ftbic", "reinforced"));
    public static final TagKey<Item> UNCANNABLE_FOOD = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation("ftbic", "uncannable_food"));
    public static final TagKey<Item> NO_AUTO_RECIPE = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation("ftbic", "no_auto_recipe"));
    public static final DeferredRegister<LootItemConditionType> LOOT_REGISTRY = DeferredRegister.create((ResourceKey)Registry.f_122817_, (String)"ftbic");
    public static RegistryObject<LootItemConditionType> BURNT_BLOCK = LOOT_REGISTRY.register("burnt_block", () -> new LootItemConditionType((Serializer)new BurntBlockCondition.Serializer()));
    public static final Direction[] DIRECTIONS = Direction.values();
    public static final Direction[] HORIZONTAL_DIRECTIONS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};

    public static void init() {
        if (ModList.get().isLoaded("ftbchunks")) {
            FTBICUtils.initFTBChunks();
        }
    }

    private static void initFTBChunks() {
        FTBChunksIntegration.instance = new FTBChunksIntegrationImpl();
    }

    public static String formatEnergyValue(double energy) {
        return String.format("%,d", (long)energy);
    }

    public static TextComponent formatEnergy(double energy) {
        return (TextComponent)new TextComponent("").m_130946_(FTBICUtils.formatEnergyValue(energy) + " ").m_7220_(FTBICConfig.ENERGY_FORMAT);
    }

    public static Component energyTooltip(ItemStack stack, EnergyItemHandler itemHandler) {
        return new TextComponent("").m_7220_((Component)FTBICUtils.formatEnergy(itemHandler.getEnergy(stack)).m_130940_(ChatFormatting.GRAY)).m_130946_(" / ").m_7220_((Component)FTBICUtils.formatEnergy(itemHandler.getEnergyCapacity(stack)).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY);
    }

    public static TextComponent formatHeat(int heat) {
        return (TextComponent)new TextComponent("").m_130946_(String.format("%,d ", heat)).m_7220_(FTBICConfig.HEAT_FORMAT);
    }

    public static <T> List<T> listFromJson(JsonObject json, String key, Function<JsonElement, T> function) {
        if (json.has(key)) {
            JsonArray array = json.get(key).getAsJsonArray();
            if (array.size() == 0) {
                return Collections.emptyList();
            }
            if (array.size() == 1) {
                return Collections.singletonList(function.apply(array.get(0)));
            }
            ArrayList<T> list = new ArrayList<T>(array.size());
            for (JsonElement e : array) {
                list.add(function.apply(e));
            }
            return list;
        }
        return Collections.emptyList();
    }

    public static <T> void listToJson(List<T> list, JsonObject json, String key, Function<T, JsonElement> function) {
        JsonArray array = new JsonArray();
        for (T obj : list) {
            array.add(function.apply(obj));
        }
        if (array.size() > 0) {
            json.add(key, (JsonElement)array);
        }
    }

    public static <T> List<T> listFromNet(FriendlyByteBuf buf, Function<FriendlyByteBuf, T> function) {
        int size = buf.m_130242_();
        if (size == 0) {
            return Collections.emptyList();
        }
        if (size == 1) {
            return Collections.singletonList(function.apply(buf));
        }
        ArrayList<T> list = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            list.add(function.apply(buf));
        }
        return list;
    }

    public static <T> void listToNet(List<T> list, FriendlyByteBuf buf, BiConsumer<T, FriendlyByteBuf> function) {
        buf.m_130130_(list.size());
        for (T obj : list) {
            function.accept(obj, buf);
        }
    }

    public static FluidStack fluidFromJson(JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return FluidStack.EMPTY;
        }
        if (element.isJsonObject()) {
            JsonObject o = element.getAsJsonObject();
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(o.get("fluid").getAsString()));
            int amount = o.has("amount") ? o.get("amount").getAsInt() : 1000;
            return new FluidStack(fluid, amount);
        }
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(element.getAsString()));
        return new FluidStack(fluid, 1000);
    }

    public static JsonElement fluidToJson(FluidStack stack) {
        JsonObject json = new JsonObject();
        json.addProperty("fluid", stack.getFluid().getRegistryName().toString());
        json.addProperty("amount", (Number)stack.getAmount());
        return json;
    }

    public static int packInt(int value, int max) {
        if (value <= 30000) {
            return Math.max(value, 0);
        }
        if (value >= max) {
            return Short.MAX_VALUE;
        }
        return Math.min(value, 32000);
    }

    public static int unpackInt(int value, int max) {
        if (value <= 30000) {
            return value;
        }
        if (value == Short.MAX_VALUE) {
            return max;
        }
        return value;
    }
}

