/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.recipe;

import dev.ftb.mods.ftbic.recipe.AntimatterBoostRecipe;
import dev.ftb.mods.ftbic.recipe.BasicGeneratorFuelRecipe;
import dev.ftb.mods.ftbic.recipe.CanningMachineRecipeResults;
import dev.ftb.mods.ftbic.recipe.FTBICRecipes;
import dev.ftb.mods.ftbic.recipe.NoContainer;
import dev.ftb.mods.ftbic.recipe.machines.CompressingRecipeResults;
import dev.ftb.mods.ftbic.recipe.machines.CookingRecipeResults;
import dev.ftb.mods.ftbic.recipe.machines.ExtrudingRecipeResults;
import dev.ftb.mods.ftbic.recipe.machines.MaceratingRecipeResults;
import dev.ftb.mods.ftbic.recipe.machines.ReprocessingRecipeResults;
import dev.ftb.mods.ftbic.recipe.machines.RollingRecipeResults;
import dev.ftb.mods.ftbic.recipe.machines.SeparatingRecipeResults;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class RecipeCache
implements Recipe<NoContainer> {
    public static final ResourceLocation ID = new ResourceLocation("ftbic", "recipe_cache");
    private final Map<Item, Integer> basicGeneratorFuel = new HashMap<Item, Integer>();
    private final Map<Item, Double> antimatterBoost = new HashMap<Item, Double>();
    public final CookingRecipeResults smelting = new CookingRecipeResults(FTBICRecipes.SMELTING, "smelting", (RecipeType<? extends AbstractCookingRecipe>)RecipeType.f_44108_);
    public final MaceratingRecipeResults macerating = new MaceratingRecipeResults();
    public final SeparatingRecipeResults separating = new SeparatingRecipeResults();
    public final CompressingRecipeResults compressing = new CompressingRecipeResults();
    public final RollingRecipeResults rolling = new RollingRecipeResults();
    public final ExtrudingRecipeResults extruding = new ExtrudingRecipeResults();
    public final ReprocessingRecipeResults reprocessing = new ReprocessingRecipeResults();
    public final CanningMachineRecipeResults canning = new CanningMachineRecipeResults();

    @Nullable
    public static RecipeCache get(Level level) {
        Recipe r = level.m_7465_().m_44043_(ID).orElse(null);
        return r instanceof RecipeCache ? (RecipeCache)r : null;
    }

    public boolean matches(NoContainer container, Level level) {
        return false;
    }

    public ItemStack assemble(NoContainer container) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return ID;
    }

    public RecipeSerializer<?> m_7707_() {
        return FTBICRecipes.RECIPE_CACHE.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)FTBICRecipes.RECIPE_CACHE_TYPE.get();
    }

    public int getBasicGeneratorFuelTicks(Level level, ItemStack item) {
        Integer fuel = this.basicGeneratorFuel.get(item.m_41720_());
        if (fuel != null) {
            return fuel;
        }
        for (BasicGeneratorFuelRecipe recipe : level.m_7465_().m_44013_((RecipeType)FTBICRecipes.BASIC_GENERATOR_FUEL_TYPE.get())) {
            if (!recipe.ingredient.test(item)) continue;
            this.basicGeneratorFuel.put(item.m_41720_(), recipe.ticks);
            return recipe.ticks;
        }
        this.basicGeneratorFuel.put(item.m_41720_(), 0);
        return 0;
    }

    public double getAntimatterBoost(Level level, ItemStack item) {
        Double boost = this.antimatterBoost.get(item.m_41720_());
        if (boost != null) {
            return boost;
        }
        for (AntimatterBoostRecipe recipe : level.m_7465_().m_44013_((RecipeType)FTBICRecipes.ANTIMATTER_BOOST_TYPE.get())) {
            if (!recipe.ingredient.test(item)) continue;
            this.antimatterBoost.put(item.m_41720_(), recipe.boost);
            return recipe.boost;
        }
        this.antimatterBoost.put(item.m_41720_(), 0.0);
        return 0.0;
    }
}

