/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.recipe;

import com.google.gson.JsonObject;
import dev.ftb.mods.ftbic.recipe.MachineRecipe;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import dev.ftb.mods.ftbic.util.IngredientWithCount;
import dev.ftb.mods.ftbic.util.StackWithChance;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.Nullable;

public class MachineRecipeSerializer
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<MachineRecipe> {
    public final RecipeType<MachineRecipe> recipeType;
    public int guiWidth = 82;
    public int guiHeight = 54;
    public int energyX = 2;
    public int energyY = 20;
    public int progressX = 24;
    public int progressY = 18;
    public int batteryX = 0;
    public int batteryY = 36;
    public int outputX = 56;
    public int outputY = 14;
    public int inputSlots = 1;
    public int outputSlots = 1;

    public MachineRecipeSerializer(String id) {
        this.recipeType = RecipeType.m_44119_((String)("ftbic:" + id));
    }

    public MachineRecipeSerializer twoInputs() {
        this.energyX = 11;
        this.progressX = 30;
        this.batteryX = 8;
        this.inputSlots = 2;
        return this;
    }

    public MachineRecipeSerializer extraOutput() {
        this.outputSlots = 2;
        this.guiWidth = 103;
        return this;
    }

    public MachineRecipe fromJson(ResourceLocation id, JsonObject json) {
        MachineRecipe recipe = new MachineRecipe(this, id);
        recipe.realRecipe = true;
        recipe.inputItems = FTBICUtils.listFromJson(json, "inputItems", IngredientWithCount::deserialize);
        recipe.inputFluids = FTBICUtils.listFromJson(json, "inputFluids", FTBICUtils::fluidFromJson);
        recipe.outputItems = FTBICUtils.listFromJson(json, "outputItems", StackWithChance::new);
        recipe.outputFluids = FTBICUtils.listFromJson(json, "outputFluids", FTBICUtils::fluidFromJson);
        recipe.processingTime = json.has("processingTime") ? json.get("processingTime").getAsDouble() : 1.0;
        recipe.hideFromJEI = json.has("hideFromJEI") && json.get("hideFromJEI").getAsBoolean();
        return recipe;
    }

    @Nullable
    public MachineRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
        MachineRecipe recipe = new MachineRecipe(this, id);
        recipe.realRecipe = true;
        recipe.inputItems = FTBICUtils.listFromNet(buf, IngredientWithCount::new);
        recipe.inputFluids = FTBICUtils.listFromNet(buf, FluidStack::readFromPacket);
        recipe.outputItems = FTBICUtils.listFromNet(buf, StackWithChance::new);
        recipe.outputFluids = FTBICUtils.listFromNet(buf, FluidStack::readFromPacket);
        recipe.processingTime = buf.readDouble();
        recipe.hideFromJEI = buf.readBoolean();
        return recipe;
    }

    public void toNetwork(FriendlyByteBuf buf, MachineRecipe recipe) {
        FTBICUtils.listToNet(recipe.inputItems, buf, IngredientWithCount::write);
        FTBICUtils.listToNet(recipe.inputFluids, buf, FluidStack::writeToPacket);
        FTBICUtils.listToNet(recipe.outputItems, buf, StackWithChance::write);
        FTBICUtils.listToNet(recipe.outputFluids, buf, FluidStack::writeToPacket);
        buf.writeDouble(recipe.processingTime);
        buf.writeBoolean(recipe.hideFromJEI);
    }
}

