/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.kubejs;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientStackJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.util.ListJS;
import java.util.ArrayList;
import java.util.List;

public class MachineRecipeJS
extends RecipeJS {
    public List<FluidStackJS> inputFluids = new ArrayList<FluidStackJS>();
    public List<FluidStackJS> outputFluids = new ArrayList<FluidStackJS>();

    public void create(ListJS args) {
        for (Object o : ListJS.orSelf((Object)args.get(0))) {
            if (o instanceof FluidStackJS) {
                this.outputFluids.add((FluidStackJS)o);
                continue;
            }
            this.outputItems.add(this.parseResultItem(o));
        }
        for (Object o : ListJS.orSelf((Object)args.get(1))) {
            if (o instanceof FluidStackJS) {
                this.inputFluids.add((FluidStackJS)o);
                continue;
            }
            this.inputItems.add(this.parseIngredientItem(o).asIngredientStack());
        }
    }

    public void deserialize() {
        this.inputItems.addAll(FTBICUtils.listFromJson(this.json, "inputItems", json -> this.parseIngredientItem(json).asIngredientStack()));
        this.inputFluids.addAll(FTBICUtils.listFromJson(this.json, "inputFluids", FluidStackJS::fromJson));
        this.outputItems.addAll(FTBICUtils.listFromJson(this.json, "outputItems", arg_0 -> ((MachineRecipeJS)this).parseResultItem(arg_0)));
        this.outputFluids.addAll(FTBICUtils.listFromJson(this.json, "outputFluids", FluidStackJS::fromJson));
    }

    public void serialize() {
        FTBICUtils.listToJson(this.inputItems, this.json, "inputItems", IngredientJS::toJson);
        FTBICUtils.listToJson(this.inputFluids, this.json, "inputFluids", FluidStackJS::toJson);
        FTBICUtils.listToJson(this.outputItems, this.json, "outputItems", ItemStackJS::toResultJson);
        FTBICUtils.listToJson(this.outputFluids, this.json, "outputFluids", FluidStackJS::toJson);
    }

    public MachineRecipeJS processingTime(double p) {
        this.json.addProperty("processingTime", (Number)p);
        this.save();
        return this;
    }

    public JsonElement serializeIngredientStack(IngredientStackJS in) {
        JsonObject o = new JsonObject();
        o.add("ingredient", in.ingredient.toJson());
        o.addProperty("count", (Number)in.getCount());
        return o;
    }
}

