/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.jei;

import dev.ftb.mods.ftbic.FTBIC;
import dev.ftb.mods.ftbic.block.FTBICElectricBlocks;
import dev.ftb.mods.ftbic.item.FTBICItems;
import dev.ftb.mods.ftbic.jei.MachineRecipeCategory;
import dev.ftb.mods.ftbic.jei.PoweredCraftingTableTransferHandler;
import dev.ftb.mods.ftbic.recipe.FTBICRecipes;
import dev.ftb.mods.ftbic.recipe.MachineRecipe;
import dev.ftb.mods.ftbic.recipe.MachineRecipeSerializer;
import dev.ftb.mods.ftbic.recipe.RecipeCache;
import java.util.HashMap;
import java.util.Map;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@JeiPlugin
public class FTBICJEIPlugin
implements IModPlugin {
    public static final ResourceLocation ID = new ResourceLocation("ftbic", "jei");
    private static final Map<MachineRecipeSerializer, RecipeType<MachineRecipe>> RECIPE_TYPES = new HashMap<MachineRecipeSerializer, RecipeType<MachineRecipe>>();

    public static RecipeType<MachineRecipe> getMachineRecipeType(MachineRecipeSerializer serializer) {
        return RECIPE_TYPES.computeIfAbsent(serializer, key -> new RecipeType(key.getRegistryName(), MachineRecipe.class));
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerItemSubtypes(ISubtypeRegistration r) {
        r.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)FTBICItems.FLUID_CELL.get(), FTBICJEIPlugin::getSubtype);
        r.useNbtForSubtypes(new Item[]{FTBICItems.MECHANICAL_ELYTRA.get(), FTBICItems.CARBON_CHESTPLATE.get(), FTBICItems.QUANTUM_CHESTPLATE.get()});
    }

    public static String getSubtype(ItemStack stack, UidContext context) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null) {
            return nbt.m_128461_("Fluid");
        }
        return "";
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration r) {
        r.addRecipeTransferHandler((IRecipeTransferHandler)new PoweredCraftingTableTransferHandler(r.getTransferHelper()), RecipeTypes.CRAFTING);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration r) {
        r.addRecipeCatalyst(new ItemStack((ItemLike)FTBICItems.IRON_FURNACE.get()), new RecipeType[]{RecipeTypes.SMELTING, RecipeTypes.FUELING});
        r.addRecipeCatalyst(new ItemStack((ItemLike)FTBICElectricBlocks.POWERED_FURNACE.item.get()), new RecipeType[]{RecipeTypes.SMELTING, RecipeTypes.FUELING});
        r.addRecipeCatalyst(new ItemStack((ItemLike)FTBICElectricBlocks.POWERED_FURNACE.item.get()), new RecipeType[]{FTBICJEIPlugin.getMachineRecipeType(FTBICRecipes.SMELTING.get())});
        r.addRecipeCatalyst(new ItemStack((ItemLike)FTBICElectricBlocks.MACERATOR.item.get()), new RecipeType[]{FTBICJEIPlugin.getMachineRecipeType(FTBICRecipes.MACERATING.get())});
        r.addRecipeCatalyst(new ItemStack((ItemLike)FTBICElectricBlocks.CENTRIFUGE.item.get()), new RecipeType[]{FTBICJEIPlugin.getMachineRecipeType(FTBICRecipes.SEPARATING.get())});
        r.addRecipeCatalyst(new ItemStack((ItemLike)FTBICElectricBlocks.COMPRESSOR.item.get()), new RecipeType[]{FTBICJEIPlugin.getMachineRecipeType(FTBICRecipes.COMPRESSING.get())});
        r.addRecipeCatalyst(new ItemStack((ItemLike)FTBICElectricBlocks.REPROCESSOR.item.get()), new RecipeType[]{FTBICJEIPlugin.getMachineRecipeType(FTBICRecipes.REPROCESSING.get())});
        r.addRecipeCatalyst(new ItemStack((ItemLike)FTBICElectricBlocks.CANNING_MACHINE.item.get()), new RecipeType[]{FTBICJEIPlugin.getMachineRecipeType(FTBICRecipes.CANNING.get())});
        r.addRecipeCatalyst(new ItemStack((ItemLike)FTBICElectricBlocks.ROLLER.item.get()), new RecipeType[]{FTBICJEIPlugin.getMachineRecipeType(FTBICRecipes.ROLLING.get())});
        r.addRecipeCatalyst(new ItemStack((ItemLike)FTBICElectricBlocks.EXTRUDER.item.get()), new RecipeType[]{FTBICJEIPlugin.getMachineRecipeType(FTBICRecipes.EXTRUDING.get())});
        r.addRecipeCatalyst(new ItemStack((ItemLike)FTBICElectricBlocks.ADVANCED_POWERED_FURNACE.item.get()), new RecipeType[]{FTBICJEIPlugin.getMachineRecipeType(FTBICRecipes.SMELTING.get())});
        r.addRecipeCatalyst(new ItemStack((ItemLike)FTBICElectricBlocks.ADVANCED_POWERED_FURNACE.item.get()), new RecipeType[]{RecipeTypes.SMELTING, RecipeTypes.FUELING});
        r.addRecipeCatalyst(new ItemStack((ItemLike)FTBICElectricBlocks.ADVANCED_MACERATOR.item.get()), new RecipeType[]{FTBICJEIPlugin.getMachineRecipeType(FTBICRecipes.MACERATING.get())});
        r.addRecipeCatalyst(new ItemStack((ItemLike)FTBICElectricBlocks.ADVANCED_CENTRIFUGE.item.get()), new RecipeType[]{FTBICJEIPlugin.getMachineRecipeType(FTBICRecipes.SEPARATING.get())});
        r.addRecipeCatalyst(new ItemStack((ItemLike)FTBICElectricBlocks.ADVANCED_COMPRESSOR.item.get()), new RecipeType[]{FTBICJEIPlugin.getMachineRecipeType(FTBICRecipes.COMPRESSING.get())});
    }

    public void registerRecipes(IRecipeRegistration r) {
        RecipeCache cache;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        RecipeCache recipeCache = cache = level == null ? null : RecipeCache.get((Level)Minecraft.m_91087_().f_91073_);
        if (cache == null) {
            FTBIC.LOGGER.error("Recipe cache not found for JEI plugin!");
            return;
        }
        r.addRecipes(FTBICJEIPlugin.getMachineRecipeType(FTBICRecipes.SMELTING.get()), cache.smelting.getAllRealAndVisibleRecipes((Level)level));
        r.addRecipes(FTBICJEIPlugin.getMachineRecipeType(FTBICRecipes.MACERATING.get()), cache.macerating.getAllVisibleRecipes((Level)level));
        r.addRecipes(FTBICJEIPlugin.getMachineRecipeType(FTBICRecipes.COMPRESSING.get()), cache.compressing.getAllVisibleRecipes((Level)level));
        r.addRecipes(FTBICJEIPlugin.getMachineRecipeType(FTBICRecipes.SEPARATING.get()), cache.separating.getAllVisibleRecipes((Level)level));
        r.addRecipes(FTBICJEIPlugin.getMachineRecipeType(FTBICRecipes.REPROCESSING.get()), cache.reprocessing.getAllVisibleRecipes((Level)level));
        r.addRecipes(FTBICJEIPlugin.getMachineRecipeType(FTBICRecipes.CANNING.get()), cache.canning.getAllVisibleRecipes((Level)level));
        r.addRecipes(FTBICJEIPlugin.getMachineRecipeType(FTBICRecipes.ROLLING.get()), cache.rolling.getAllVisibleRecipes((Level)level));
        r.addRecipes(FTBICJEIPlugin.getMachineRecipeType(FTBICRecipes.EXTRUDING.get()), cache.extruding.getAllVisibleRecipes((Level)level));
    }

    public void registerCategories(IRecipeCategoryRegistration r) {
        r.addRecipeCategories(new IRecipeCategory[]{new MachineRecipeCategory(FTBICRecipes.SMELTING, r.getJeiHelpers().getGuiHelper(), FTBICElectricBlocks.POWERED_FURNACE)});
        r.addRecipeCategories(new IRecipeCategory[]{new MachineRecipeCategory(FTBICRecipes.MACERATING, r.getJeiHelpers().getGuiHelper(), FTBICElectricBlocks.MACERATOR)});
        r.addRecipeCategories(new IRecipeCategory[]{new MachineRecipeCategory(FTBICRecipes.SEPARATING, r.getJeiHelpers().getGuiHelper(), FTBICElectricBlocks.CENTRIFUGE)});
        r.addRecipeCategories(new IRecipeCategory[]{new MachineRecipeCategory(FTBICRecipes.COMPRESSING, r.getJeiHelpers().getGuiHelper(), FTBICElectricBlocks.COMPRESSOR)});
        r.addRecipeCategories(new IRecipeCategory[]{new MachineRecipeCategory(FTBICRecipes.REPROCESSING, r.getJeiHelpers().getGuiHelper(), FTBICElectricBlocks.REPROCESSOR)});
        r.addRecipeCategories(new IRecipeCategory[]{new MachineRecipeCategory(FTBICRecipes.CANNING, r.getJeiHelpers().getGuiHelper(), FTBICElectricBlocks.CANNING_MACHINE)});
        r.addRecipeCategories(new IRecipeCategory[]{new MachineRecipeCategory(FTBICRecipes.ROLLING, r.getJeiHelpers().getGuiHelper(), FTBICElectricBlocks.ROLLER)});
        r.addRecipeCategories(new IRecipeCategory[]{new MachineRecipeCategory(FTBICRecipes.EXTRUDING, r.getJeiHelpers().getGuiHelper(), FTBICElectricBlocks.EXTRUDER)});
    }
}

