/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.item.reactor;

import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.block.entity.generator.NuclearReactorBlockEntity;
import dev.ftb.mods.ftbic.item.reactor.BaseReactorItem;
import dev.ftb.mods.ftbic.item.reactor.NeutronReflectingReactorItem;
import dev.ftb.mods.ftbic.item.reactor.NuclearReactor;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class FuelRodItem
extends BaseReactorItem
implements NeutronReflectingReactorItem {
    public final int rods;
    public final int pulses;
    public final double energyMultiplier;
    public final double heatMultiplier;

    public FuelRodItem(int durability, int r, double e, double h) {
        super(durability);
        this.rods = r;
        this.pulses = this.rods == 1 ? 1 : (this.rods == 2 ? 2 : 3);
        this.energyMultiplier = e;
        this.heatMultiplier = h;
    }

    @Override
    public void reactorInfo(ItemStack stack, List<Component> list, boolean shift, boolean advanced, @Nullable NuclearReactor reactor, int x, int y) {
        list.add((Component)new TextComponent(String.format("Lifespan: %,d s", stack.m_41776_() - stack.m_41773_())).m_130940_(ChatFormatting.GRAY));
        int p = this.pulses;
        if (reactor != null) {
            for (int i = 0; i < 4; ++i) {
                if (!(reactor.getAt(x + NuclearReactorBlockEntity.OFFSET_X[i], y + NuclearReactorBlockEntity.OFFSET_Y[i]).m_41720_() instanceof NeutronReflectingReactorItem)) continue;
                ++p;
            }
        }
        list.add((Component)new TextComponent("Energy Output: ").m_7220_((Component)FTBICUtils.formatEnergy((double)p * this.energyMultiplier)).m_130946_("/t").m_130940_(ChatFormatting.GRAY));
        list.add((Component)new TextComponent("Heat Produced: ").m_7220_((Component)FTBICUtils.formatHeat((int)(this.heatMultiplier * (double)p * (double)(p + 1)))).m_130946_("/s").m_130940_(ChatFormatting.GRAY));
    }

    @Override
    public int getRods(ItemStack stack) {
        return this.rods;
    }

    @Override
    public boolean keepSimulationRunning(ItemStack stack) {
        return true;
    }

    @Override
    public void reactorTickPre(NuclearReactor reactor, ItemStack stack, int x, int y) {
        if (reactor.paused) {
            return;
        }
        reactor.explosionRadius += (double)this.getRods(stack) * (Double)FTBICConfig.NUCLEAR.NUCLEAR_REACTOR_EXPLOSION_MULTIPLIER.get();
    }

    @Override
    public void reactorTickPost(NuclearReactor reactor, ItemStack stack, int x, int y) {
        if (reactor.paused) {
            return;
        }
        int p = this.pulses;
        ItemStack[] around = new ItemStack[4];
        for (int i = 0; i < 4; ++i) {
            around[i] = reactor.getAt(x + NuclearReactorBlockEntity.OFFSET_X[i], y + NuclearReactorBlockEntity.OFFSET_Y[i]);
            if (!(around[i].m_41720_() instanceof NeutronReflectingReactorItem)) continue;
            ++p;
        }
        reactor.energyOutput += (double)p * this.energyMultiplier;
        reactor.distributeHeat(around, (int)(this.heatMultiplier * (double)p * (double)(p + 1)));
        this.damageReactorItem(stack, 1);
    }
}

