/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.item;

import dev.ftb.mods.ftbic.FTBIC;
import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.item.FluidCellHandler;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class FluidCellItem
extends Item {
    public static final String TAG_FLUID = "Fluid";

    public FluidCellItem() {
        super(new Item.Properties().m_41487_(16).m_41491_(FTBIC.TAB));
    }

    public boolean hasContainerItem(ItemStack stack) {
        return FluidCellItem.getFluid(stack) != Fluids.f_76191_;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        Fluid fluid = FluidCellItem.getFluid(stack);
        if (fluid != Fluids.f_76191_) {
            return new ItemStack((ItemLike)this);
        }
        return ItemStack.f_41583_;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        BucketItem bucketItem;
        BucketPickup bucketPickup;
        ItemStack fluidItem;
        Item item;
        BlockState state;
        Block block;
        BlockHitResult hit;
        ItemStack stack = player.m_21120_(hand);
        InteractionResultHolder ret = ForgeEventFactory.onBucketUse((Player)player, (Level)level, (ItemStack)stack, (HitResult)(hit = FluidCellItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY)));
        if (ret != null) {
            return ret;
        }
        if (hit.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (hit.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (FluidCellItem.getFluid(stack) != Fluids.f_76191_) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        BlockPos pos = hit.m_82425_();
        Direction direction = hit.m_82434_();
        BlockPos pos1 = pos.m_142300_(direction);
        if (level.m_7966_(player, pos) && player.m_36204_(pos1, direction, stack) && (block = (state = level.m_8055_(pos)).m_60734_()) instanceof BucketPickup && (item = (fluidItem = (bucketPickup = (BucketPickup)block).m_142598_((LevelAccessor)level, pos, state)).m_41720_()) instanceof BucketItem && (bucketItem = (BucketItem)item).getFluid() != Fluids.f_76191_) {
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            bucketPickup.getPickupSound(state).ifPresent(soundevent -> player.m_5496_(soundevent, 1.0f, 1.0f));
            ItemStack itemstack1 = ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)FluidCellItem.setFluid(new ItemStack((ItemLike)this), bucketItem.getFluid()));
            if (!level.m_5776_()) {
                CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, fluidItem);
            }
            return InteractionResultHolder.m_19092_((Object)itemstack1, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new FluidCellHandler(stack);
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> list) {
        if (this.m_41389_(tab)) {
            list.add((Object)new ItemStack((ItemLike)this));
            for (Fluid fluid : ForgeRegistries.FLUIDS) {
                if (fluid == Fluids.f_76191_ || !fluid.m_7444_(fluid.m_76145_()) || !((Boolean)FTBICConfig.NUCLEAR.ADD_ALL_FLUID_CELLS.get()).booleanValue() && fluid.getRegistryName().m_135815_().contains("molten")) continue;
                list.add((Object)FluidCellItem.setFluid(new ItemStack((ItemLike)this), fluid));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        Fluid fluid = FluidCellItem.getFluid(stack);
        if (fluid != Fluids.f_76191_) {
            list.add((Component)new TextComponent("< " + FTBICConfig.NUCLEAR.FLUID_CELL_CAPACITY.get() + " mB of ").m_7220_((Component)new TranslatableComponent(fluid.getAttributes().getTranslationKey())).m_130946_(" >").m_130940_(ChatFormatting.GRAY));
        }
    }

    public static ItemStack setFluid(ItemStack stack, Fluid fluid) {
        if (fluid == Fluids.f_76191_) {
            CompoundTag nbt = stack.m_41783_();
            if (nbt != null) {
                nbt.m_128473_(TAG_FLUID);
                if (nbt.m_128456_()) {
                    stack.m_41751_(null);
                }
            }
        } else {
            CompoundTag nbt = stack.m_41784_();
            nbt.m_128359_(TAG_FLUID, Objects.requireNonNull(fluid.getRegistryName()).toString());
        }
        return stack;
    }

    public static Fluid getFluid(ItemStack stack) {
        Fluid fluid;
        ResourceLocation location;
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && (location = ResourceLocation.m_135820_((String)nbt.m_128461_(TAG_FLUID))) != null && ForgeRegistries.FLUIDS.containsKey(location) && (fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(location)) != null) {
            return fluid;
        }
        return Fluids.f_76191_;
    }
}

