/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.item;

import dev.ftb.mods.ftbic.FTBIC;
import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.block.FTBICBlocks;
import dev.ftb.mods.ftbic.item.BatteryItem;
import dev.ftb.mods.ftbic.item.BatteryType;
import dev.ftb.mods.ftbic.item.CannedFoodItem;
import dev.ftb.mods.ftbic.item.DummyEnergyArmorItem;
import dev.ftb.mods.ftbic.item.EnergyArmorItem;
import dev.ftb.mods.ftbic.item.FluidCellItem;
import dev.ftb.mods.ftbic.item.MaterialItem;
import dev.ftb.mods.ftbic.item.MechanicalElytraItem;
import dev.ftb.mods.ftbic.item.NukeArrowItem;
import dev.ftb.mods.ftbic.item.ProteinBarItem;
import dev.ftb.mods.ftbic.item.ResourceItem;
import dev.ftb.mods.ftbic.item.SprayPaintCanItem;
import dev.ftb.mods.ftbic.item.UpgradeItem;
import dev.ftb.mods.ftbic.item.reactor.CoolantItem;
import dev.ftb.mods.ftbic.item.reactor.FuelRodItem;
import dev.ftb.mods.ftbic.item.reactor.HeatExchangerItem;
import dev.ftb.mods.ftbic.item.reactor.HeatVentItem;
import dev.ftb.mods.ftbic.item.reactor.NeutronReflectorItem;
import dev.ftb.mods.ftbic.item.reactor.ReactorPlatingItem;
import dev.ftb.mods.ftbic.util.EnergyArmorMaterial;
import dev.ftb.mods.ftbic.util.EnergyTier;
import dev.ftb.mods.ftbic.world.ResourceElements;
import dev.ftb.mods.ftbic.world.ResourceType;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public interface FTBICItems {
    public static final DeferredRegister<Item> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"ftbic");
    public static final List<MaterialItem> MATERIALS = new ArrayList<MaterialItem>();
    public static final Supplier<BlockItem> RUBBER_SHEET = FTBICItems.blockItem("rubber_sheet", FTBICBlocks.RUBBER_SHEET);
    public static final Supplier<BlockItem> REINFORCED_STONE = FTBICItems.blockItem("reinforced_stone", FTBICBlocks.REINFORCED_STONE);
    public static final Supplier<BlockItem> REINFORCED_GLASS = FTBICItems.blockItem("reinforced_glass", FTBICBlocks.REINFORCED_GLASS);
    public static final Supplier<BlockItem> MACHINE_BLOCK = FTBICItems.blockItem("machine_block", FTBICBlocks.MACHINE_BLOCK);
    public static final Supplier<BlockItem> ADVANCED_MACHINE_BLOCK = FTBICItems.blockItem("advanced_machine_block", FTBICBlocks.ADVANCED_MACHINE_BLOCK);
    public static final Supplier<BlockItem> IRON_FURNACE = FTBICItems.blockItem("iron_furnace", FTBICBlocks.IRON_FURNACE);
    public static final Supplier<BlockItem> LV_CABLE = FTBICItems.blockItem("lv_cable", FTBICBlocks.LV_CABLE);
    public static final Supplier<BlockItem> MV_CABLE = FTBICItems.blockItem("mv_cable", FTBICBlocks.MV_CABLE);
    public static final Supplier<BlockItem> HV_CABLE = FTBICItems.blockItem("hv_cable", FTBICBlocks.HV_CABLE);
    public static final Supplier<BlockItem> EV_CABLE = FTBICItems.blockItem("ev_cable", FTBICBlocks.EV_CABLE);
    public static final Supplier<BlockItem> IV_CABLE = FTBICItems.blockItem("iv_cable", FTBICBlocks.IV_CABLE);
    public static final Supplier<BlockItem> BURNT_CABLE = FTBICItems.blockItem("burnt_cable", FTBICBlocks.BURNT_CABLE);
    public static final Supplier<BlockItem> LANDMARK = FTBICItems.blockItem("landmark", FTBICBlocks.LANDMARK);
    public static final Supplier<BlockItem> EXFLUID = FTBICItems.blockItem("exfluid", FTBICBlocks.EXFLUID);
    public static final Supplier<BlockItem> NUCLEAR_REACTOR_CHAMBER = FTBICItems.blockItem("nuclear_reactor_chamber", FTBICBlocks.NUCLEAR_REACTOR_CHAMBER);
    public static final Supplier<BlockItem> NUKE = FTBICItems.blockItem("nuke", FTBICBlocks.NUKE);
    public static final Supplier<BlockItem> ACTIVE_NUKE = FTBICItems.blockItem("active_nuke", FTBICBlocks.ACTIVE_NUKE);
    public static final MaterialItem INDUSTRIAL_GRADE_METAL = FTBICItems.material("industrial_grade_metal");
    public static final MaterialItem RUBBER = FTBICItems.material("rubber");
    public static final MaterialItem SILICON = FTBICItems.material("silicon");
    public static final MaterialItem FUSE = FTBICItems.material("fuse");
    public static final MaterialItem COPPER_COIL = FTBICItems.material("copper_coil");
    public static final MaterialItem MIXED_METAL_BLEND = FTBICItems.material("mixed_metal_blend");
    public static final MaterialItem ADVANCED_ALLOY = FTBICItems.material("advanced_alloy");
    public static final MaterialItem IRIDIUM_ALLOY = FTBICItems.material("iridium_alloy");
    public static final MaterialItem COAL_BALL = FTBICItems.material("coal_ball");
    public static final MaterialItem COMPRESSED_COAL_BALL = FTBICItems.material("compressed_coal_ball");
    public static final MaterialItem GRAPHENE = FTBICItems.material("graphene");
    public static final MaterialItem CARBON_FIBERS = FTBICItems.material("carbon_fibers");
    public static final MaterialItem CARBON_FIBER_MESH = FTBICItems.material("carbon_fiber_mesh");
    public static final MaterialItem CARBON_PLATE = FTBICItems.material("carbon_plate");
    public static final MaterialItem SCRAP = FTBICItems.material("scrap");
    public static final MaterialItem SCRAP_BOX = FTBICItems.material("scrap_box");
    public static final MaterialItem ELECTRONIC_CIRCUIT = FTBICItems.material("electronic_circuit");
    public static final MaterialItem ADVANCED_CIRCUIT = FTBICItems.material("advanced_circuit");
    public static final MaterialItem IRIDIUM_CIRCUIT = FTBICItems.material("iridium_circuit");
    public static final MaterialItem EMPTY_CAN = FTBICItems.material("empty_can");
    public static final MaterialItem ANTIMATTER = FTBICItems.material("antimatter");
    public static final MaterialItem ANTIMATTER_CRYSTAL = FTBICItems.material("antimatter_crystal");
    public static final MaterialItem ENERGY_CRYSTAL = FTBICItems.material("energy_crystal");
    public static final MaterialItem DENSE_COPPER_PLATE = FTBICItems.material("dense_copper_plate");
    public static final Supplier<Item> SINGLE_USE_BATTERY = REGISTRY.register("single_use_battery", () -> new BatteryItem(BatteryType.SINGLE_USE, EnergyTier.LV, (Double)FTBICConfig.ENERGY.SINGLE_USE_BATTERY_CAPACITY.get()));
    public static final Supplier<Item> LV_BATTERY = REGISTRY.register("lv_battery", () -> new BatteryItem(BatteryType.RECHARGEABLE, EnergyTier.LV, (Double)FTBICConfig.ENERGY.LV_BATTERY_CAPACITY.get()));
    public static final Supplier<Item> MV_BATTERY = REGISTRY.register("mv_battery", () -> new BatteryItem(BatteryType.RECHARGEABLE, EnergyTier.MV, (Double)FTBICConfig.ENERGY.MV_BATTERY_CAPACITY.get()));
    public static final Supplier<Item> HV_BATTERY = REGISTRY.register("hv_battery", () -> new BatteryItem(BatteryType.RECHARGEABLE, EnergyTier.HV, (Double)FTBICConfig.ENERGY.HV_BATTERY_CAPACITY.get()));
    public static final Supplier<Item> EV_BATTERY = REGISTRY.register("ev_battery", () -> new BatteryItem(BatteryType.RECHARGEABLE, EnergyTier.EV, (Double)FTBICConfig.ENERGY.EV_BATTERY_CAPACITY.get()));
    public static final Supplier<Item> CREATIVE_BATTERY = REGISTRY.register("creative_battery", () -> new BatteryItem(BatteryType.CREATIVE, EnergyTier.IV, 2.147483647E9));
    public static final Supplier<Item> FLUID_CELL = REGISTRY.register("fluid_cell", FluidCellItem::new);
    public static final Supplier<Item> SMALL_COOLANT_CELL = REGISTRY.register("small_coolant_cell", () -> new CoolantItem(10000));
    public static final Supplier<Item> MEDIUM_COOLANT_CELL = REGISTRY.register("medium_coolant_cell", () -> new CoolantItem(30000));
    public static final Supplier<Item> LARGE_COOLANT_CELL = REGISTRY.register("large_coolant_cell", () -> new CoolantItem(60000));
    public static final Supplier<Item> URANIUM_FUEL_ROD = REGISTRY.register("uranium_fuel_rod", () -> new FuelRodItem(20000, 1, 5.0, 2.0));
    public static final Supplier<Item> DUAL_URANIUM_FUEL_ROD = REGISTRY.register("dual_uranium_fuel_rod", () -> new FuelRodItem(20000, 2, 10.0, 4.0));
    public static final Supplier<Item> QUAD_URANIUM_FUEL_ROD = REGISTRY.register("quad_uranium_fuel_rod", () -> new FuelRodItem(20000, 4, 20.0, 8.0));
    public static final Supplier<Item> HEAT_VENT = REGISTRY.register("heat_vent", () -> new HeatVentItem(1000, 6, 0, 0));
    public static final Supplier<Item> ADVANCED_HEAT_VENT = REGISTRY.register("advanced_heat_vent", () -> new HeatVentItem(1000, 12, 0, 0));
    public static final Supplier<Item> REACTOR_HEAT_VENT = REGISTRY.register("reactor_heat_vent", () -> new HeatVentItem(1000, 5, 5, 0));
    public static final Supplier<Item> COMPONENT_HEAT_VENT = REGISTRY.register("component_heat_vent", () -> new HeatVentItem(0, 0, 0, 4));
    public static final Supplier<Item> OVERCLOCKED_HEAT_VENT = REGISTRY.register("overclocked_heat_vent", () -> new HeatVentItem(1000, 20, 36, 0));
    public static final Supplier<Item> HEAT_EXCHANGER = REGISTRY.register("heat_exchanger", () -> new HeatExchangerItem(2500, 12, 4));
    public static final Supplier<Item> ADVANCED_HEAT_EXCHANGER = REGISTRY.register("advanced_heat_exchanger", () -> new HeatExchangerItem(10000, 24, 8));
    public static final Supplier<Item> REACTOR_HEAT_EXCHANGER = REGISTRY.register("reactor_heat_exchanger", () -> new HeatExchangerItem(5000, 0, 72));
    public static final Supplier<Item> COMPONENT_HEAT_EXCHANGER = REGISTRY.register("component_heat_exchanger", () -> new HeatExchangerItem(5000, 36, 0));
    public static final Supplier<Item> REACTOR_PLATING = REGISTRY.register("reactor_plating", () -> new ReactorPlatingItem(1000, 0.95));
    public static final Supplier<Item> CONTAINMENT_REACTOR_PLATING = REGISTRY.register("containment_reactor_plating", () -> new ReactorPlatingItem(500, 0.9));
    public static final Supplier<Item> HEAT_CAPACITY_REACTOR_PLATING = REGISTRY.register("heat_capacity_reactor_plating", () -> new ReactorPlatingItem(1700, 0.99));
    public static final Supplier<Item> NEUTRON_REFLECTOR = REGISTRY.register("neutron_reflector", () -> new NeutronReflectorItem(30000));
    public static final Supplier<Item> THICK_NEUTRON_REFLECTOR = REGISTRY.register("thick_neutron_reflector", () -> new NeutronReflectorItem(120000));
    public static final Supplier<Item> IRIDIUM_NEUTRON_REFLECTOR = REGISTRY.register("iridium_neutron_reflector", () -> new NeutronReflectorItem(0));
    public static final Supplier<Item> CANNED_FOOD = REGISTRY.register("canned_food", CannedFoodItem::new);
    public static final Supplier<Item> PROTEIN_BAR = REGISTRY.register("protein_bar", ProteinBarItem::new);
    public static final Supplier<Item> DARK_SPRAY_PAINT_CAN = REGISTRY.register("dark_spray_paint_can", () -> new SprayPaintCanItem(true));
    public static final Supplier<Item> LIGHT_SPRAY_PAINT_CAN = REGISTRY.register("light_spray_paint_can", () -> new SprayPaintCanItem(false));
    public static final Supplier<Item> OVERCLOCKER_UPGRADE = REGISTRY.register("overclocker_upgrade", () -> new UpgradeItem(16));
    public static final Supplier<Item> ENERGY_STORAGE_UPGRADE = REGISTRY.register("energy_storage_upgrade", () -> new UpgradeItem(8));
    public static final Supplier<Item> TRANSFORMER_UPGRADE = REGISTRY.register("transformer_upgrade", () -> new UpgradeItem(4));
    public static final Supplier<Item> EJECTOR_UPGRADE = REGISTRY.register("ejector_upgrade", () -> new UpgradeItem(1));
    public static final Supplier<Item> MECHANICAL_ELYTRA = REGISTRY.register("mechanical_elytra", MechanicalElytraItem::new);
    public static final Supplier<Item> CARBON_HELMET = REGISTRY.register("carbon_helmet", () -> new DummyEnergyArmorItem(EnergyArmorMaterial.CARBON, EquipmentSlot.HEAD));
    public static final Supplier<Item> CARBON_CHESTPLATE = REGISTRY.register("carbon_chestplate", () -> new EnergyArmorItem(EnergyArmorMaterial.CARBON));
    public static final Supplier<Item> CARBON_LEGGINGS = REGISTRY.register("carbon_leggings", () -> new DummyEnergyArmorItem(EnergyArmorMaterial.CARBON, EquipmentSlot.LEGS));
    public static final Supplier<Item> CARBON_BOOTS = REGISTRY.register("carbon_boots", () -> new DummyEnergyArmorItem(EnergyArmorMaterial.CARBON, EquipmentSlot.FEET));
    public static final Supplier<Item> QUANTUM_HELMET = REGISTRY.register("quantum_helmet", () -> new DummyEnergyArmorItem(EnergyArmorMaterial.QUANTUM, EquipmentSlot.HEAD));
    public static final Supplier<Item> QUANTUM_CHESTPLATE = REGISTRY.register("quantum_chestplate", () -> new EnergyArmorItem(EnergyArmorMaterial.QUANTUM));
    public static final Supplier<Item> QUANTUM_LEGGINGS = REGISTRY.register("quantum_leggings", () -> new DummyEnergyArmorItem(EnergyArmorMaterial.QUANTUM, EquipmentSlot.LEGS));
    public static final Supplier<Item> QUANTUM_BOOTS = REGISTRY.register("quantum_boots", () -> new DummyEnergyArmorItem(EnergyArmorMaterial.QUANTUM, EquipmentSlot.FEET));
    public static final Supplier<Item> NUKE_ARROW = REGISTRY.register("nuke_arrow", NukeArrowItem::new);
    public static final Map<ResourceType, Map<ResourceElements, Supplier<Item>>> RESOURCE_TYPE_MAP = ResourceType.VALUES.stream().collect(Collectors.toMap(Function.identity(), e -> {
        List<ResourceElements> elementsForType = ResourceElements.RESOURCES_BY_REQUIREMENT.get(e);
        return elementsForType.stream().collect(Collectors.toMap(Function.identity(), a -> REGISTRY.register(a.getName() + "_" + e.name().toLowerCase(Locale.ENGLISH), () -> e == ResourceType.ORE || e == ResourceType.BLOCK ? new BlockItem((e == ResourceType.BLOCK ? FTBICBlocks.RESOURCE_BLOCKS_OF.get(a) : FTBICBlocks.RESOURCE_ORES.get(a)).get(), new Item.Properties().m_41491_(FTBIC.TAB)) : new ResourceItem((ResourceType)((Object)e)))));
    }));

    public static Supplier<BlockItem> blockItem(String id, Supplier<Block> sup) {
        return REGISTRY.register(id, () -> new BlockItem((Block)sup.get(), new Item.Properties().m_41491_(FTBIC.TAB)));
    }

    public static Supplier<Item> basicItem(String id) {
        return REGISTRY.register(id, () -> new Item(new Item.Properties().m_41491_(FTBIC.TAB)));
    }

    public static MaterialItem material(String id) {
        MaterialItem m = new MaterialItem(id);
        m.item = FTBICItems.basicItem(id);
        MATERIALS.add(m);
        return m;
    }

    public static Optional<Supplier<Item>> getResourceFromType(ResourceElements element, ResourceType type) {
        return RESOURCE_TYPE_MAP.get((Object)type).entrySet().stream().filter(e -> e.getKey() == element).findFirst().map(Map.Entry::getValue);
    }
}

