/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.datagen;

import com.google.gson.JsonObject;
import dev.ftb.mods.ftbic.recipe.FTBICRecipes;
import dev.ftb.mods.ftbic.recipe.MachineRecipe;
import dev.ftb.mods.ftbic.recipe.MachineRecipeSerializer;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import dev.ftb.mods.ftbic.util.IngredientWithCount;
import dev.ftb.mods.ftbic.util.StackWithChance;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class MachineRecipeBuilder {
    private static final ResourceLocation DUMMY_ID = new ResourceLocation("ftbic", "dummy");
    private MachineRecipe recipe;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();

    public static MachineRecipeBuilder machine(Supplier<MachineRecipeSerializer> type) {
        MachineRecipeBuilder builder = new MachineRecipeBuilder();
        builder.recipe = new MachineRecipe(type.get(), DUMMY_ID);
        builder.recipe.realRecipe = true;
        builder.recipe.inputItems = new ArrayList<IngredientWithCount>(1);
        builder.recipe.inputFluids = new ArrayList<FluidStack>(0);
        builder.recipe.outputItems = new ArrayList<StackWithChance>(1);
        builder.recipe.outputFluids = new ArrayList<FluidStack>(0);
        return builder;
    }

    public static MachineRecipeBuilder macerating() {
        return MachineRecipeBuilder.machine(FTBICRecipes.MACERATING);
    }

    public static MachineRecipeBuilder separating() {
        return MachineRecipeBuilder.machine(FTBICRecipes.SEPARATING);
    }

    public static MachineRecipeBuilder compressing() {
        return MachineRecipeBuilder.machine(FTBICRecipes.COMPRESSING);
    }

    public static MachineRecipeBuilder canning() {
        return MachineRecipeBuilder.machine(FTBICRecipes.CANNING);
    }

    public static MachineRecipeBuilder rolling() {
        return MachineRecipeBuilder.machine(FTBICRecipes.ROLLING);
    }

    public static MachineRecipeBuilder extruding() {
        return MachineRecipeBuilder.machine(FTBICRecipes.EXTRUDING);
    }

    public MachineRecipeBuilder unlockedBy(String string, CriterionTriggerInstance arg) {
        this.advancement.m_138386_(string, arg);
        return this;
    }

    public MachineRecipeBuilder inputItem(Ingredient in, int count) {
        this.recipe.inputItems.add(new IngredientWithCount(in, count));
        return this;
    }

    public MachineRecipeBuilder inputItem(Ingredient in) {
        return this.inputItem(in, 1);
    }

    public MachineRecipeBuilder io(Ingredient in, ItemStack out) {
        return this.io(in, 1, out, 1.0);
    }

    public MachineRecipeBuilder io(Ingredient in, int count, ItemStack out) {
        this.recipe.inputItems.add(new IngredientWithCount(in, count));
        this.recipe.outputItems.add(new StackWithChance(out, 1.0));
        return this;
    }

    public MachineRecipeBuilder io(Ingredient in, int count, ItemStack out, double chance) {
        this.recipe.inputItems.add(new IngredientWithCount(in, count));
        this.recipe.outputItems.add(new StackWithChance(out, chance));
        return this;
    }

    public MachineRecipeBuilder inputFluid(FluidStack stack) {
        this.recipe.inputFluids.add(stack);
        return this;
    }

    public MachineRecipeBuilder outputItem(ItemStack stack, double chance) {
        this.recipe.outputItems.add(new StackWithChance(stack, chance));
        return this;
    }

    public MachineRecipeBuilder outputItem(ItemStack stack) {
        return this.outputItem(stack, 1.0);
    }

    public MachineRecipeBuilder outputFluid(FluidStack stack) {
        this.recipe.outputFluids.add(stack);
        return this;
    }

    public MachineRecipeBuilder processingTime(double t) {
        this.recipe.processingTime = t;
        return this;
    }

    public MachineRecipeBuilder hideFromJEI() {
        this.recipe.hideFromJEI = true;
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        ItemStack result = this.recipe.m_8043_();
        if (result.m_41619_()) {
            consumer.accept(new Result(this, id, new ResourceLocation(id.m_135827_(), "recipes/ftbic_machine/" + id.m_135815_())));
        } else {
            consumer.accept(new Result(this, id, new ResourceLocation(id.m_135827_(), "recipes/" + result.m_41720_().m_41471_().m_40783_() + "/" + id.m_135815_())));
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final MachineRecipeBuilder builder;
        private final ResourceLocation id;
        private final ResourceLocation advancementId;

        private Result(MachineRecipeBuilder b, ResourceLocation i, ResourceLocation a) {
            this.builder = b;
            this.id = i;
            this.advancementId = a;
        }

        public void m_7917_(JsonObject json) {
            FTBICUtils.listToJson(this.builder.recipe.inputItems, json, "inputItems", IngredientWithCount::toJson);
            FTBICUtils.listToJson(this.builder.recipe.inputFluids, json, "inputFluids", FTBICUtils::fluidToJson);
            FTBICUtils.listToJson(this.builder.recipe.outputItems, json, "outputItems", StackWithChance::toJson);
            FTBICUtils.listToJson(this.builder.recipe.outputFluids, json, "outputFluids", FTBICUtils::fluidToJson);
            if (this.builder.recipe.processingTime != 1.0) {
                json.addProperty("processingTime", (Number)this.builder.recipe.processingTime);
            }
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.builder.recipe.serializer;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.builder.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

