/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.block.entity.machine;

import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.block.ElectricBlockInstance;
import dev.ftb.mods.ftbic.block.entity.ElectricBlockEntity;
import dev.ftb.mods.ftbic.block.entity.machine.BatteryInventory;
import dev.ftb.mods.ftbic.block.entity.machine.UpgradeInventory;
import dev.ftb.mods.ftbic.item.FTBICItems;
import dev.ftb.mods.ftbic.util.EnergyItemHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BasicMachineBlockEntity
extends ElectricBlockEntity {
    public final UpgradeInventory upgradeInventory;
    public final BatteryInventory batteryInventory;
    public double energyUse;
    public double progressSpeed;

    public BasicMachineBlockEntity(ElectricBlockInstance type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.upgradeInventory = new UpgradeInventory(this, 4, (Integer)FTBICConfig.MACHINES.UPGRADE_LIMIT_PER_SLOT.get());
        this.batteryInventory = new BatteryInventory(this, false);
    }

    @Override
    public void writeData(CompoundTag tag) {
        super.writeData(tag);
        tag.m_128365_("Upgrades", (Tag)this.upgradeInventory.serializeNBT().m_128437_("Items", 10));
        if (!this.batteryInventory.getStackInSlot(0).m_41619_()) {
            tag.m_128365_("Battery", (Tag)this.batteryInventory.getStackInSlot(0).serializeNBT());
        }
    }

    @Override
    public void readData(CompoundTag tag) {
        super.readData(tag);
        CompoundTag tag1 = new CompoundTag();
        tag1.m_128365_("Items", (Tag)tag.m_128437_("Upgrades", 10));
        this.upgradeInventory.deserializeNBT(tag1);
        if (tag.m_128441_("Battery")) {
            this.batteryInventory.loadItem(ItemStack.m_41712_((CompoundTag)tag.m_128469_("Battery")));
        } else {
            this.batteryInventory.loadItem(ItemStack.f_41583_);
        }
    }

    @Override
    public void tick() {
        double transfer;
        EnergyItemHandler item;
        double e;
        Item item2;
        ItemStack battery;
        if (!this.isBurnt() && !this.f_58857_.m_5776_() && this.energy < this.energyCapacity && !(battery = this.batteryInventory.getStackInSlot(0)).m_41619_() && (item2 = battery.m_41720_()) instanceof EnergyItemHandler && (e = item.extractEnergy(battery, Math.min(this.energyCapacity - this.energy, transfer = (item = (EnergyItemHandler)item2).isCreativeEnergyItem() ? Double.POSITIVE_INFINITY : this.maxInputEnergy * (Double)FTBICConfig.MACHINES.ITEM_TRANSFER_EFFICIENCY.get()), false)) > 0.0) {
            this.energy += e;
            if (battery.m_41619_()) {
                this.batteryInventory.setStackInSlot(0, ItemStack.f_41583_);
            }
            this.m_6596_();
        }
        this.handleProcessing();
        this.handleChanges();
    }

    @Override
    public double getTotalPossibleEnergyCapacity() {
        return super.getTotalPossibleEnergyCapacity() + (double)(this.upgradeInventory.getSlots() * Math.min((Integer)FTBICConfig.MACHINES.UPGRADE_LIMIT_PER_SLOT.get(), FTBICItems.ENERGY_STORAGE_UPGRADE.get().m_41459_())) * (Double)FTBICConfig.MACHINES.STORAGE_UPGRADE.get();
    }

    public void handleProcessing() {
    }

    @Override
    public void onBroken(Level level, BlockPos pos) {
        super.onBroken(level, pos);
        for (int i = 0; i < this.upgradeInventory.getSlots(); ++i) {
            Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)this.upgradeInventory.getStackInSlot(i));
        }
        Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)this.batteryInventory.getStackInSlot(0));
    }

    @Override
    public void initProperties() {
        super.initProperties();
        this.energyUse = this.electricBlockInstance.energyUsage;
        this.progressSpeed = 1.0;
        this.autoEject = false;
    }

    @Override
    public void upgradesChanged() {
        super.upgradesChanged();
        int overclockers = this.upgradeInventory.countUpgrades(FTBICItems.OVERCLOCKER_UPGRADE.get());
        for (int i = 0; i < overclockers; ++i) {
            this.energyUse *= ((Double)FTBICConfig.MACHINES.OVERCLOCKER_ENERGY_USE.get()).doubleValue();
            this.progressSpeed *= ((Double)FTBICConfig.MACHINES.OVERCLOCKER_SPEED.get()).doubleValue();
        }
        int transformers = this.upgradeInventory.countUpgrades(FTBICItems.TRANSFORMER_UPGRADE.get());
        while (transformers > 0) {
            --transformers;
            this.maxInputEnergy *= 4.0;
        }
        if (this.maxInputEnergy > (Double)FTBICConfig.ENERGY.IV_TRANSFER_RATE.get()) {
            this.maxInputEnergy = (Double)FTBICConfig.ENERGY.IV_TRANSFER_RATE.get();
        }
        this.energyCapacity += (double)this.upgradeInventory.countUpgrades(FTBICItems.ENERGY_STORAGE_UPGRADE.get()) * (Double)FTBICConfig.MACHINES.STORAGE_UPGRADE.get();
        if (this.energy > this.energyCapacity) {
            this.energy = this.energyCapacity;
        }
        this.autoEject = this.upgradeInventory.countUpgrades(FTBICItems.EJECTOR_UPGRADE.get()) > 0;
    }
}

