/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.block;

import dev.ftb.mods.ftbic.block.BurntCableBlock;
import dev.ftb.mods.ftbic.block.CableBlock;
import dev.ftb.mods.ftbic.block.ExFluidBlock;
import dev.ftb.mods.ftbic.block.IronFurnaceBlock;
import dev.ftb.mods.ftbic.block.LandmarkBlock;
import dev.ftb.mods.ftbic.block.NuclearReactorChamberBlock;
import dev.ftb.mods.ftbic.block.NukeBlock;
import dev.ftb.mods.ftbic.block.ResourceBlock;
import dev.ftb.mods.ftbic.block.RubberSheetBlock;
import dev.ftb.mods.ftbic.util.EnergyTier;
import dev.ftb.mods.ftbic.world.ResourceElements;
import dev.ftb.mods.ftbic.world.ResourceType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public interface FTBICBlocks {
    public static final DeferredRegister<Block> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"ftbic");
    public static final Supplier<Block> RUBBER_SHEET = REGISTRY.register("rubber_sheet", RubberSheetBlock::new);
    public static final Supplier<Block> REINFORCED_STONE = REGISTRY.register("reinforced_stone", () -> new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60913_(10.0f, 1.0E10f).m_60999_()));
    public static final Supplier<Block> REINFORCED_GLASS = REGISTRY.register("reinforced_glass", () -> new GlassBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56744_).m_60913_(10.0f, 1.0E10f).m_60999_().m_60955_()));
    public static final Supplier<Block> MACHINE_BLOCK = REGISTRY.register("machine_block", () -> new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56743_).m_60913_(5.0f, 6.0f).m_60999_()));
    public static final Supplier<Block> ADVANCED_MACHINE_BLOCK = REGISTRY.register("advanced_machine_block", () -> new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56743_).m_60913_(5.0f, 6.0f).m_60999_()));
    public static final Supplier<Block> IRON_FURNACE = REGISTRY.register("iron_furnace", IronFurnaceBlock::new);
    public static final Supplier<Block> LV_CABLE = REGISTRY.register("lv_cable", () -> new CableBlock(EnergyTier.LV, 5, SoundType.f_56745_));
    public static final Supplier<Block> MV_CABLE = REGISTRY.register("mv_cable", () -> new CableBlock(EnergyTier.MV, 4, SoundType.f_56745_));
    public static final Supplier<Block> HV_CABLE = REGISTRY.register("hv_cable", () -> new CableBlock(EnergyTier.HV, 6, SoundType.f_56745_));
    public static final Supplier<Block> EV_CABLE = REGISTRY.register("ev_cable", () -> new CableBlock(EnergyTier.EV, 4, SoundType.f_56745_));
    public static final Supplier<Block> IV_CABLE = REGISTRY.register("iv_cable", () -> new CableBlock(EnergyTier.IV, 6, SoundType.f_56744_));
    public static final Supplier<Block> BURNT_CABLE = REGISTRY.register("burnt_cable", BurntCableBlock::new);
    public static final Supplier<Block> LANDMARK = REGISTRY.register("landmark", LandmarkBlock::new);
    public static final Supplier<Block> EXFLUID = REGISTRY.register("exfluid", ExFluidBlock::new);
    public static final Supplier<Block> NUCLEAR_REACTOR_CHAMBER = REGISTRY.register("nuclear_reactor_chamber", NuclearReactorChamberBlock::new);
    public static final Supplier<Block> NUKE = REGISTRY.register("nuke", NukeBlock::new);
    public static final Supplier<Block> ACTIVE_NUKE = REGISTRY.register("active_nuke", () -> new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76273_).m_60918_(SoundType.f_56740_).m_60913_(-1.0f, 1.0E10f).m_60993_()));
    public static final List<Supplier<Block>> CABLES = Arrays.asList(LV_CABLE, MV_CABLE, HV_CABLE, EV_CABLE, IV_CABLE, BURNT_CABLE);
    public static final Map<ResourceElements, Supplier<Block>> RESOURCE_ORES = ResourceElements.VALUES.stream().filter(e -> e.requirements().has(ResourceType.ORE)).collect(Collectors.toMap(Function.identity(), e -> REGISTRY.register(e.getName() + "_ore", () -> new ResourceBlock(e.getName().contains("deepslate")))));
    public static final Map<ResourceElements, Supplier<Block>> RESOURCE_BLOCKS_OF = ResourceElements.VALUES.stream().filter(e -> e.requirements().has(ResourceType.BLOCK)).collect(Collectors.toMap(Function.identity(), e -> REGISTRY.register(e.getName() + "_block", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76404_).m_60999_().m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_)))));
}

