/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.block;

import dev.ftb.mods.ftbic.block.ElectricBlock;
import dev.ftb.mods.ftbic.block.FTBICBlocks;
import dev.ftb.mods.ftbic.block.entity.FTBICBlockEntities;
import dev.ftb.mods.ftbic.item.FTBICItems;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;

public class ElectricBlockInstance {
    public static ElectricBlockInstance current;
    public final String id;
    public String name;
    public boolean advanced = false;
    public DirectionProperty facingProperty = BlockStateProperties.f_61374_;
    public boolean noModel = false;
    public boolean canBeActive = true;
    public boolean canBurn = false;
    public final Supplier<Block> block;
    public final Supplier<BlockItem> item;
    public final Supplier<BlockEntityType<?>> blockEntity;
    public double energyCapacity = 0.0;
    public double maxEnergyOutput = 0.0;
    public double energyUsage = 0.0;
    public boolean energyUsageIsPerTick = false;
    public double maxEnergyInput = 0.0;
    public boolean wip = false;
    public int inputItemCount = 0;
    public int outputItemCount = 0;
    public boolean tickClientSide = false;

    public ElectricBlockInstance(String i, BlockEntityType.BlockEntitySupplier<BlockEntity> blockEntitySupplier) {
        this.id = i;
        this.name = Arrays.stream(this.id.split("_")).map(s -> Character.toUpperCase(s.charAt(0)) + s.substring(1)).collect(Collectors.joining(" "));
        this.block = FTBICBlocks.REGISTRY.register(this.id, () -> {
            current = this;
            ElectricBlock b = new ElectricBlock(this);
            current = null;
            return b;
        });
        this.item = FTBICItems.blockItem(this.id, this.block);
        this.blockEntity = FTBICBlockEntities.register(this.id, blockEntitySupplier, this.block);
    }

    public ElectricBlockInstance advanced() {
        this.advanced = true;
        return this;
    }

    public ElectricBlockInstance name(String n) {
        this.name = n;
        return this;
    }

    public ElectricBlockInstance noRotation() {
        this.facingProperty = null;
        return this;
    }

    public ElectricBlockInstance rotate3D() {
        this.facingProperty = BlockStateProperties.f_61372_;
        return this;
    }

    public ElectricBlockInstance noModel() {
        this.noModel = true;
        return this;
    }

    public ElectricBlockInstance cantBeActive() {
        this.canBeActive = false;
        return this;
    }

    public ElectricBlockInstance canBurn() {
        this.canBurn = true;
        return this;
    }

    public ElectricBlockInstance maxEnergyOutput(double d) {
        this.maxEnergyOutput = d;
        return this;
    }

    public ElectricBlockInstance energyCapacity(double d) {
        this.energyCapacity = d;
        return this;
    }

    public ElectricBlockInstance energyUsage(double d) {
        this.energyUsage = d;
        return this;
    }

    public ElectricBlockInstance maxEnergyInput(double d) {
        this.maxEnergyInput = d;
        return this;
    }

    public ElectricBlockInstance wip() {
        this.wip = true;
        return this;
    }

    public ElectricBlockInstance energyUsageIsntPerTick() {
        this.energyUsageIsPerTick = false;
        return this;
    }

    public ElectricBlockInstance io(int inItems, int outItems) {
        this.inputItemCount = inItems;
        this.outputItemCount = outItems;
        return this;
    }

    public ElectricBlockInstance tickClientSide() {
        this.tickClientSide = true;
        return this;
    }
}

