/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.block;

import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.block.ElectricBlockInstance;
import dev.ftb.mods.ftbic.block.SprayPaintable;
import dev.ftb.mods.ftbic.block.entity.ElectricBlockEntity;
import dev.ftb.mods.ftbic.item.FTBICItems;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ElectricBlock
extends Block
implements EntityBlock,
SprayPaintable {
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    public final ElectricBlockInstance electricBlockInstance;

    public ElectricBlock(ElectricBlockInstance m) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(3.5f).m_60918_(SoundType.f_56743_).m_60999_());
        this.electricBlockInstance = m;
        BlockState state = (BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)SprayPaintable.DARK, (Comparable)Boolean.valueOf(false));
        if (m.facingProperty != null) {
            state = (BlockState)state.m_61124_((Property)this.electricBlockInstance.facingProperty, (Comparable)Direction.SOUTH);
        }
        if (this.electricBlockInstance.canBeActive) {
            state = (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
        }
        this.m_49959_(state);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.electricBlockInstance.blockEntity.get().m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return this.electricBlockInstance.tickClientSide || !level.m_5776_() ? ElectricBlockEntity::ticker : null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SprayPaintable.DARK});
        if (ElectricBlockInstance.current.facingProperty != null) {
            builder.m_61104_(new Property[]{ElectricBlockInstance.current.facingProperty});
        }
        if (ElectricBlockInstance.current.canBeActive) {
            builder.m_61104_(new Property[]{ACTIVE});
        }
    }

    @Deprecated
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return this.electricBlockInstance.facingProperty == null ? state : (BlockState)state.m_61124_((Property)this.electricBlockInstance.facingProperty, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)this.electricBlockInstance.facingProperty)));
    }

    @Deprecated
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return this.electricBlockInstance.facingProperty == null ? state : state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)this.electricBlockInstance.facingProperty)));
    }

    public BlockState m_5573_(BlockPlaceContext arg) {
        if (this.electricBlockInstance.facingProperty == null) {
            return this.m_49966_();
        }
        if (this.electricBlockInstance.facingProperty == BlockStateProperties.f_61374_) {
            return (BlockState)this.m_49966_().m_61124_((Property)this.electricBlockInstance.facingProperty, (Comparable)arg.m_8125_().m_122424_());
        }
        return (BlockState)this.m_49966_().m_61124_((Property)this.electricBlockInstance.facingProperty, (Comparable)arg.m_7820_().m_122424_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState state, Level level, BlockPos pos, Random r) {
        BlockEntity entity;
        boolean active;
        boolean bl = active = this.electricBlockInstance.canBeActive && (Boolean)state.m_61143_((Property)ACTIVE) != false;
        if ((active || this.electricBlockInstance.canBurn) && (entity = level.m_7702_(pos)) instanceof ElectricBlockEntity) {
            ElectricBlockEntity electricBlockEntity = (ElectricBlockEntity)entity;
            double x = pos.m_123341_();
            double y = pos.m_123342_();
            double z = pos.m_123343_();
            if (electricBlockEntity.isBurnt()) {
                if (r.nextInt(10) == 0) {
                    level.m_7785_(x + 0.5, y + 0.5, z + 0.5, SoundEvents.f_11936_, SoundSource.BLOCKS, 1.0f + r.nextFloat(), r.nextFloat() * 0.7f + 0.3f, false);
                }
                for (int i = 0; i < 5; ++i) {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + (double)r.nextFloat(), y + 1.0, z + (double)r.nextFloat(), 0.0, 0.0, 0.0);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y + 0.05 + (double)r.nextFloat(), z + (double)r.nextFloat(), 0.0, 0.0, 0.0);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + 1.0, y + 0.05 + (double)r.nextFloat(), z + (double)r.nextFloat(), 0.0, 0.0, 0.0);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + (double)r.nextFloat(), y + 0.05 + (double)r.nextFloat(), z, 0.0, 0.0, 0.0);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + (double)r.nextFloat(), y + 0.05 + (double)r.nextFloat(), z + 1.0, 0.0, 0.0, 0.0);
                    if (r.nextInt(5) == 0) {
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x, y + 0.05 + (double)r.nextFloat(), z + (double)r.nextFloat(), 0.0, 0.0, 0.0);
                    }
                    if (r.nextInt(5) == 0) {
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x + 1.0, y + 0.05 + (double)r.nextFloat(), z + (double)r.nextFloat(), 0.0, 0.0, 0.0);
                    }
                    if (r.nextInt(5) == 0) {
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x + (double)r.nextFloat(), y + 0.05 + (double)r.nextFloat(), z, 0.0, 0.0, 0.0);
                    }
                    if (r.nextInt(5) != 0) continue;
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x + (double)r.nextFloat(), y + 0.05 + (double)r.nextFloat(), z + 1.0, 0.0, 0.0, 0.0);
                }
                level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x + (double)r.nextFloat(), y + 1.1, z + (double)r.nextFloat(), 0.0, 0.0, 0.0);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, x + 0.5, y + 1.0, z + 0.5, 0.0, 0.0, 0.0);
            } else if (active) {
                electricBlockEntity.spawnActiveParticles(level, x, y, z, state, r);
            }
        }
    }

    @Deprecated
    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState state1, boolean b) {
        super.m_6807_(state, level, pos, state1, b);
        if (!level.m_5776_() && !state.m_60713_(state1.m_60734_())) {
            ElectricBlockEntity.electricNetworkUpdated((LevelAccessor)level, pos);
        }
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.m_6402_(level, pos, state, entity, stack);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ElectricBlockEntity) {
            ((ElectricBlockEntity)blockEntity).onPlacedBy(entity, stack);
        }
    }

    @Deprecated
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState state1, boolean b) {
        if (!level.m_5776_() && !state.m_60713_(state1.m_60734_())) {
            ElectricBlockEntity.electricNetworkUpdated((LevelAccessor)level, pos);
            BlockEntity entity = level.m_7702_(pos);
            if (entity instanceof ElectricBlockEntity) {
                ((ElectricBlockEntity)entity).onBroken(level, pos);
            }
            level.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, level, pos, state1, b);
    }

    @Deprecated
    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos pos1, boolean b) {
        BlockEntity entity;
        super.m_6861_(state, level, pos, block, pos1, b);
        if (!level.m_5776_() && (entity = level.m_7702_(pos)) instanceof ElectricBlockEntity) {
            ((ElectricBlockEntity)entity).neighborChanged(pos1, block);
        }
    }

    @Deprecated
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity entity = level.m_7702_(pos);
        if (entity instanceof ElectricBlockEntity) {
            ElectricBlockEntity electricBlockEntity = (ElectricBlockEntity)entity;
            if (electricBlockEntity.isBurnt()) {
                if (player.m_21120_(hand).m_41720_() == FTBICItems.FUSE.item.get()) {
                    electricBlockEntity.setBurnt(false);
                    level.m_5594_(player, pos, SoundEvents.f_12444_, SoundSource.BLOCKS, 0.3f, 0.6f);
                    if (!level.m_5776_() && !player.m_7500_()) {
                        player.m_21120_(hand).m_41774_(1);
                    }
                    return InteractionResult.m_19078_((boolean)level.m_5776_());
                }
                if (!level.m_5776_()) {
                    player.m_5661_((Component)new TranslatableComponent("ftbic.fuse_info"), true);
                }
                return InteractionResult.SUCCESS;
            }
            return electricBlockEntity.rightClick(player, hand, hit);
        }
        return InteractionResult.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> list, TooltipFlag flag) {
        if (this.electricBlockInstance.wip) {
            list.add((Component)new TextComponent("WIP!").m_130940_(ChatFormatting.RED));
        }
        if (this.electricBlockInstance.maxEnergyOutput > 0.0) {
            list.add((Component)new TranslatableComponent("ftbic.energy_output", new Object[]{FTBICUtils.formatEnergy(this.electricBlockInstance.maxEnergyOutput).m_130946_("/t").m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_GRAY));
            Double feRatio = (Double)FTBICConfig.ENERGY.ZAP_TO_FE_CONVERSION_RATE.get();
            if (feRatio > 0.0) {
                list.add((Component)new TranslatableComponent("ftbic.zap_to_fe_conversion", new Object[]{FTBICConfig.ENERGY_FORMAT, feRatio}).m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
        if (this.electricBlockInstance.energyUsage > 0.0) {
            if (this.electricBlockInstance.energyUsageIsPerTick) {
                list.add((Component)new TranslatableComponent("ftbic.energy_usage", new Object[]{FTBICUtils.formatEnergy(this.electricBlockInstance.energyUsage).m_130946_("/t").m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_GRAY));
            } else {
                list.add((Component)new TranslatableComponent("ftbic.energy_usage", new Object[]{FTBICUtils.formatEnergy(this.electricBlockInstance.energyUsage).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
        if (this.electricBlockInstance.maxEnergyInput > 0.0) {
            list.add((Component)new TranslatableComponent("ftbic.max_input", new Object[]{FTBICUtils.formatEnergy(this.electricBlockInstance.maxEnergyInput).m_130946_("/t").m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_GRAY));
        }
        if (this.electricBlockInstance.energyCapacity > 0.0 && Screen.m_96638_()) {
            list.add((Component)new TranslatableComponent("ftbic.energy_capacity", new Object[]{FTBICUtils.formatEnergy(this.electricBlockInstance.energyCapacity).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_GRAY));
        }
        if (stack.m_41782_() && stack.m_41783_().m_128425_("BlockEntityTag", 10)) {
            CompoundTag tag = stack.m_41783_().m_128469_("BlockEntityTag").m_6426_();
            tag.m_128473_("x");
            tag.m_128473_("y");
            tag.m_128473_("z");
            tag.m_128473_("id");
            tag.m_128473_("Inventory");
            tag.m_128473_("Upgrades");
            tag.m_128473_("Battery");
            tag.m_128473_("ChargeBattery");
            tag.m_128473_("PlacerId");
            tag.m_128473_("PlacerName");
            for (String key : tag.m_128431_()) {
                list.add((Component)new TextComponent("- " + key + ": " + tag.m_128423_(key)).m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        BlockEntity blockEntity;
        if (entity instanceof ServerPlayer && (blockEntity = level.m_7702_(pos)) instanceof ElectricBlockEntity) {
            ((ElectricBlockEntity)blockEntity).stepOn((ServerPlayer)entity);
        }
    }

    @Deprecated
    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        BlockEntity entity;
        if (!level.m_5776_() && (entity = level.m_7702_(pos)) instanceof ElectricBlockEntity) {
            return ((ElectricBlockEntity)entity).getRedstoneOutputSignalEnergyStorage();
        }
        return 0;
    }

    @Deprecated
    public boolean m_7278_(BlockState state) {
        return true;
    }
}

