/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic;

import dev.architectury.platform.Platform;
import dev.ftb.mods.ftbic.FTBICCommon;
import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.block.FTBICBlocks;
import dev.ftb.mods.ftbic.block.FTBICElectricBlocks;
import dev.ftb.mods.ftbic.block.entity.FTBICBlockEntities;
import dev.ftb.mods.ftbic.client.FTBICClient;
import dev.ftb.mods.ftbic.entity.FTBICEntities;
import dev.ftb.mods.ftbic.item.DummyEnergyArmorItem;
import dev.ftb.mods.ftbic.item.EnergyArmorItem;
import dev.ftb.mods.ftbic.item.FTBICItems;
import dev.ftb.mods.ftbic.net.FTBICNet;
import dev.ftb.mods.ftbic.recipe.FTBICRecipes;
import dev.ftb.mods.ftbic.screen.FTBICMenus;
import dev.ftb.mods.ftbic.sound.FTBICSounds;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import dev.ftb.mods.ftbic.world.OreGeneration;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@Mod(value="ftbic")
@Mod.EventBusSubscriber(modid="ftbic")
public class FTBIC {
    public static final String MOD_ID = "ftbic";
    public static final String MOD_NAME = "FTB Industrial Contraptions";
    public static final Logger LOGGER = LogManager.getLogger((String)"FTB Industrial Contraptions");
    public static FTBICCommon PROXY;
    public static final List<DeferredRegister<?>> REGISTERS;
    public static final CreativeModeTab TAB;

    public FTBIC() {
        PROXY = (FTBICCommon)DistExecutor.safeRunForDist(() -> FTBICClient::new, () -> FTBICCommon::new);
        Path configPath = Platform.getConfigFolder().resolve("ftbic-common.snbt");
        FTBICConfig.CONFIG.load(configPath);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        REGISTERS.forEach(e -> e.register(modEventBus));
        FTBICElectricBlocks.init();
        FTBICUtils.init();
        FTBICNet.init();
        FTBICConfig.init();
        PROXY.init();
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(OreGeneration::init);
    }

    @SubscribeEvent
    public static void biomeLoadEvent(BiomeLoadingEvent event) {
        Biome.BiomeCategory biome = event.getCategory();
        if (biome == Biome.BiomeCategory.THEEND || biome == Biome.BiomeCategory.NONE || biome == Biome.BiomeCategory.NETHER) {
            return;
        }
        OreGeneration.PLACEMENTS.forEach(e -> event.getGeneration().m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, e));
    }

    private static boolean isDummyArmor(LivingDamageEvent event, EquipmentSlot slot, ArmorMaterial material) {
        Item item = event.getEntityLiving().m_6844_(slot).m_41720_();
        return item instanceof DummyEnergyArmorItem && ((DummyEnergyArmorItem)item).m_40401_() == material;
    }

    @SubscribeEvent
    public static void playerDamage(LivingDamageEvent event) {
        EnergyArmorItem armorItem;
        ItemStack stack;
        Item item;
        if (!event.getSource().m_19378_() && event.getEntityLiving() instanceof Player && (item = (stack = event.getEntityLiving().m_6844_(EquipmentSlot.CHEST)).m_41720_()) instanceof EnergyArmorItem && (armorItem = (EnergyArmorItem)item).getEnergy(stack) > 0.0) {
            float protection = 0.35f;
            if (FTBIC.isDummyArmor(event, EquipmentSlot.HEAD, armorItem.m_40401_())) {
                protection += 0.25f;
            }
            if (FTBIC.isDummyArmor(event, EquipmentSlot.LEGS, armorItem.m_40401_())) {
                protection += 0.35f;
            }
            if (FTBIC.isDummyArmor(event, EquipmentSlot.FEET, armorItem.m_40401_())) {
                protection += 0.15f;
            }
            float amountReduced = event.getAmount() * Math.min(protection, 1.0f);
            double energy = (Double)FTBICConfig.EQUIPMENT.ARMOR_DAMAGE_ENERGY.get() * (double)amountReduced;
            armorItem.damageEnergyItem(stack, energy);
            event.setAmount(event.getAmount() - amountReduced);
        }
    }

    @Nullable
    private static Item missingItem(String name) {
        return switch (name) {
            case "battery" -> FTBICItems.LV_BATTERY.get();
            case "crystal_battery" -> FTBICItems.MV_BATTERY.get();
            case "graphene_battery" -> FTBICItems.HV_BATTERY.get();
            case "iridium_battery" -> FTBICItems.EV_BATTERY.get();
            case "coolant_10k" -> FTBICItems.SMALL_COOLANT_CELL.get();
            case "coolant_30k" -> FTBICItems.MEDIUM_COOLANT_CELL.get();
            case "coolant_60k" -> FTBICItems.LARGE_COOLANT_CELL.get();
            default -> null;
        };
    }

    @Nullable
    private static Block missingBlock(String name) {
        return switch (name) {
            case "copper_cable" -> FTBICBlocks.LV_CABLE.get();
            case "gold_cable" -> FTBICBlocks.MV_CABLE.get();
            case "aluminum_cable" -> FTBICBlocks.HV_CABLE.get();
            case "enderium_cable" -> FTBICBlocks.EV_CABLE.get();
            case "glass_cable" -> FTBICBlocks.IV_CABLE.get();
            default -> null;
        };
    }

    @SubscribeEvent
    public static void missingItems(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            if (!mapping.key.m_135827_().equals(MOD_ID)) continue;
            Block block = FTBIC.missingBlock(mapping.key.m_135815_());
            if (block != null) {
                mapping.remap((IForgeRegistryEntry)block.m_5456_());
                continue;
            }
            Item item = FTBIC.missingItem(mapping.key.m_135815_());
            if (item == null) continue;
            mapping.remap((IForgeRegistryEntry)item);
        }
    }

    @SubscribeEvent
    public static void missingBlocks(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            Block block;
            if (!mapping.key.m_135827_().equals(MOD_ID) || (block = FTBIC.missingBlock(mapping.key.m_135815_())) == null) continue;
            mapping.remap((IForgeRegistryEntry)block);
        }
    }

    static {
        REGISTERS = List.of(FTBICBlocks.REGISTRY, FTBICItems.REGISTRY, FTBICBlockEntities.REGISTRY, FTBICRecipes.REGISTRY, FTBICRecipes.REGISTRY_TYPE, FTBICMenus.REGISTRY, FTBICEntities.REGISTRY, FTBICSounds.REGISTRY, FTBICUtils.LOOT_REGISTRY);
        TAB = new CreativeModeTab(MOD_ID){

            @OnlyIn(value=Dist.CLIENT)
            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)FTBICElectricBlocks.POWERED_FURNACE.item.get());
            }
        };
    }
}

