/*
 * Decompiled with CFR 0.152.
 */
package mcjty.restrictions.blocks;

import java.util.List;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.restrictions.items.GlassBoots;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class BaseTileEntity
extends TickingTileEntity {
    private AABB aabb = null;
    private final double speed;

    public BaseTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, double speed) {
        super(type, pos, state);
        this.speed = speed;
    }

    public void setPowerInput(int powered) {
        if (this.powerLevel != powered) {
            this.powerLevel = powered;
            this.m_6596_();
            BlockState state = this.f_58857_.m_8055_(this.m_58899_());
            this.f_58857_.m_7260_(this.m_58899_(), state, state, 3);
        }
    }

    protected AABB getBox() {
        if (this.aabb == null) {
            assert (this.f_58857_ != null);
            Direction direction = (Direction)this.f_58857_.m_8055_(this.m_58899_()).m_61143_((Property)BlockStateProperties.f_61372_);
            this.aabb = new AABB(this.m_58899_().m_142300_(direction));
            if (this.powerLevel > 1) {
                this.aabb = this.aabb.m_82367_(new AABB(this.m_58899_().m_5484_(direction, this.powerLevel)));
            }
        }
        return this.aabb;
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound) {
        CompoundTag infoTag;
        if (tagCompound.m_128441_("Info") && (infoTag = tagCompound.m_128469_("Info")).m_128441_("powered")) {
            this.powerLevel = infoTag.m_128445_("powered");
        }
    }

    public void saveClientDataToNBT(CompoundTag tagCompound) {
        CompoundTag infoTag = this.getOrCreateInfo(tagCompound);
        infoTag.m_128344_("powered", (byte)this.powerLevel);
    }

    protected void tickServer() {
        assert (this.f_58857_ != null);
        Direction direction = (Direction)this.f_58857_.m_8055_(this.m_58899_()).m_61143_((Property)BlockStateProperties.f_61372_);
        if (this.powerLevel > 0) {
            List entities = this.f_58857_.m_45976_(Entity.class, this.getBox());
            for (Entity entity : entities) {
                entity.m_5997_((double)direction.m_122429_() * this.speed, (double)direction.m_122430_() * this.speed, (double)direction.m_122431_() * this.speed);
                if (direction != Direction.UP || !(entity.m_20184_().f_82480_ > -0.5)) continue;
                entity.f_19789_ = 1.0f;
            }
        }
    }

    protected void tickClient() {
        if (this.powerLevel > 0) {
            Direction direction = (Direction)this.f_58857_.m_8055_(this.m_58899_()).m_61143_((Property)BlockStateProperties.f_61372_);
            List entities = this.f_58857_.m_45976_(Player.class, this.getBox());
            for (Player entity : entities) {
                ItemStack boots = entity.m_6844_(EquipmentSlot.FEET);
                if (!boots.m_41619_() && boots.m_41720_() instanceof GlassBoots) continue;
                entity.m_5997_((double)direction.m_122429_() * this.speed, (double)direction.m_122430_() * this.speed, (double)direction.m_122431_() * this.speed);
                if (direction != Direction.UP || !(entity.m_20184_().f_82480_ > -0.5)) continue;
                entity.f_19789_ = 1.0f;
            }
        }
    }
}

