/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.server.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.nio.file.Path;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import potionstudios.byg.BYG;
import potionstudios.byg.client.KillClient;
import potionstudios.byg.config.BYGConfigHandler;
import potionstudios.byg.config.ConfigVersionTracker;
import potionstudios.byg.mixin.access.CommandSourceStackAccess;
import potionstudios.byg.util.FileUtils;
import potionstudios.byg.util.ModPlatform;
import potionstudios.byg.util.ServerKillCountDown;

public class UpdateConfigsCommand {
    private static int warnings = 0;
    private static final long COUNTDOWN_LENGTH = 1200L;
    public static final String COMMAND_STRING = "update_configs";
    public static final String UPDATE_STRING = "update";
    public static final String DISMISS_STRING = "dismiss";
    public static final String UPDATE_COMMAND = "/byg update_configs update";
    public static final String DISMISS_COMMAND = "/byg update_configs dismiss";
    public static final String BACKUP_PATH = "\".../config/byg/backups\"";
    public static final Component UPDATE_COMPONENT = ComponentUtils.m_130748_((Component)new TranslatableComponent("byg.command.updateconfig.update").m_130940_(ChatFormatting.GREEN).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, UPDATE_COMMAND)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent("byg.command.updateconfig.update.hover", new Object[]{new TextComponent(BACKUP_PATH).m_130940_(ChatFormatting.BLUE)}).m_130940_(ChatFormatting.RED)))));
    public static final Component DISMISS_UPDATE_COMPONENT = ComponentUtils.m_130748_((Component)new TranslatableComponent("byg.command.updateconfig.dismiss").m_130940_(ChatFormatting.YELLOW).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, DISMISS_COMMAND))));
    public static final TranslatableComponent CONTACT_SERVER_OWNER = new TranslatableComponent("byg.command.updateconfig.contactserverowner");
    public static final MutableComponent PLAYER_WARNING = new TranslatableComponent("byg.command.updateconfig.warnplayers");
    public static final MutableComponent SERVER_KILL_PLAYER_NOTIFICATION = new TranslatableComponent("byg.command.updateconfig.notifyplayersservershutdown");
    public static final MutableComponent GAME_CLOSE_WARNING = new TranslatableComponent("byg.command.updateconfig.warngameclose");

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        String argName = "action";
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)COMMAND_STRING).requires(UpdateConfigsCommand::lambda$register$2)).then(Commands.m_82129_((String)argName, (ArgumentType)StringArgumentType.string()).suggests((ctx, sb) -> SharedSuggestionProvider.m_82967_((String[])new String[]{UPDATE_STRING, DISMISS_STRING}, (SuggestionsBuilder)sb)).executes(cs -> {
            Player player;
            CommandSourceStack stack = (CommandSourceStack)cs.getSource();
            MinecraftServer server = stack.m_81377_();
            CommandSource commandSource = ((CommandSourceStackAccess)cs.getSource()).byg_getSource();
            ConfigVersionTracker configVersionTracker = new ConfigVersionTracker(4);
            if (ConfigVersionTracker.getConfig().configVersion() == 4) {
                stack.m_81354_((Component)new TranslatableComponent("byg.command.updateconfig.configsuptodate"), true);
                return 1;
            }
            boolean isSinglePlayerOwner = commandSource instanceof Player && server.m_7779_((player = (Player)commandSource).m_36316_());
            boolean isServerConsole = commandSource instanceof MinecraftServer;
            if (!isSinglePlayerOwner && !isServerConsole) {
                stack.m_81352_((Component)CONTACT_SERVER_OWNER);
                BYG.LOGGER.warn("BYG's configs are outdated, run \"/byg update_configs update\" to dismiss this warning");
                return 0;
            }
            String argument = (String)cs.getArgument(argName, String.class);
            if (argument.equalsIgnoreCase(UPDATE_STRING)) {
                switch (warnings) {
                    case 0: {
                        stack.m_81352_((Component)GAME_CLOSE_WARNING.m_130940_(ChatFormatting.BOLD));
                        ++warnings;
                        break;
                    }
                    case 1: {
                        for (ServerPlayer serverPlayer : server.m_6846_().m_11314_()) {
                            serverPlayer.m_5661_((Component)PLAYER_WARNING.m_130940_(ChatFormatting.YELLOW), false);
                        }
                        stack.m_81352_((Component)GAME_CLOSE_WARNING.m_130940_(ChatFormatting.BOLD));
                        ++warnings;
                        break;
                    }
                    case 2: {
                        for (ServerPlayer serverPlayer : server.m_6846_().m_11314_()) {
                            serverPlayer.m_5661_((Component)SERVER_KILL_PLAYER_NOTIFICATION.m_130940_(ChatFormatting.RED), false);
                        }
                        ((ServerKillCountDown)server).setKillCountdown(1200L, isSinglePlayerOwner);
                        ++warnings;
                        break;
                    }
                    default: {
                        warnings = 0;
                        break;
                    }
                }
            } else if (argument.equalsIgnoreCase(DISMISS_STRING)) {
                ConfigVersionTracker.getConfig(configVersionTracker, true);
            }
            return 1;
        }));
    }

    public static void backupAndKillGameInstance(MinecraftServer server, ConfigVersionTracker configVersionTracker, boolean isSinglePlayerOwner) {
        UpdateConfigsCommand.backupConfigs(configVersionTracker);
        if (server.m_129792_() && isSinglePlayerOwner) {
            KillClient.kill();
        } else {
            server.m_7570_(false);
        }
    }

    public static void backupConfigs(ConfigVersionTracker configVersionTracker) {
        Path directory = ModPlatform.INSTANCE.configPath();
        ConfigVersionTracker.getConfig(configVersionTracker, true);
        Path backUpPath = FileUtils.backUpDirectory(directory);
        FileUtils.deleteDirectory(directory, path -> !path.equals(backUpPath) && (!path.toFile().isDirectory() || path.toFile().listFiles().length <= 0));
        BYGConfigHandler.loadAllConfigs(true, true);
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ boolean lambda$register$2(CommandSourceStack stack) {
        commandSource = ((CommandSourceStackAccess)stack).byg_getSource();
        if (!(commandSource instanceof Player)) ** GOTO lbl-1000
        player = (Player)commandSource;
        if (stack.m_81377_().m_7779_(player.m_36316_())) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        isSinglePlayerOwner = v0;
        isServerConsole = commandSource instanceof MinecraftServer;
        return isSinglePlayerOwner != false || isServerConsole != false;
    }
}

