/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.data.advancements;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.TickTrigger;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.ItemLike;
import potionstudios.byg.BYG;
import potionstudios.byg.common.item.BYGItems;
import potionstudios.byg.data.advancements.BYGAdvancementConsumer;
import potionstudios.byg.data.advancements.BYGHusbandryAdvancements;

public class BYGAdvancementProvider
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Path outputFolder;
    private static final List<BYGAdvancementConsumer<Advancement>> ADVANCEMENTS = ImmutableList.of((Object)new BYGHusbandryAdvancements());

    public BYGAdvancementProvider(Path outputFolder) {
        this.outputFolder = outputFolder;
    }

    public void m_6865_(HashCache cache) {
        Path path = this.outputFolder;
        HashSet set = Sets.newHashSet();
        Consumer<Advancement> consumer = advancement -> {
            if (!set.add(advancement.m_138327_())) {
                throw new IllegalStateException("Duplicate advancement " + advancement.m_138327_());
            }
            Path path2 = BYGAdvancementProvider.createPath(path, advancement);
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)advancement.m_138313_().m_138400_(), (Path)path2);
            }
            catch (IOException var6) {
                BYG.LOGGER.error("Couldn't save advancement {}", (Object)path2, (Object)var6);
            }
        };
        Advancement root = Advancement.Builder.m_138353_().m_138371_((ItemLike)BYGItems.BYG_LOGO.get(), (Component)new TranslatableComponent("byg.advancements.root.title"), (Component)new TranslatableComponent("byg.advancements.root.description"), BYG.createLocation("textures/block/lush_dirt.png"), FrameType.TASK, false, false, false).m_138386_("tick", (CriterionTriggerInstance)new TickTrigger.TriggerInstance(EntityPredicate.Composite.f_36667_)).m_138389_(consumer, "byg:root");
        Advancement.Builder.m_138353_().m_138398_(root).m_138371_((ItemLike)BYGItems.BIOMEPEDIA.get(), (Component)new TranslatableComponent("byg.advancements.biomepediagift.title"), (Component)new TranslatableComponent("byg.advancements.biomepediagift.description"), null, FrameType.TASK, false, false, true).m_138386_("tick", (CriterionTriggerInstance)new TickTrigger.TriggerInstance(EntityPredicate.Composite.f_36667_)).m_138354_(new AdvancementRewards.Builder().m_144824_(BYG.createLocation("advancement/biomepedia_gift"))).m_138389_(consumer, "byg:biomepedia_gift");
        for (BYGAdvancementConsumer<Advancement> advancement2 : ADVANCEMENTS) {
            advancement2.accept(consumer, root);
        }
    }

    private static Path createPath(Path path, Advancement advancement) {
        String nameSpace = advancement.m_138327_().m_135827_();
        return path.resolve("data/" + nameSpace + "/advancements/" + advancement.m_138327_().m_135815_() + ".json");
    }

    public String m_6055_() {
        return "BYG Advancements";
    }
}

