/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.gen.end.islands;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import potionstudios.byg.common.world.feature.config.FloatingIslandConfig;
import potionstudios.byg.common.world.math.noise.fastnoise.lite.FastNoiseLite;

public class FloatingIslands4
extends Feature<FloatingIslandConfig> {
    FastNoiseLite perlin = null;

    public FloatingIslands4(Codec<FloatingIslandConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<FloatingIslandConfig> featurePlaceContext) {
        return this.place(featurePlaceContext.m_159774_(), featurePlaceContext.m_159775_(), featurePlaceContext.m_159776_(), featurePlaceContext.m_159777_(), (FloatingIslandConfig)featurePlaceContext.m_159778_());
    }

    public boolean place(WorldGenLevel world, ChunkGenerator generator, Random rand, BlockPos pos, FloatingIslandConfig config) {
        double z;
        double y;
        double x;
        this.setSeed(world.m_7328_());
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        double radius = 11.0;
        double size = radius / 3.0;
        double radiusHalved = radius / 2.0;
        for (x = -radius - 5.0; x <= radius + 5.0; x += 1.0) {
            for (y = 1.0; y <= radius + 5.0; y += 1.0) {
                for (z = -radius - 5.0; z <= radius + 5.0; z += 1.0) {
                    mutable.m_122190_((Vec3i)pos).m_122184_((int)x, (int)y, (int)z);
                    double noise = FastNoiseLite.getSpongePerlinValue(this.perlin.GetNoise(mutable.m_123341_(), mutable.m_123342_(), mutable.m_123343_()));
                    double distanceSqt1 = x * x + y * y + z * z + noise * noise;
                    if (!(distanceSqt1 <= radius * radius)) continue;
                    if (y == 1.0) {
                        world.m_7731_((BlockPos)mutable, config.getTopBlockProvider().m_7112_(rand, (BlockPos)mutable), 2);
                        continue;
                    }
                    world.m_7731_((BlockPos)mutable, config.getBlockProvider().m_7112_(rand, (BlockPos)mutable), 2);
                }
            }
        }
        for (x = -radiusHalved; x <= radiusHalved; x += 1.0) {
            for (y = 2.0; y <= size; y += 1.0) {
                for (z = -radiusHalved; z <= radiusHalved; z += 1.0) {
                    mutable.m_122190_((Vec3i)pos).m_122184_((int)x, (int)y, (int)z);
                    double distanceSqt1 = x * x + y * y + z * z;
                    if (!(distanceSqt1 <= radiusHalved * radiusHalved)) continue;
                    world.m_7731_((BlockPos)mutable, Blocks.f_49990_.m_49966_(), 2);
                    world.m_186469_((BlockPos)mutable, (Fluid)Fluids.f_76193_, 0);
                }
            }
        }
        for (Holder feature : config.getPlacedFeatures()) {
            ((PlacedFeature)feature.m_203334_()).m_191782_(world, generator, rand, pos.m_6630_(2));
        }
        return true;
    }

    public void setSeed(long seed) {
        if (this.perlin == null) {
            this.perlin = FastNoiseLite.createSpongePerlin((int)seed);
            this.perlin.SetFrequency(0.2f);
        }
    }
}

