/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.gen.end.islands;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.material.Material;
import potionstudios.byg.common.world.feature.config.FloatingIslandConfig;
import potionstudios.byg.common.world.math.noise.fastnoise.lite.FastNoiseLite;

public class FloatingIslands3
extends Feature<FloatingIslandConfig> {
    FastNoiseLite perlin = null;

    public FloatingIslands3(Codec<FloatingIslandConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<FloatingIslandConfig> featurePlaceContext) {
        return this.place(featurePlaceContext.m_159774_(), featurePlaceContext.m_159775_(), featurePlaceContext.m_159776_(), featurePlaceContext.m_159777_(), (FloatingIslandConfig)featurePlaceContext.m_159778_());
    }

    public boolean place(WorldGenLevel world, ChunkGenerator generator, Random rand, BlockPos pos, FloatingIslandConfig config) {
        double noise;
        double z;
        double y;
        double x;
        this.setSeed(world.m_7328_());
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        double radius = rand.nextInt(Math.max(1, config.getMaxPossibleRadius() - config.getMinRadius())) + config.getMinRadius();
        double thirdRadius = radius / 3.0;
        for (x = -radius - 5.0; x <= radius + 5.0; x += 1.0) {
            for (y = -radius - 5.0; y <= radius + 5.0; y += 1.0) {
                for (z = -radius - 5.0; z <= radius + 5.0; z += 1.0) {
                    noise = FastNoiseLite.getSpongePerlinValue(this.perlin.GetNoise(x, y, z));
                    double distanceSqt1 = x * x + y * y + z * z + noise * noise;
                    if (!(distanceSqt1 <= radius * radius)) continue;
                    mutable.m_122190_((Vec3i)pos).m_122184_((int)x, (int)y, (int)z);
                    if (world.m_8055_((BlockPos)mutable).m_60767_() != Material.f_76296_) continue;
                    if (y <= 1.0) {
                        world.m_7731_((BlockPos)mutable, config.getTopBlockProvider().m_7112_(rand, (BlockPos)mutable), 2);
                    }
                    if (!(y <= 0.0)) continue;
                    world.m_7731_((BlockPos)mutable, config.getBlockProvider().m_7112_(rand, (BlockPos)mutable), 2);
                }
            }
        }
        for (x = -thirdRadius; x <= thirdRadius; x += 1.0) {
            for (y = -thirdRadius; y <= thirdRadius; y += 1.0) {
                for (z = -thirdRadius; z <= thirdRadius; z += 1.0) {
                    noise = FastNoiseLite.getSpongePerlinValue(this.perlin.GetNoise(x, y, z));
                    double distanceSqt2 = x * x + y * y + z * z + noise * noise;
                    if (!(distanceSqt2 <= radius * (thirdRadius + 2.0)) || !(y <= 1.0) || !(y >= -1.0) || !(x <= 1.0) || !(x >= -2.0) || !(z <= 1.0) || !(z >= -2.0)) continue;
                    mutable.m_122190_((Vec3i)pos).m_122184_((int)x + 1, (int)y - 9, (int)z + 1);
                    world.m_7731_((BlockPos)mutable, config.getBlockProvider().m_7112_(rand, (BlockPos)mutable), 2);
                }
            }
        }
        for (Holder feature : config.getPlacedFeatures()) {
            ((PlacedFeature)feature.m_203334_()).m_191782_(world, generator, rand, pos.m_6630_(2));
        }
        return false;
    }

    public void setSeed(long seed) {
        if (this.perlin == null) {
            this.perlin = FastNoiseLite.createSpongePerlin((int)seed);
            this.perlin.SetFrequency(0.2f);
        }
    }
}

