/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import potionstudios.byg.common.block.BYGBlocks;

public class BYGMushroomConfig
implements FeatureConfiguration {
    public static final Codec<BYGMushroomConfig> CODEC = RecordCodecBuilder.create(codecRecorder -> codecRecorder.group((App)BlockStateProvider.f_68747_.fieldOf("stem_provider").forGetter(config -> config.stemProvider), (App)BlockStateProvider.f_68747_.fieldOf("mushroom_provider").forGetter(config -> config.mushroomProvider), (App)BlockStateProvider.f_68747_.fieldOf("mushroom2_provider").forGetter(config -> config.mushroomProvider), (App)BlockStateProvider.f_68747_.fieldOf("mushroom3_provider").forGetter(config -> config.mushroomProvider), (App)BlockStateProvider.f_68747_.fieldOf("pollen_provider").forGetter(config -> config.pollenProvider), (App)Codec.INT.fieldOf("min_height").orElse((Object)15).forGetter(config -> config.minHeight), (App)Codec.INT.fieldOf("max_height").orElse((Object)1).forGetter(config -> config.maxPossibleHeight)).apply((Applicative)codecRecorder, BYGMushroomConfig::new));
    private final BlockStateProvider stemProvider;
    private final BlockStateProvider mushroomProvider;
    private final BlockStateProvider mushroom2Provider;
    private final BlockStateProvider mushroom3Provider;
    private final BlockStateProvider pollenProvider;
    private final int minHeight;
    private final int maxPossibleHeight;
    private boolean forcedPlacement = false;

    BYGMushroomConfig(BlockStateProvider stemProvider, BlockStateProvider mushroomProvider, BlockStateProvider mushroom2Provider, BlockStateProvider mushroom3Provider, BlockStateProvider pollenProvider, int minHeight, int maxPossibleHeight) {
        this.stemProvider = stemProvider;
        this.mushroomProvider = mushroomProvider;
        this.mushroom2Provider = mushroom2Provider;
        this.mushroom3Provider = mushroom3Provider;
        this.pollenProvider = pollenProvider;
        this.minHeight = minHeight;
        this.maxPossibleHeight = maxPossibleHeight;
    }

    public void forcePlacement() {
        this.forcedPlacement = true;
    }

    public BlockStateProvider getStemProvider() {
        return this.stemProvider;
    }

    public BlockStateProvider getMushroomProvider() {
        return this.mushroomProvider;
    }

    public BlockStateProvider getMushroom2Provider() {
        return this.mushroom2Provider;
    }

    public BlockStateProvider getMushroom3Provider() {
        return this.mushroom3Provider;
    }

    public BlockStateProvider getPollenProvider() {
        return this.pollenProvider;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getMaxPossibleHeight() {
        int returnValue = this.maxPossibleHeight - this.minHeight;
        if (returnValue <= 0) {
            returnValue = 1;
        }
        return returnValue;
    }

    public boolean isPlacementForced() {
        return this.forcedPlacement;
    }

    public static class Builder {
        private BlockStateProvider stemProvider = SimpleStateProvider.m_191384_((BlockState)Blocks.f_49999_.m_49966_());
        private BlockStateProvider mushroomProvider;
        private BlockStateProvider mushroom2Provider = this.mushroomProvider = SimpleStateProvider.m_191384_((BlockState)Blocks.f_50050_.m_49966_());
        private BlockStateProvider mushroom3Provider = this.mushroomProvider;
        private BlockStateProvider pollenProvider = SimpleStateProvider.m_191384_((BlockState)BYGBlocks.POLLEN_BLOCK.defaultBlockState());
        private int minHeight = 15;
        private int maxPossibleHeight = 1;

        public Builder setStemBlock(Block block) {
            this.stemProvider = block != null ? SimpleStateProvider.m_191384_((BlockState)block.m_49966_()) : SimpleStateProvider.m_191384_((BlockState)Blocks.f_49999_.m_49966_());
            return this;
        }

        public Builder setStemBlock(BlockState state) {
            this.stemProvider = state != null ? SimpleStateProvider.m_191384_((BlockState)state) : SimpleStateProvider.m_191384_((BlockState)Blocks.f_49999_.m_49966_());
            return this;
        }

        public Builder setMushroomBlock(Block block) {
            this.mushroomProvider = block != null ? SimpleStateProvider.m_191384_((BlockState)block.m_49966_()) : SimpleStateProvider.m_191384_((BlockState)Blocks.f_50050_.m_49966_());
            return this;
        }

        public Builder setMushroomBlock(BlockState state) {
            this.mushroomProvider = state != null ? SimpleStateProvider.m_191384_((BlockState)state) : SimpleStateProvider.m_191384_((BlockState)Blocks.f_50050_.m_49966_());
            return this;
        }

        public Builder setMushroomBlock(WeightedStateProvider statesList) {
            this.mushroomProvider = statesList != null ? statesList : SimpleStateProvider.m_191384_((BlockState)Blocks.f_50050_.m_49966_());
            return this;
        }

        public Builder setMushroom2Block(Block block) {
            this.mushroom2Provider = block != null ? SimpleStateProvider.m_191384_((BlockState)block.m_49966_()) : this.mushroomProvider;
            return this;
        }

        public Builder setMushroom2Block(BlockState state) {
            this.mushroom2Provider = state != null ? SimpleStateProvider.m_191384_((BlockState)state) : this.mushroomProvider;
            return this;
        }

        public Builder setMushroom3Block(Block block) {
            this.mushroom3Provider = block != null ? SimpleStateProvider.m_191384_((BlockState)block.m_49966_()) : this.mushroomProvider;
            return this;
        }

        public Builder setMushroom3Block(BlockState state) {
            this.mushroom3Provider = state != null ? SimpleStateProvider.m_191384_((BlockState)state) : this.mushroomProvider;
            return this;
        }

        public Builder setPollenBlock(Block block) {
            this.mushroom3Provider = block != null ? SimpleStateProvider.m_191384_((BlockState)block.m_49966_()) : this.mushroomProvider;
            return this;
        }

        public Builder setPollenBlock(BlockState state) {
            this.mushroom3Provider = state != null ? SimpleStateProvider.m_191384_((BlockState)state) : this.mushroomProvider;
            return this;
        }

        public Builder setMinHeight(int minHeight) {
            this.minHeight = minHeight;
            return this;
        }

        public Builder setMaxHeight(int maxPossibleHeight) {
            this.maxPossibleHeight = maxPossibleHeight != 0 ? maxPossibleHeight + 1 : 1;
            return this;
        }

        public Builder copy(BYGMushroomConfig config) {
            this.maxPossibleHeight = config.maxPossibleHeight;
            this.minHeight = config.minHeight;
            this.stemProvider = config.stemProvider;
            this.mushroomProvider = config.mushroomProvider;
            this.mushroom2Provider = config.mushroom2Provider;
            this.mushroom3Provider = config.mushroom3Provider;
            this.pollenProvider = config.pollenProvider;
            return this;
        }

        public BYGMushroomConfig build() {
            return new BYGMushroomConfig(this.stemProvider, this.mushroomProvider, this.mushroom2Provider, this.mushroom3Provider, this.pollenProvider, this.minHeight, this.maxPossibleHeight);
        }
    }
}

