/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.biome.nether;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import org.jetbrains.annotations.NotNull;
import potionstudios.byg.BYG;
import potionstudios.byg.common.world.biome.LayersBiomeData;
import potionstudios.byg.common.world.biome.nether.NetherBiomesConfig;
import potionstudios.byg.common.world.math.noise.fastnoise.lite.FastNoiseLite;
import potionstudios.byg.mixin.access.BiomeSourceAccess;
import potionstudios.byg.util.BYGUtil;

public abstract class BYGNetherBiomeSource
extends BiomeSource {
    public static final ResourceLocation LOCATION = BYG.createLocation("nether");
    private final FastNoiseLite lowerLayerRoughnessNoise;
    private final FastNoiseLite upperLayerRoughnessNoise;
    private final Registry<Biome> biomeRegistry;
    private final BiomeResolver upperBiomeResolver;
    private final BiomeResolver middleBiomeResolver;
    private final BiomeResolver bottomResolver;
    private final int bottomTopY;
    private final long seed;

    protected BYGNetherBiomeSource(Registry<Biome> biomeRegistry, long seed) {
        super(BYGNetherBiomeSource.getPossibleBiomes(biomeRegistry));
        this.biomeRegistry = biomeRegistry;
        this.seed = seed;
        this.lowerLayerRoughnessNoise = new FastNoiseLite((int)seed);
        this.lowerLayerRoughnessNoise.SetNoiseType(FastNoiseLite.NoiseType.OpenSimplex2);
        this.lowerLayerRoughnessNoise.SetFrequency(0.005f);
        this.upperLayerRoughnessNoise = new FastNoiseLite((int)seed + 43594389);
        this.upperLayerRoughnessNoise.SetNoiseType(FastNoiseLite.NoiseType.OpenSimplex2);
        this.upperLayerRoughnessNoise.SetFrequency(0.005f);
        NetherBiomesConfig config = NetherBiomesConfig.getConfig();
        Set possibleBiomes = ((BiomeSourceAccess)((Object)this)).byg_getPossibleBiomes().stream().map(Holder::m_203543_).map(Optional::orElseThrow).collect(Collectors.toSet());
        BiPredicate<Collection<ResourceKey<Biome>>, ResourceKey<Biome>> filter = (existing, added) -> !existing.contains(added) && possibleBiomes.contains(added);
        int usedLayerSize = config.layerSize();
        this.upperBiomeResolver = this.getUpperBiomeResolver(biomeRegistry, seed, config.upperLayer().filter(filter));
        this.middleBiomeResolver = this.getMiddleBiomeResolver(biomeRegistry, seed, config.middleLayer().filter(filter));
        this.bottomResolver = this.getLowerBiomeResolver(biomeRegistry, seed, config.bottomLayer().filter(filter));
        this.bottomTopY = QuartPos.m_175400_((int)usedLayerSize);
    }

    public abstract BiomeResolver getUpperBiomeResolver(Registry<Biome> var1, long var2, LayersBiomeData var4);

    public abstract BiomeResolver getMiddleBiomeResolver(Registry<Biome> var1, long var2, LayersBiomeData var4);

    public abstract BiomeResolver getLowerBiomeResolver(Registry<Biome> var1, long var2, LayersBiomeData var4);

    public Holder<Biome> m_203407_(int x, int y, int z, Climate.Sampler sampler) {
        if ((float)y < (float)this.bottomTopY + this.lowerLayerRoughnessNoise.GetNoise(x, z) * 5.0f) {
            return this.bottomResolver.m_203407_(x, y, z, sampler);
        }
        if ((float)y > (float)(this.bottomTopY + this.bottomTopY) + this.upperLayerRoughnessNoise.GetNoise(x, z) * 5.0f) {
            return this.upperBiomeResolver.m_203407_(x, y, z, sampler);
        }
        return this.middleBiomeResolver.m_203407_(x, y, z, sampler);
    }

    protected Registry<Biome> getBiomeRegistry() {
        return this.biomeRegistry;
    }

    protected long getSeed() {
        return this.seed;
    }

    @NotNull
    private static List<Holder<Biome>> getPossibleBiomes(Registry<Biome> biomeRegistry) {
        NetherBiomesConfig config = NetherBiomesConfig.getConfig(false, false, biomeRegistry);
        TreeSet<String> missingBiomes = new TreeSet<String>();
        BiPredicate<Collection<ResourceKey<Biome>>, ResourceKey<Biome>> filter = (existing, added) -> {
            boolean biomeRegistryHas = biomeRegistry.m_142003_(added);
            if (!biomeRegistryHas) {
                missingBiomes.add(added.m_135782_().toString());
            }
            return !existing.contains(added) && biomeRegistryHas;
        };
        LayersBiomeData upperLayer = config.upperLayer().filter(filter);
        LayersBiomeData middleLayer = config.middleLayer().filter(filter);
        LayersBiomeData bottomLayer = config.bottomLayer().filter(filter);
        String ignored = BYGUtil.dumpCollection(missingBiomes);
        if (!ignored.isEmpty()) {
            BYG.LOGGER.warn(String.format("Config \"%s\" warned:\nThe following biome entries were ignored due to not being in this world's biome registry:\n%s", NetherBiomesConfig.CONFIG_PATH.get(), ignored.toString()));
        }
        return BYGUtil.createBiomesFromBiomeData(biomeRegistry, upperLayer, middleLayer, bottomLayer);
    }
}

