/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.client.gui.biomepedia.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.biome.Biome;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;
import potionstudios.byg.client.gui.biomepedia.screen.AbstractBiomepediaScreen;
import potionstudios.byg.client.gui.biomepedia.screen.BiomeAboutScreen;
import potionstudios.byg.client.gui.biomepedia.widget.BiomeWidget;
import potionstudios.byg.common.world.biome.BYGBiomes;
import potionstudios.byg.mixin.access.client.EditBoxAccess;

public class BiomeListScreen
extends AbstractBiomepediaScreen {
    private final Screen parent;
    private int pagePair;
    private ImageButton searchButton;
    private PageButton next;
    private PageButton back;
    private EditBox search;
    private int pagePairsCount;
    private final Mutable<String> lastSearchInput = new MutableObject((Object)"");
    private List<ResourceKey<Biome>> lastInput = new ArrayList<ResourceKey<Biome>>();
    private BiomeWidget[][][] widgets;

    protected BiomeListScreen(Screen parent) {
        super((Component)new TranslatableComponent(""));
        this.parent = parent;
    }

    public void m_96624_() {
        super.m_96624_();
        if (this.search != null) {
            this.search.m_94120_();
        }
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        Registry biomeRegistry = Minecraft.m_91087_().f_91073_.m_5962_().m_175515_(Registry.f_122885_);
        List<ResourceKey<Biome>> resourceKeys = biomeRegistry.m_6579_().stream().map(Map.Entry::getKey).filter(biomeResourceKey -> biomeResourceKey.m_135782_().m_135827_().equals("byg") && biomeResourceKey != BYGBiomes.WINDSWEPT_DUNES).sorted(Comparator.comparing(ResourceKey::m_135782_)).collect(Collectors.toList());
        if (this.widgets == null) {
            this.createMenu(resourceKeys, false);
            this.lastInput = resourceKeys;
        } else {
            this.createMenu(this.lastInput, false);
        }
        PageButton back = new PageButton(this.pageBackButtonX, this.pageButtonY, false, button -> {
            if (this.pagePairsCount == 0) {
                return;
            }
            this.unload(this.pagePair);
            this.pagePair = this.pagePair == 0 ? this.pagePairsCount - 1 : (this.pagePair - 1) % this.pagePairsCount;
            this.load(this.pagePair);
        }, true);
        if (this.back != null) {
            back.f_93623_ = this.back.f_93623_;
            back.f_93624_ = this.back.f_93624_;
        }
        this.back = back;
        this.m_142416_((GuiEventListener)this.back);
        this.back.f_93620_ = this.leftPos + 15;
        this.back.f_93621_ = this.topPos - this.back.m_93694_() - 13;
        PageButton next = new PageButton(this.pageButtonForwardX, this.pageButtonY, true, button -> {
            if (this.pagePairsCount == 0) {
                return;
            }
            this.unload(this.pagePair);
            this.pagePair = (this.pagePair + 1) % this.pagePairsCount;
            this.load(this.pagePair);
        }, true);
        if (this.next != null) {
            next.f_93623_ = this.next.f_93623_;
            next.f_93624_ = this.next.f_93624_;
        }
        this.next = next;
        this.m_142416_((GuiEventListener)this.next);
        this.next.f_93620_ = this.rightPos - this.back.m_5711_() - 22;
        this.next.f_93621_ = this.topPos - this.back.m_93694_() - 13;
        this.load(this.pagePair);
        MutableBoolean snapToFront = new MutableBoolean(false);
        EditBox search = new EditBox(this.f_96541_.f_91062_, this.leftPos + 15, this.bottomPos + 208 - 22, 150, 15, (Component)new TextComponent(""));
        if (this.search != null) {
            search.f_93623_ = this.search.f_93623_;
            search.f_93624_ = this.search.f_93624_;
            search.m_94144_(this.search.m_94155_());
            search.m_94202_(((EditBoxAccess)this.search).byg_getTextColor());
            snapToFront.setValue(true);
        } else {
            search.f_93623_ = false;
            search.f_93624_ = false;
        }
        this.search = search;
        this.search.m_94151_(s -> this.updateForSearchValue(resourceKeys, (String)s, snapToFront.booleanValue()));
        this.searchButton = new ImageButton(this.leftPos + 15, this.bottomPos + 208 - 5, 20, 18, 0, 220, 18, new ResourceLocation("byg", "textures/gui/biomepedia.png"), 256, 256, button -> {
            this.search.f_93624_ = !this.search.f_93624_;
            boolean bl = this.search.f_93623_ = !this.search.f_93623_;
            if (this.search.f_93624_) {
                this.search.m_94178_(true);
                this.back.f_93624_ = false;
                this.back.f_93623_ = false;
            } else {
                this.back.f_93624_ = true;
                this.back.f_93623_ = true;
            }
        }, (button, poseStack, mouseX, mouseZ) -> this.m_96602_(poseStack, (Component)new TranslatableComponent("biomepedia.biomelist.search"), mouseX, mouseZ), TextComponent.f_131282_);
        this.m_142416_((GuiEventListener)this.searchButton);
        this.m_142416_((GuiEventListener)this.search);
    }

    private void updateForSearchValue(List<ResourceKey<Biome>> resourceKeys, String s, boolean snapToFront) {
        if (s.equals(this.lastSearchInput.getValue())) {
            return;
        }
        this.lastSearchInput.setValue((Object)s);
        if (s.isBlank()) {
            this.search.m_94202_(FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
            this.createMenu(resourceKeys, snapToFront);
            this.lastInput = resourceKeys;
            return;
        }
        List<ResourceKey<Biome>> searchResult = resourceKeys.stream().filter(biomeResourceKey -> biomeResourceKey.m_135782_().m_135827_().equals("byg")).sorted(Comparator.comparing(ResourceKey::m_135782_)).filter(biome -> {
            TranslatableComponent translatedComponent = new TranslatableComponent("biome." + biome.m_135782_().m_135827_() + "." + biome.m_135782_().m_135815_());
            return translatedComponent.getString().toLowerCase().contains(s.toLowerCase());
        }).toList();
        this.lastInput = searchResult;
        if (searchResult.isEmpty()) {
            this.search.m_94202_(FastColor.ARGB32.m_13660_((int)255, (int)255, (int)0, (int)0));
        } else {
            this.search.m_94202_(FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
        }
        this.createMenu(searchResult, snapToFront);
    }

    private void createMenu(List<ResourceKey<Biome>> biomes, boolean snapToFront) {
        this.pagePairsCount = (int)Math.ceil((double)biomes.size() / 4.0);
        int registryIdx = 0;
        int offsetFromEdge = 14;
        if (this.widgets != null) {
            this.forEachWidget(biomeWidget -> this.m_6702_().remove(biomeWidget));
        }
        this.widgets = new BiomeWidget[Math.max(this.pagePairsCount, 1)][2][2];
        int xOffset = this.leftPos + offsetFromEdge + 4;
        for (BiomeWidget[][] pagePairs : this.widgets) {
            for (int pageSide = 0; pageSide < pagePairs.length; ++pageSide) {
                int startX = 136 * pageSide;
                int yOffset = this.bottomPos + offsetFromEdge;
                BiomeWidget[] page = pagePairs[pageSide];
                for (int yPos = 0; yPos < page.length && registryIdx <= biomes.size() - 1; ++registryIdx, ++yPos) {
                    ResourceKey<Biome> biome = biomes.get(registryIdx);
                    page[yPos] = (BiomeWidget)this.m_7787_((GuiEventListener)new BiomeWidget(biome, xOffset + startX, yOffset, 115, 77, button -> this.f_96541_.m_91152_((Screen)new BiomeAboutScreen(biome, this))));
                    yOffset = (int)((double)yOffset + 87.03703703703704);
                }
            }
        }
        if (this.widgets.length - 1 < this.pagePair || snapToFront) {
            this.pagePair = 0;
        }
        if (this.back != null && this.next != null) {
            if (this.pagePairsCount > 1) {
                this.back.f_93623_ = true;
                this.back.f_93624_ = true;
                this.next.f_93623_ = true;
                this.next.f_93624_ = true;
            } else {
                this.back.f_93623_ = false;
                this.back.f_93624_ = false;
                this.next.f_93623_ = false;
                this.next.f_93624_ = false;
            }
            this.forEachWidget(biomeWidget -> {
                biomeWidget.f_93624_ = false;
                biomeWidget.f_93623_ = false;
            });
            this.load(this.pagePair);
        }
    }

    private void forEachWidget(Consumer<BiomeWidget> widget) {
        BiomeWidget[][][] biomeWidgetArray = this.widgets;
        int n = biomeWidgetArray.length;
        for (int i = 0; i < n; ++i) {
            BiomeWidget[][] widgetsForPage;
            BiomeWidget[][] biomeWidgetArray2 = widgetsForPage = biomeWidgetArray[i];
            int n2 = biomeWidgetArray2.length;
            for (int j = 0; j < n2; ++j) {
                BiomeWidget[] biomeWidgets;
                for (BiomeWidget biomeWidget : biomeWidgets = biomeWidgetArray2[j]) {
                    if (biomeWidget == null) continue;
                    widget.accept(biomeWidget);
                }
            }
        }
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.forEachWidget(biomeWidget -> biomeWidget.m_6305_(poseStack, mouseX, mouseY, partialTick));
    }

    private void unload(int page) {
        BiomeWidget[][] biomeWidgets;
        BiomeWidget[][] biomeWidgetArray = biomeWidgets = this.widgets[page];
        int n = biomeWidgetArray.length;
        for (int i = 0; i < n; ++i) {
            BiomeWidget[] biomeWidgetsByPage;
            for (BiomeWidget biomeWidget : biomeWidgetsByPage = biomeWidgetArray[i]) {
                if (biomeWidget == null) continue;
                biomeWidget.f_93624_ = false;
                biomeWidget.f_93623_ = false;
            }
        }
    }

    private void load(int page) {
        BiomeWidget[][] biomeWidgets;
        BiomeWidget[][] biomeWidgetArray = biomeWidgets = this.widgets[page];
        int n = biomeWidgetArray.length;
        for (int i = 0; i < n; ++i) {
            BiomeWidget[] biomeWidgetsByPage;
            for (BiomeWidget biomeWidget : biomeWidgetsByPage = biomeWidgetArray[i]) {
                if (biomeWidget == null) continue;
                biomeWidget.f_93624_ = true;
                biomeWidget.f_93623_ = true;
            }
        }
    }
}

