/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.client.config.configeditor;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import org.jetbrains.annotations.Nullable;
import potionstudios.byg.client.config.configeditor.AddConfigEditEntryEntry;
import potionstudios.byg.client.config.configeditor.ConfigCollectionEntry;
import potionstudios.byg.client.config.configeditor.ConfigEditEntry;
import potionstudios.byg.client.config.filebrowser.FileBrowserScreen;
import potionstudios.byg.client.config.serializers.ConfigEntriesSerializer;

public class ConfigEditScreen
extends Screen {
    private final Screen parent;
    private final ConfigEntriesSerializer<?> file;
    private final String shownPath;
    @Nullable
    private final Path absolutePath;
    private final boolean reloadsOnSave;
    private ConfigMap<?> configEntries;
    private String searchCache = "";
    private EditBox searchBox;
    private final Set<ConfigEditEntry<?>> hidden = new ObjectOpenHashSet();

    public ConfigEditScreen(Screen parent, ConfigEntriesSerializer<?> element, String relativizedPath) {
        this(parent, element, relativizedPath, null, false);
    }

    public ConfigEditScreen(Screen parent, ConfigEntriesSerializer<?> element, String relativizedPath, @Nullable Path filePath, boolean reloadsOnSave) {
        super((Component)new TextComponent(String.format("Editing config file: \"%s\"", relativizedPath.toString())));
        this.parent = parent;
        this.file = element;
        this.shownPath = relativizedPath;
        this.absolutePath = filePath;
        this.reloadsOnSave = reloadsOnSave;
    }

    public void m_96624_() {
        this.configEntries.m_6702_().forEach(ConfigEditEntry::tick);
        this.searchBox.m_94120_();
    }

    protected void m_7856_() {
        this.configEntries = new ConfigMap(this, this.f_96543_, this.f_96544_, 40, this.f_96544_ - 37, 25);
        int maxCommentWidth = this.configEntries.m_5759_();
        for (ConfigEditEntry<?> entry : this.file.createEntries(this, this.shownPath)) {
            this.configEntries.addEntry(entry);
            maxCommentWidth = Math.max(maxCommentWidth, entry.getRowWidth());
        }
        this.addConfigEntryButton();
        this.configEntries.rowWidth = maxCommentWidth;
        int searchWidth = 250;
        this.searchBox = new EditBox(Minecraft.m_91087_().f_91062_, this.f_96543_ / 2 - searchWidth / 2, 18, searchWidth, 20, (Component)new TextComponent(""));
        this.searchBox.m_94151_(this::searchResponder);
        int buttonWidth = 150;
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ - this.f_96543_ / 2 - buttonWidth / 2, this.f_96544_ - 30, buttonWidth, 20, CommonComponents.f_130655_, p_95761_ -> this.save()));
        this.m_142416_((GuiEventListener)this.searchBox);
        this.m_7787_((GuiEventListener)this.configEntries);
        super.m_7856_();
    }

    public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_7333_(pPoseStack);
        this.configEntries.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        ConfigEditScreen.m_93215_((PoseStack)pPoseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)5, (int)0xFFFFFF);
        super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        for (ConfigEditEntry child : this.configEntries.m_6702_()) {
            if (!child.renderToolTip) continue;
            this.m_169388_(pPoseStack, child.toolTip, Optional.empty(), pMouseX, pMouseY);
        }
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    private void addConfigEntryButton() {
        BiFunction<String, String, ConfigEditEntry<?>> makeEntry = (key, value) -> {
            Object value1;
            String shownPath = this.file.path() + "." + key;
            if (value.equalsIgnoreCase("list")) {
                return new ConfigCollectionEntry(this, (String)key, this.file.makeList(shownPath), (Component)new TextComponent(""));
            }
            if (value.equalsIgnoreCase("map")) {
                return new ConfigCollectionEntry(this, (String)key, this.file.makeMap(shownPath), (Component)new TextComponent(""));
            }
            try {
                long parseLong;
                value1 = value.contains(".") ? (Number)Double.parseDouble(value) : (Number)((parseLong = Long.parseLong(value)) <= Integer.MAX_VALUE ? (Number)((int)parseLong) : (Number)parseLong);
            }
            catch (Exception e) {
                value1 = value;
            }
            return ConfigEntriesSerializer.makePrimitiveEntry(key, value1, this);
        };
        AddConfigEditEntryEntry addConfigEditEntryEntry = new AddConfigEditEntryEntry(this, this.configEntries, makeEntry, "");
        this.configEntries.addEntry(addConfigEditEntryEntry);
    }

    private void searchResponder(String s) {
        if (!this.searchCache.equals(s)) {
            List children = this.configEntries.m_6702_();
            ArrayList keyCommentToolTipEntries = new ArrayList(children);
            for (ConfigEditEntry child : keyCommentToolTipEntries) {
                if (child.key.toLowerCase(Locale.ROOT).contains(s.toLowerCase(Locale.ROOT))) continue;
                children.remove((Object)child);
                child.renderToolTip = false;
                this.hidden.add(child);
            }
            for (ConfigEditEntry entry : new ObjectOpenHashSet(this.hidden)) {
                if (!entry.key.toLowerCase(Locale.ROOT).contains(s.toLowerCase(Locale.ROOT))) continue;
                children.add(entry);
                this.hidden.remove((Object)entry);
            }
            this.searchCache = s;
            this.configEntries.m_93410_(0.0);
        }
    }

    private void save() {
        StringBuilder errors = new StringBuilder(this.file.save(this.configEntries.m_6702_()));
        if (errors.isEmpty() && this.parent instanceof FileBrowserScreen && this.absolutePath != null) {
            try {
                this.file.saveFile(this.absolutePath);
                if (this.reloadsOnSave) {
                    FileBrowserScreen.ON_RELOAD.accept(this.absolutePath);
                }
                this.f_96541_.m_91300_().m_94922_((Toast)SystemToast.m_94847_((Minecraft)Minecraft.m_91087_(), (SystemToast.SystemToastIds)SystemToast.SystemToastIds.PACK_LOAD_FAILURE, (Component)new TextComponent("Saved Config File:"), (Component)new TextComponent(this.shownPath)));
            }
            catch (Exception e) {
                errors.append(e.getMessage());
            }
        }
        if (!errors.isEmpty()) {
            this.f_96541_.m_91300_().m_94922_((Toast)SystemToast.m_94847_((Minecraft)Minecraft.m_91087_(), (SystemToast.SystemToastIds)SystemToast.SystemToastIds.PACK_LOAD_FAILURE, (Component)new TextComponent("Could not save File."), (Component)new TextComponent(errors.toString())));
        } else {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    public static class ConfigMap<T>
    extends ContainerObjectSelectionList<ConfigEditEntry<T>> {
        private final Screen screen;
        private int rowWidth = super.m_5759_();

        public ConfigMap(Screen screen, int width, int height, int y0, int y1, int itemHeight) {
            super(Minecraft.m_91087_(), width, height, y0, y1, itemHeight);
            this.screen = screen;
            this.m_93488_(false);
        }

        protected boolean m_5694_() {
            return this.screen.m_7222_() == this;
        }

        public int addEntry(ConfigEditEntry $$0) {
            return super.m_7085_((AbstractSelectionList.Entry)$$0);
        }

        protected int m_5756_() {
            return this.f_93388_ - 10;
        }

        public int m_5759_() {
            return this.rowWidth;
        }
    }
}

