/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.resourcepack;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.mehvahdjukaar.selene.Selene;
import net.mehvahdjukaar.selene.client.asset_generators.LangBuilder;
import net.mehvahdjukaar.selene.client.asset_generators.textures.TextureImage;
import net.mehvahdjukaar.selene.resourcepack.DynamicResourcePack;
import net.mehvahdjukaar.selene.resourcepack.ResType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.locating.IModFile;

public class DynamicTexturePack
extends DynamicResourcePack {
    public DynamicTexturePack(ResourceLocation name, PackType type, Pack.Position position, boolean fixed, boolean hidden) {
        super(name, PackType.CLIENT_RESOURCES, position, fixed, hidden);
    }

    public DynamicTexturePack(ResourceLocation name) {
        super(name, PackType.CLIENT_RESOURCES);
    }

    void addPackLogo() {
        ModList.get().getModContainerById(this.mainNamespace).ifPresent(m -> {
            IModInfo mod = m.getModInfo();
            IModFile file = mod.getOwningFile().getFile();
            mod.getLogoFile().ifPresent(logo -> {
                try {
                    Path logoPath;
                    if (file != null && Files.exists(logoPath = file.findResource(new String[]{logo}), new LinkOption[0])) {
                        this.addRootResource("pack.png", Files.readAllBytes(logoPath));
                    }
                }
                catch (Exception e) {
                    Selene.LOGGER.error("Failed to add dynamic pack logo. Why?");
                }
            });
        });
    }

    public void addAndCloseTexture(ResourceLocation path, TextureImage image) {
        try (TextureImage textureImage = image;){
            this.addBytes(path, image.getImage().m_85121_(), ResType.TEXTURES);
            JsonObject mcmeta = image.serializeMcMeta();
            if (mcmeta != null) {
                this.addJson(path, (JsonElement)mcmeta, ResType.MCMETA);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to add image {} to resource pack {}.", (Object)path, (Object)this.resourcePackName, (Object)e);
        }
    }

    public void addBlockModel(ResourceLocation modelLocation, JsonElement model) {
        this.addJson(modelLocation, model, ResType.BLOCK_MODELS);
    }

    public void addItemModel(ResourceLocation modelLocation, JsonElement model) {
        this.addJson(modelLocation, model, ResType.ITEM_MODELS);
    }

    public void addBlockState(ResourceLocation modelLocation, JsonElement model) {
        this.addJson(modelLocation, model, ResType.BLOCKSTATES);
    }

    public void addLang(ResourceLocation langName, JsonElement language) {
        this.addJson(langName, language, ResType.LANG);
    }

    public void addLang(ResourceLocation langName, LangBuilder builder) {
        this.addJson(langName, builder.build(), ResType.LANG);
    }
}

