/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.world;

import com.google.common.collect.ImmutableList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.OreBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ReplaceBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.AcaciaFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.ForkingTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.util.ModResourceLocation;

@Mod.EventBusSubscriber(modid="silentgear")
public final class ModWorldFeatures {
    public static final RuleTest END_STONE_RULE_TEST = new TagMatchTest(Tags.Blocks.END_STONES);
    private static boolean configuredFeaturesRegistered = false;

    private ModWorldFeatures() {
    }

    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
    }

    private static void registerConfiguredFeatures() {
        if (configuredFeaturesRegistered) {
            return;
        }
        configuredFeaturesRegistered = true;
        Configured.TO_REGISTER.forEach((name, cf) -> ModWorldFeatures.registerConfiguredFeature(name, (ConfiguredFeature)cf.get()));
    }

    private static void registerConfiguredFeature(String name, ConfiguredFeature<?, ?> configuredFeature) {
        ModResourceLocation id = SilentGear.getId(name);
        ModWorldFeatures.debugLog("Register configured feature " + id);
        Registry.m_122965_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)id, configuredFeature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent biome) {
        ModWorldFeatures.registerConfiguredFeatures();
        if (biome.getCategory() == Biome.BiomeCategory.NETHER) {
            ModWorldFeatures.addNetherwoodTrees(biome);
            ModWorldFeatures.addCrimsonIronOre(biome);
        } else if (biome.getCategory() == Biome.BiomeCategory.THEEND) {
            ModWorldFeatures.addAzureSilverOre(biome);
        } else {
            ModWorldFeatures.addBortOre(biome);
            if (biome.getCategory() == Biome.BiomeCategory.EXTREME_HILLS || biome.getCategory() == Biome.BiomeCategory.PLAINS) {
                ModWorldFeatures.addWildFlax(biome);
            }
            if (biome.getClimate().f_47683_ > 0.4f) {
                ModWorldFeatures.addWildFluffyPlants(biome);
            }
        }
    }

    private static void addWildFlax(BiomeLoadingEvent biome) {
        ModWorldFeatures.debugLog("Add wild flax to " + biome.getName());
        biome.getGeneration().m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, Placed.FLOWER_WILD_FLAX);
    }

    private static void addWildFluffyPlants(BiomeLoadingEvent biome) {
        ModWorldFeatures.debugLog("Add wild fluffy plants to " + biome.getName());
        biome.getGeneration().m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, Placed.FLOWER_WILD_FLUFFY);
    }

    private static void addNetherwoodTrees(BiomeLoadingEvent biome) {
    }

    private static void addBortOre(BiomeLoadingEvent biome) {
        biome.getGeneration().m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, Placed.ORE_BORT);
    }

    private static void addCrimsonIronOre(BiomeLoadingEvent biome) {
        if (Biomes.f_48175_.m_135782_().equals((Object)biome.getName()) || Biomes.f_48199_.m_135782_().equals((Object)biome.getName())) {
            ModWorldFeatures.debugLog("Add double crimson iron ores to " + biome.getName());
            biome.getGeneration().m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, Placed.ORE_CRIMSON_IRON_DOUBLE);
        } else {
            ModWorldFeatures.debugLog("Add crimson iron ores to " + biome.getName());
            biome.getGeneration().m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, Placed.ORE_CRIMSON_IRON);
        }
    }

    private static void addAzureSilverOre(BiomeLoadingEvent biome) {
        ModWorldFeatures.debugLog("Add azure silver ores to " + biome.getName());
        biome.getGeneration().m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, Placed.ORE_AZURE_SILVER);
    }

    private static void debugLog(String msg) {
        if (((Boolean)Config.Common.worldGenLogging.get()).booleanValue()) {
            SilentGear.LOGGER.debug(msg);
        }
    }

    public static final class Configured {
        static final Map<String, Lazy<ConfiguredFeature<?, ?>>> TO_REGISTER = new LinkedHashMap();
        private static final ReplaceBlockConfiguration BORT_ORE_VEINS_CONFIG = new ReplaceBlockConfiguration((List)ImmutableList.of((Object)OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)((OreBlock)ModBlocks.BORT_ORE.get()).m_49966_()), (Object)OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)((OreBlock)ModBlocks.DEEPSLATE_BORT_ORE.get()).m_49966_())));
        private static final OreConfiguration CRIMSON_IRON_ORE_VEINS_CONFIG = new OreConfiguration(OreFeatures.f_195075_, ModBlocks.CRIMSON_IRON_ORE.asBlockState(), 8);
        private static final OreConfiguration AZURE_SILVER_ORE_VEINS_CONFIG = new OreConfiguration(END_STONE_RULE_TEST, ModBlocks.AZURE_SILVER_ORE.asBlockState(), 6);
        private static final RandomPatchConfiguration WILD_FLAX_PATCHES_CONFIG = FeatureUtils.m_206480_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.WILD_FLAX_PLANT.get()))), List.of(), (int)32);
        private static final RandomPatchConfiguration WILD_FLUFFY_PATCHES_CONFIG = FeatureUtils.m_206480_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.WILD_FLUFFY_PLANT.get()))), List.of(), (int)32);
        public static final TreeConfiguration NETHERWOOD_TREE_CONFIG = new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)ModBlocks.NETHERWOOD_LOG.asBlockState()), (TrunkPlacer)new ForkingTrunkPlacer(5, 2, 2), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)ModBlocks.NETHERWOOD_LEAVES.asBlockState()), (FoliagePlacer)new AcaciaFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)0)), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).m_68244_().m_68251_();
        public static final Holder<ConfiguredFeature<ReplaceBlockConfiguration, ?>> BORT_ORE_VEINS = Configured.create("bort_ore_veins", Feature.f_159732_, BORT_ORE_VEINS_CONFIG);
        public static final Holder<ConfiguredFeature<OreConfiguration, ?>> CRIMSON_IRON_ORE_VEINS = Configured.create("crimson_iron_ore_veins", Feature.f_65731_, CRIMSON_IRON_ORE_VEINS_CONFIG);
        public static final Holder<ConfiguredFeature<OreConfiguration, ?>> AZURE_SILVER_ORE_VEINS = Configured.create("azure_silver_ore_veins", Feature.f_65731_, AZURE_SILVER_ORE_VEINS_CONFIG);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> WILD_FLAX_PATCHES = Configured.create("wild_flax_patches", Feature.f_65761_, WILD_FLAX_PATCHES_CONFIG);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> WILD_FLUFFY_PATCHES = Configured.create("wild_fluffy_patches", Feature.f_65761_, WILD_FLUFFY_PATCHES_CONFIG);
        public static final Holder<ConfiguredFeature<TreeConfiguration, ?>> NETHERWOOD_TREE = Configured.create("netherwood_tree", Feature.f_65760_, NETHERWOOD_TREE_CONFIG);

        public static <FC extends FeatureConfiguration> Holder<ConfiguredFeature<FC, ?>> create(String name, Feature<FC> feature, FC featureConfig) {
            return FeatureUtils.m_206488_((String)("silentgear:" + name), feature, featureConfig);
        }

        private static Lazy<ConfiguredFeature<?, ?>> createLazy(String name, Supplier<ConfiguredFeature<?, ?>> supplier) {
            if (TO_REGISTER.containsKey(name)) {
                throw new IllegalArgumentException("Configured feature lazy with name '" + name + "' already created");
            }
            Lazy lazy = Lazy.of(supplier);
            TO_REGISTER.put(name, lazy);
            return lazy;
        }

        private Configured() {
        }
    }

    public static final class Placed {
        public static final Holder<PlacedFeature> ORE_BORT = Placed.create("ore_bort", Configured.BORT_ORE_VEINS, Placed.commonOrePlacement((Integer)Config.Common.bortCount.get(), (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-60), (VerticalAnchor)VerticalAnchor.m_158922_((int)10))));
        public static final Holder<PlacedFeature> ORE_CRIMSON_IRON = Placed.create("ore_crimson_iron", Configured.CRIMSON_IRON_ORE_VEINS, Placed.commonOrePlacement((Integer)Config.Common.crimsonIronCount.get(), PlacementUtils.f_195357_));
        public static final Holder<PlacedFeature> ORE_CRIMSON_IRON_DOUBLE = Placed.create("ore_crimson_iron_double", Configured.CRIMSON_IRON_ORE_VEINS, Placed.commonOrePlacement(2 * (Integer)Config.Common.crimsonIronCount.get(), PlacementUtils.f_195357_));
        public static final Holder<PlacedFeature> ORE_AZURE_SILVER = Placed.create("ore_azure_silver", Configured.AZURE_SILVER_ORE_VEINS, Placed.commonOrePlacement((Integer)Config.Common.azureSilverCount.get(), (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)16), (VerticalAnchor)VerticalAnchor.m_158922_((int)92))));
        public static final Holder<PlacedFeature> FLOWER_WILD_FLAX = Placed.create("flower_wild_flax", Configured.WILD_FLAX_PATCHES, new PlacementModifier[]{RarityFilter.m_191900_((int)64), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final Holder<PlacedFeature> FLOWER_WILD_FLUFFY = Placed.create("flower_wild_fluffy", Configured.WILD_FLUFFY_PATCHES, new PlacementModifier[]{RarityFilter.m_191900_((int)64), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});

        private static <FC extends FeatureConfiguration> Holder<PlacedFeature> create(String name, Holder<ConfiguredFeature<FC, ?>> configuredFeature, List<PlacementModifier> modifiers) {
            return PlacementUtils.m_206509_((String)("silentgear:" + name), configuredFeature, modifiers);
        }

        private static <FC extends FeatureConfiguration> Holder<PlacedFeature> create(String name, Holder<ConfiguredFeature<FC, ?>> configuredFeature, PlacementModifier ... modifiers) {
            return PlacementUtils.m_206513_((String)("silentgear:" + name), configuredFeature, (PlacementModifier[])modifiers);
        }

        private static List<PlacementModifier> orePlacement(PlacementModifier p_195347_, PlacementModifier p_195348_) {
            return List.of(p_195347_, InSquarePlacement.m_191715_(), p_195348_, BiomeFilter.m_191561_());
        }

        private static List<PlacementModifier> commonOrePlacement(int p_195344_, PlacementModifier p_195345_) {
            return Placed.orePlacement((PlacementModifier)CountPlacement.m_191628_((int)p_195344_), p_195345_);
        }

        private static List<PlacementModifier> rareOrePlacement(int p_195350_, PlacementModifier p_195351_) {
            return Placed.orePlacement((PlacementModifier)RarityFilter.m_191900_((int)p_195350_), p_195351_);
        }

        private Placed() {
        }
    }
}

