/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.item.gear.GearAxeItem;

public class GearSawItem
extends GearAxeItem {
    public GearSawItem(GearType gearType) {
        super(gearType, (Set<Material>)ImmutableSet.of((Object)Material.f_76320_));
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        BlockState state;
        Level world = player.f_19853_;
        if (!world.f_46443_ && GearSawItem.isLog(state = world.m_8055_(pos)) && GearSawItem.detectTree((BlockGetter)world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), state.m_60734_())) {
            if (player.m_150110_().f_35937_) {
                return false;
            }
            TreeBreakResult result = new TreeBreakResult(stack, player);
            this.breakTree(result, world, pos, pos, 0);
            SilentGear.LOGGER.debug("{} chopped down a tree with {} blocks using {}. Max recursion depth: {}", (Object)player.m_6302_(), (Object)result.blocksBroken, (Object)stack.m_41786_().getString(), (Object)result.maxDepth);
            return true;
        }
        return false;
    }

    private static boolean detectTree(BlockGetter world, int x, int y, int z, Block wood) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        int height = y;
        boolean foundTop = false;
        do {
            if (GearSawItem.checkForLogs(world, pos.m_5484_(Direction.UP, ++height - y))) continue;
            --height;
            foundTop = true;
        } while (!foundTop);
        int foliageCount = 0;
        if (height - y < 50) {
            for (int xPos = x - 1; xPos <= x + 1; ++xPos) {
                for (int yPos = height - 1; yPos <= height + 1; ++yPos) {
                    for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                        BlockState leaves = world.m_8055_((BlockPos)pos.m_122178_(xPos, yPos, zPos));
                        if (!GearSawItem.isFoliage(leaves)) continue;
                        ++foliageCount;
                    }
                }
            }
        }
        return foliageCount > 3;
    }

    private static boolean checkForLogs(BlockGetter world, BlockPos pos) {
        return GearSawItem.isLog(world.m_8055_(pos)) || GearSawItem.isLog(world.m_8055_(pos.m_142300_(Direction.NORTH))) || GearSawItem.isLog(world.m_8055_(pos.m_142300_(Direction.SOUTH))) || GearSawItem.isLog(world.m_8055_(pos.m_142300_(Direction.EAST))) || GearSawItem.isLog(world.m_8055_(pos.m_142300_(Direction.WEST))) || GearSawItem.isLog(world.m_8055_(pos.m_142300_(Direction.NORTH).m_142300_(Direction.EAST))) || GearSawItem.isLog(world.m_8055_(pos.m_142300_(Direction.NORTH).m_142300_(Direction.WEST))) || GearSawItem.isLog(world.m_8055_(pos.m_142300_(Direction.SOUTH).m_142300_(Direction.EAST))) || GearSawItem.isLog(world.m_8055_(pos.m_142300_(Direction.SOUTH).m_142300_(Direction.WEST)));
    }

    private static boolean isLog(BlockState state) {
        return GearSawItem.isLog(state, null);
    }

    private static boolean isLog(BlockState state, @Nullable TreeBreakResult result) {
        if (result != null && result.firstLog != null) {
            return state.m_60734_() == result.firstLog;
        }
        return state.m_204336_(BlockTags.f_13106_);
    }

    private static boolean isFoliage(BlockState state) {
        return GearSawItem.isFoliage(state, null);
    }

    private static boolean isFoliage(BlockState state, @Nullable TreeBreakResult result) {
        if (state.m_60734_() == Blocks.f_50701_) {
            return true;
        }
        if (state.m_61138_((Property)LeavesBlock.f_54419_) && ((Boolean)state.m_61143_((Property)LeavesBlock.f_54419_)).booleanValue()) {
            return false;
        }
        if (result != null && result.firstFoliage != null) {
            return state.m_60734_() == result.firstFoliage;
        }
        return state.m_204336_(BlockTags.f_13035_) || state.m_204336_(BlockTags.f_13078_);
    }

    private void breakTree(TreeBreakResult result, Level world, BlockPos pos, BlockPos startPos, int recursionDepth) {
        result.maxDepth = recursionDepth;
        if (recursionDepth > (Integer)Config.Common.sawRecursionDepth.get()) {
            return;
        }
        for (int xPos = pos.m_123341_() - 1; xPos <= pos.m_123341_() + 1; ++xPos) {
            for (int yPos = pos.m_123342_() - 1; yPos <= pos.m_123342_() + 1; ++yPos) {
                for (int zPos = pos.m_123343_() - 1; zPos <= pos.m_123343_() + 1; ++zPos) {
                    BlockPos localPos = new BlockPos(xPos, yPos, zPos);
                    BlockState localState = world.m_8055_(localPos);
                    Block localBlock = localState.m_60734_();
                    boolean isLog = GearSawItem.isLog(localState, result);
                    boolean isFoliage = GearSawItem.isFoliage(localState, result);
                    if (!isLog && !isFoliage) continue;
                    if (isLog && result.firstLog == null) {
                        result.firstLog = localBlock;
                    }
                    if (isFoliage && result.firstFoliage == null) {
                        result.firstFoliage = localBlock;
                    }
                    float localHardness = localState.m_60800_((BlockGetter)world, localPos);
                    if (!this.isCorrectToolForDrops(result.tool, localState) || !(localHardness >= 0.0f)) continue;
                    BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, localPos, localState, result.player);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    boolean cancel = event.isCanceled();
                    int xDist = xPos - startPos.m_123341_();
                    int yDist = yPos - startPos.m_123342_();
                    int zDist = zPos - startPos.m_123343_();
                    if (9 * xDist * xDist + yDist * yDist + 9 * zDist * zDist >= 1000) continue;
                    if (cancel) {
                        this.breakTree(result, world, localPos, startPos, recursionDepth + 1);
                        continue;
                    }
                    if (!result.player.m_150110_().f_35937_) {
                        localBlock.m_6240_(world, result.player, pos, localState, world.m_7702_(pos), result.tool);
                        this.m_6813_(result.tool, world, localState, localPos, (LivingEntity)result.player);
                        ++result.blocksBroken;
                    }
                    world.m_7471_(localPos, false);
                    this.breakTree(result, world, localPos, startPos, recursionDepth + 1);
                }
            }
        }
    }

    private static final class TreeBreakResult {
        final ItemStack tool;
        final Player player;
        int blocksBroken;
        int maxDepth;
        Block firstLog;
        Block firstFoliage;

        private TreeBreakResult(ItemStack tool, Player player) {
            this.tool = tool;
            this.player = player;
        }
    }
}

