/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.blueprint;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.part.IGearPart;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.client.KeyTracker;
import net.silentchaos512.gear.client.util.TextListBuilder;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.gear.part.PartManager;
import net.silentchaos512.gear.item.blueprint.AbstractBlueprintItem;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.lib.util.NameUtils;
import net.silentchaos512.utils.Color;
import net.silentchaos512.utils.MathUtils;

public class GearBlueprintItem
extends AbstractBlueprintItem {
    private final GearType gearType;
    private TagKey<Item> itemTag;

    public GearBlueprintItem(GearType gearType, boolean singleUse, Item.Properties properties) {
        super(properties, singleUse);
        this.gearType = gearType;
    }

    @Override
    public PartType getPartType(ItemStack stack) {
        return PartType.MAIN;
    }

    public GearType getGearType() {
        return this.gearType;
    }

    @Override
    public GearType getGearType(ItemStack stack) {
        return this.gearType;
    }

    @Override
    public TagKey<Item> getItemTag() {
        ResourceLocation id;
        if (this.itemTag == null && (id = this.getRegistryName()) != null) {
            this.itemTag = ItemTags.create((ResourceLocation)new ResourceLocation(id.m_135827_(), "blueprints/" + this.gearType.getName()));
        }
        return this.itemTag;
    }

    @Override
    protected Component getCraftedName(ItemStack stack) {
        ResourceLocation id = this.getRegistryName();
        if (id == null) {
            return new TextComponent("ERROR");
        }
        return new TranslatableComponent(Util.m_137492_((String)"item", (ResourceLocation)new ResourceLocation(id.m_135827_(), this.gearType.getName())));
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flags) {
        String itemClass = this.gearType.getName();
        if (!this.gearType.isArmor()) {
            String key = "item." + NameUtils.fromItem((ItemStack)stack).m_135827_() + ".blueprint." + itemClass + ".desc";
            tooltip.add((Component)new TranslatableComponent(key).m_130940_(ChatFormatting.ITALIC));
        }
        if (!MathUtils.floatsEqual((float)this.gearType.getArmorDurabilityMultiplier(), (float)1.0f)) {
            tooltip.add((Component)TextUtil.translate("item", "blueprint.armorDurability", Float.valueOf(this.gearType.getArmorDurabilityMultiplier())).m_130940_(ChatFormatting.ITALIC));
        }
        super.m_7373_(stack, level, tooltip, flags);
        if (this.isDisabled()) {
            tooltip.add((Component)new TranslatableComponent("item.silentgear.blueprint.disabled").m_130940_(ChatFormatting.DARK_RED));
        } else if (this.singleUse) {
            tooltip.add((Component)new TranslatableComponent("item.silentgear.blueprint.singleUse").m_130940_(ChatFormatting.RED));
        } else {
            tooltip.add((Component)new TranslatableComponent("item.silentgear.blueprint.multiUse").m_130940_(ChatFormatting.GREEN));
        }
        this.appendSupportedTypesText(tooltip);
    }

    private void appendSupportedTypesText(Collection<Component> list) {
        if (KeyTracker.isDisplayStatsDown()) {
            Optional<ICoreItem> itemOptional = this.gearType.getItem();
            if (itemOptional.isPresent()) {
                TextListBuilder builder = new TextListBuilder();
                ICoreItem item = itemOptional.get();
                ItemStack gear = new ItemStack((ItemLike)item);
                for (PartType type : PartType.getValues()) {
                    List<IGearPart> partsOfType;
                    if (type == PartType.MAIN || (partsOfType = PartManager.getPartsOfType(type)).isEmpty() || !item.supportsPart(gear, PartData.of(partsOfType.get(0)))) continue;
                    builder.add((Component)type.getDisplayName(0));
                }
                List<Component> lines = builder.build();
                if (!lines.isEmpty()) {
                    list.add((Component)TextUtil.withColor(TextUtil.misc("supportedPartTypes", new Object[0]), Color.GOLD));
                    list.addAll(lines);
                }
            }
        } else {
            list.add((Component)TextUtil.withColor(TextUtil.misc("supportedPartTypes", new Object[0]), Color.GOLD).m_130946_(" ").m_7220_((Component)TextUtil.withColor(TextUtil.keyBinding(KeyTracker.DISPLAY_STATS), ChatFormatting.GRAY)));
        }
    }
}

