/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.init;

import java.util.function.Supplier;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.registries.RegistryObject;
import net.silentchaos512.gear.init.Registration;
import net.silentchaos512.gear.loot.condition.HasTraitCondition;
import net.silentchaos512.gear.loot.function.SelectGearTierLootFunction;
import net.silentchaos512.gear.loot.function.SetPartsFunction;
import net.silentchaos512.gear.loot.modifier.BonusDropsTraitLootModifier;
import net.silentchaos512.gear.loot.modifier.MagmaticTraitLootModifier;

public final class ModLootStuff {
    public static final RegistryObject<LootItemConditionType> HAS_TRAIT = ModLootStuff.registerCondition("has_trait", () -> new LootItemConditionType((Serializer)HasTraitCondition.SERIALIZER));
    public static final RegistryObject<LootItemFunctionType> SELECT_TIER = ModLootStuff.registerFunction("select_tier", () -> new LootItemFunctionType((Serializer)SelectGearTierLootFunction.SERIALIZER));
    public static final RegistryObject<LootItemFunctionType> SET_PARTS = ModLootStuff.registerFunction("set_parts", () -> new LootItemFunctionType((Serializer)SetPartsFunction.SERIALIZER));
    public static final RegistryObject<GlobalLootModifierSerializer<?>> BONUS_DROPS_TRAIT = ModLootStuff.registerGlobalModifier("bonus_drops_trait", BonusDropsTraitLootModifier.Serializer::new);
    public static final RegistryObject<GlobalLootModifierSerializer<?>> MAGMATIC_SMELTING = ModLootStuff.registerGlobalModifier("magmatic_smelting", MagmaticTraitLootModifier.Serializer::new);

    private ModLootStuff() {
    }

    public static void init() {
    }

    private static <T extends LootItemConditionType> RegistryObject<T> registerCondition(String name, Supplier<T> condition) {
        return Registration.LOOT_CONDITIONS.register(name, condition);
    }

    private static <T extends LootItemFunctionType> RegistryObject<T> registerFunction(String name, Supplier<T> condition) {
        return Registration.LOOT_FUNCTIONS.register(name, condition);
    }

    private static <T extends GlobalLootModifierSerializer<?>> RegistryObject<T> registerGlobalModifier(String name, Supplier<T> serializer) {
        return Registration.LOOT_MODIFIERS.register(name, serializer);
    }
}

