/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.init;

import java.util.Arrays;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.RegistryObject;
import net.silentchaos512.gear.block.charger.ChargerTileEntity;
import net.silentchaos512.gear.block.compounder.CompounderTileEntity;
import net.silentchaos512.gear.block.grader.GraderTileEntity;
import net.silentchaos512.gear.block.press.MetalPressTileEntity;
import net.silentchaos512.gear.block.salvager.SalvagerTileEntity;
import net.silentchaos512.gear.crafting.recipe.compounder.FabricCompoundingRecipe;
import net.silentchaos512.gear.crafting.recipe.compounder.GemCompoundingRecipe;
import net.silentchaos512.gear.crafting.recipe.compounder.MetalCompoundingRecipe;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.init.Registration;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.lib.block.IBlockProvider;

public final class ModBlockEntities {
    public static final RegistryObject<BlockEntityType<GraderTileEntity>> MATERIAL_GRADER = ModBlockEntities.register("material_grader", GraderTileEntity::new, new IBlockProvider[]{ModBlocks.MATERIAL_GRADER});
    public static final RegistryObject<BlockEntityType<CompounderTileEntity<MetalCompoundingRecipe>>> METAL_ALLOYER = ModBlockEntities.register("metal_alloyer", (pos, state) -> new CompounderTileEntity<MetalCompoundingRecipe>(Const.METAL_COMPOUNDER_INFO, pos, state), new IBlockProvider[]{ModBlocks.METAL_ALLOYER});
    public static final RegistryObject<BlockEntityType<MetalPressTileEntity>> METAL_PRESS = ModBlockEntities.register("metal_press", MetalPressTileEntity::new, new IBlockProvider[]{ModBlocks.METAL_PRESS});
    public static final RegistryObject<BlockEntityType<CompounderTileEntity<GemCompoundingRecipe>>> RECRYSTALLIZER = ModBlockEntities.register("recrystallizer", (pos, state) -> new CompounderTileEntity<GemCompoundingRecipe>(Const.GEM_COMPOUNDER_INFO, pos, state), new IBlockProvider[]{ModBlocks.RECRYSTALLIZER});
    public static final RegistryObject<BlockEntityType<CompounderTileEntity<FabricCompoundingRecipe>>> REFABRICATOR = ModBlockEntities.register("refabricator", (pos, state) -> new CompounderTileEntity<FabricCompoundingRecipe>(Const.FABRIC_COMPOUNDER_INFO, pos, state), new IBlockProvider[]{ModBlocks.REFABRICATOR});
    public static final RegistryObject<BlockEntityType<SalvagerTileEntity>> SALVAGER = ModBlockEntities.register("salvager", SalvagerTileEntity::new, new IBlockProvider[]{ModBlocks.SALVAGER});
    public static final RegistryObject<BlockEntityType<ChargerTileEntity>> STARLIGHT_CHARGER = ModBlockEntities.register("starlight_charger", ChargerTileEntity::createStarlightCharger, new IBlockProvider[]{ModBlocks.STARLIGHT_CHARGER});

    private ModBlockEntities() {
    }

    static void register() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRenderers(FMLClientSetupEvent event) {
    }

    private static <T extends BlockEntity> RegistryObject<BlockEntityType<T>> register(String name, BlockEntityType.BlockEntitySupplier<T> factory, IBlockProvider ... blocks) {
        return Registration.BLOCK_ENTITIES.register(name, () -> {
            Block[] validBlocks = (Block[])Arrays.stream(blocks).map(IBlockProvider::asBlock).toArray(Block[]::new);
            return BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)factory, (Block[])validBlocks).m_58966_(null);
        });
    }
}

