/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.init;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.init.Registration;
import net.silentchaos512.gear.item.CraftingItems;
import net.silentchaos512.lib.block.IBlockProvider;

public class GearVillages {
    public static final ResourceLocation GEAR_SMITH = SilentGear.getId("gear_smith");
    public static final ResourceLocation HOTV_GEAR_SMITH = SilentGear.getId("gameplay/hero_of_the_village/gear_smith");
    public static final RegistryObject<PoiType> POI_GEAR_SMITHING_TABLE = GearVillages.registerPointOfInterest("gear_smithing_table", ModBlocks.GEAR_SMITHING_TABLE);
    public static final RegistryObject<VillagerProfession> PROF_GEAR_SMITH = GearVillages.registerProfession("gear_smith", POI_GEAR_SMITHING_TABLE, SoundEvents.f_12574_);

    private static RegistryObject<PoiType> registerPointOfInterest(String name, IBlockProvider block) {
        return Registration.POINTS_OF_INTEREST.register(name, () -> {
            PoiType type = new PoiType("silentgear:" + name, (Set)ImmutableSet.of((Object)block.asBlockState()), 1, 1);
            PoiType.m_27367_((PoiType)type);
            return type;
        });
    }

    private static RegistryObject<VillagerProfession> registerProfession(String name, Supplier<PoiType> poi, SoundEvent sound) {
        return Registration.PROFESSIONS.register(name, () -> new VillagerProfession(SilentGear.getId(name).toString(), (PoiType)poi.get(), ImmutableSet.of(), ImmutableSet.of(), sound));
    }

    public static void init() {
    }

    public static void register() {
    }

    private static class SellingItemTrade
    implements VillagerTrades.ItemListing {
        private final ItemStack givenItem;
        private final int emeraldCount;
        private final int sellingItemCount;
        private final int maxUses;
        private final int xpValue;
        private final float priceMultiplier;

        public SellingItemTrade(ItemLike givenItem, int emeraldCount, int sellingItemCount, int xpValue) {
            this(new ItemStack(givenItem), emeraldCount, sellingItemCount, 12, xpValue);
        }

        public SellingItemTrade(ItemLike givenItem, int emeraldCount, int sellingItemCount, int maxUses, int xpValue) {
            this(new ItemStack(givenItem), emeraldCount, sellingItemCount, maxUses, xpValue);
        }

        public SellingItemTrade(ItemStack givenItem, int emeraldCount, int sellingItemCount, int maxUses, int xpValue) {
            this(givenItem, emeraldCount, sellingItemCount, maxUses, xpValue, 0.05f);
        }

        public SellingItemTrade(ItemStack givenItem, int emeraldCount, int sellingItemCount, int maxUses, int xpValue, float priceMultiplier) {
            this.givenItem = givenItem;
            this.emeraldCount = emeraldCount;
            this.sellingItemCount = sellingItemCount;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
            this.priceMultiplier = priceMultiplier;
        }

        public MerchantOffer m_5670_(Entity trader, Random rand) {
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, this.emeraldCount), new ItemStack((ItemLike)this.givenItem.m_41720_(), this.sellingItemCount), this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }

    private static class BuyingItemTrade
    implements VillagerTrades.ItemListing {
        private final Item wantedItem;
        private final int count;
        private final int maxUses;
        private final int xpValue;
        private final float priceMultiplier;

        public BuyingItemTrade(ItemLike wantedItem, int countIn, int maxUsesIn, int xpValueIn) {
            this.wantedItem = wantedItem.m_5456_();
            this.count = countIn;
            this.maxUses = maxUsesIn;
            this.xpValue = xpValueIn;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer m_5670_(Entity trader, Random rand) {
            ItemStack stack = new ItemStack((ItemLike)this.wantedItem, this.count);
            return new MerchantOffer(stack, new ItemStack((ItemLike)Items.f_42616_), this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }

    @Mod.EventBusSubscriber(modid="silentgear")
    public static final class Events {
        private Events() {
        }

        @SubscribeEvent
        public static void registerTrades(VillagerTradesEvent event) {
            Int2ObjectMap trades = event.getTrades();
            if (GEAR_SMITH.equals((Object)event.getType().getRegistryName())) {
                ((List)trades.get(1)).add(new BuyingItemTrade(CraftingItems.FLAX_FLOWERS, 24, 16, 2));
                ((List)trades.get(1)).add(new SellingItemTrade(CraftingItems.BLUEPRINT_PAPER, 1, 12, 12, 2));
                ((List)trades.get(2)).add(new SellingItemTrade((ItemLike)ModItems.EXCAVATOR_BLUEPRINT, 7, 1, 2, 12));
                ((List)trades.get(2)).add(new SellingItemTrade((ItemLike)ModItems.HAMMER_BLUEPRINT, 7, 1, 2, 12));
                ((List)trades.get(2)).add(new SellingItemTrade((ItemLike)ModItems.PAXEL_BLUEPRINT, 9, 1, 2, 12));
                ((List)trades.get(2)).add(new SellingItemTrade((ItemLike)ModItems.PROSPECTOR_HAMMER_BLUEPRINT, 5, 1, 2, 12));
                ((List)trades.get(2)).add(new SellingItemTrade((ItemLike)ModItems.SAW_BLUEPRINT, 7, 1, 4, 12));
                ((List)trades.get(2)).add(new SellingItemTrade((ItemLike)ModItems.TIP_BLUEPRINT, 4, 1, 4, 7));
                ((List)trades.get(2)).add(new SellingItemTrade((ItemLike)ModItems.STURDY_REPAIR_KIT, 8, 1, 3, 10));
                ((List)trades.get(2)).add(new BuyingItemTrade(CraftingItems.CRIMSON_IRON_INGOT, 3, 12, 10));
            }
        }
    }
}

