/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.network.NetworkEvent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.gear.trait.TraitSerializers;
import net.silentchaos512.gear.network.SyncTraitsPacket;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class TraitManager
implements ResourceManagerReloadListener {
    public static final TraitManager INSTANCE = new TraitManager();
    public static final Marker MARKER = MarkerManager.getMarker((String)"TraitManager");
    private static final String DATA_PATH = "silentgear_traits";
    private static final String DATA_PATH_OLD = "silentgear/traits";
    private static final Map<ResourceLocation, ITrait> MAP = Collections.synchronizedMap(new LinkedHashMap());
    private static final Collection<ResourceLocation> ERROR_LIST = new ArrayList<ResourceLocation>();

    private TraitManager() {
    }

    public void m_6213_(ResourceManager resourceManager) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        Collection<ResourceLocation> resources = TraitManager.getAllResources(resourceManager);
        if (resources.isEmpty()) {
            return;
        }
        MAP.clear();
        ERROR_LIST.clear();
        SilentGear.LOGGER.info(MARKER, "Reloading trait files");
        for (ResourceLocation id : resources) {
            String path = id.m_135815_().substring(DATA_PATH.length() + 1, id.m_135815_().length() - ".json".length());
            ResourceLocation name = new ResourceLocation(id.m_135827_(), path);
            try {
                Resource iresource = resourceManager.m_142591_(id);
                try {
                    JsonObject json;
                    if (SilentGear.LOGGER.isTraceEnabled()) {
                        SilentGear.LOGGER.trace(MARKER, "Found likely trait file: {}, trying to read as trait {}", (Object)id, (Object)name);
                    }
                    if ((json = (JsonObject)GsonHelper.m_13794_((Gson)gson, (String)IOUtils.toString((InputStream)iresource.m_6679_(), (Charset)StandardCharsets.UTF_8), JsonObject.class)) == null) {
                        SilentGear.LOGGER.error(MARKER, "could not load trait {} as it's null or empty", (Object)name);
                        continue;
                    }
                    TraitManager.addTrait(TraitSerializers.deserialize(name, json));
                }
                finally {
                    if (iresource == null) continue;
                    iresource.close();
                }
            }
            catch (JsonParseException | IllegalArgumentException ex) {
                SilentGear.LOGGER.error(MARKER, "Parsing error loading trait {}", (Object)name, (Object)ex);
                ERROR_LIST.add(name);
            }
            catch (IOException ex) {
                SilentGear.LOGGER.error(MARKER, "Could not read trait {}", (Object)name, (Object)ex);
                ERROR_LIST.add(name);
            }
        }
        SilentGear.LOGGER.info(MARKER, "Registered {} traits", (Object)MAP.size());
    }

    private static Collection<ResourceLocation> getAllResources(ResourceManager resourceManager) {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        list.addAll(resourceManager.m_6540_(DATA_PATH, s -> s.endsWith(".json")));
        list.addAll(resourceManager.m_6540_(DATA_PATH_OLD, s -> s.endsWith(".json")));
        return list;
    }

    private static void addTrait(ITrait trait) {
        if (MAP.containsKey(trait.getId())) {
            throw new IllegalArgumentException("Duplicate trait " + trait.getId());
        }
        MAP.put(trait.getId(), trait);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<ResourceLocation> getKeys() {
        Map<ResourceLocation, ITrait> map = MAP;
        synchronized (map) {
            return MAP.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<ITrait> getValues() {
        Map<ResourceLocation, ITrait> map = MAP;
        synchronized (map) {
            return MAP.values();
        }
    }

    @Nullable
    public static ITrait get(ResourceLocation id) {
        return MAP.get(id);
    }

    @Nullable
    public static ITrait get(String strId) {
        return TraitManager.get(new ResourceLocation(strId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleTraitSyncPacket(SyncTraitsPacket packet, Supplier<NetworkEvent.Context> context) {
        Map<ResourceLocation, ITrait> map = MAP;
        synchronized (map) {
            ImmutableMap oldTraits = ImmutableMap.copyOf(MAP);
            MAP.clear();
            for (ITrait trait : packet.getTraits()) {
                trait.retainData((ITrait)oldTraits.get(trait.getId()));
                MAP.put(trait.getId(), trait);
            }
            SilentGear.LOGGER.info("Read {} traits from server", (Object)MAP.size());
        }
        context.get().setPacketHandled(true);
    }

    public static Collection<Component> getErrorMessages(ServerPlayer player) {
        if (!ERROR_LIST.isEmpty()) {
            String listStr = ERROR_LIST.stream().map(ResourceLocation::toString).collect(Collectors.joining(", "));
            return ImmutableList.of((Object)new TextComponent("[Silent Gear] The following traits failed to load, check your log file:").m_130940_(ChatFormatting.RED), (Object)new TextComponent(listStr));
        }
        return ImmutableList.of();
    }
}

