/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.gear.trait.SimpleTrait;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.lib.util.NameUtils;

public class TargetEffectTrait
extends SimpleTrait {
    public static final ITraitSerializer<TargetEffectTrait> SERIALIZER = new SimpleTrait.Serializer<TargetEffectTrait>(SilentGear.getId("target_effect"), TargetEffectTrait::new, TargetEffectTrait::deserialize, TargetEffectTrait::read, TargetEffectTrait::write);
    private final Map<String, EffectMap> effects = new LinkedHashMap<String, EffectMap>();

    public TargetEffectTrait(ResourceLocation id) {
        super(id, SERIALIZER);
    }

    @Override
    public float onAttackEntity(TraitActionContext context, LivingEntity target, float baseValue) {
        GearType type = GearHelper.getType(context.getGear());
        for (String typeStr : this.effects.keySet()) {
            if (!type.matches(typeStr)) continue;
            this.effects.get(typeStr).applyTo(target, context.getTraitLevel());
        }
        return super.onAttackEntity(context, target, baseValue);
    }

    private static void deserialize(TargetEffectTrait trait, JsonObject json) {
        if (!json.has("effects")) {
            throw new JsonParseException("Target effect trait '" + trait.getId() + "' is missing 'effects' object");
        }
        JsonObject jsonEffects = json.getAsJsonObject("effects");
        for (Map.Entry entry : jsonEffects.entrySet()) {
            String gearTypeKey = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            if (!element.isJsonObject()) {
                throw new JsonParseException("Expected object, found " + element.getClass().getSimpleName());
            }
            EffectMap list = EffectMap.deserialize(element.getAsJsonObject());
            trait.effects.put(gearTypeKey, list);
        }
    }

    private static void read(TargetEffectTrait trait, FriendlyByteBuf buffer) {
        trait.effects.clear();
        int mapSize = buffer.readByte();
        for (int i = 0; i < mapSize; ++i) {
            String key = buffer.m_130277_();
            EffectMap list = EffectMap.read(buffer);
            trait.effects.put(key, list);
        }
    }

    private static void write(TargetEffectTrait trait, FriendlyByteBuf buffer) {
        buffer.writeByte(trait.effects.size());
        for (Map.Entry<String, EffectMap> entry : trait.effects.entrySet()) {
            buffer.m_130070_(entry.getKey());
            entry.getValue().write(buffer);
        }
    }

    @Override
    public Collection<String> getExtraWikiLines() {
        Collection<String> ret = super.getExtraWikiLines();
        this.effects.forEach((type, map) -> {
            ret.add("  - " + type);
            ret.addAll(map.getWikiLines());
        });
        return ret;
    }

    public static class EffectMap {
        private final Map<Integer, List<MobEffectInstance>> effects = new LinkedHashMap<Integer, List<MobEffectInstance>>();

        public EffectMap(Map<Integer, List<MobEffectInstance>> effects) {
            this.effects.putAll(effects);
        }

        public void applyTo(LivingEntity target, int traitLevel) {
            if (this.effects.containsKey(traitLevel)) {
                for (MobEffectInstance effect : this.effects.get(traitLevel)) {
                    MobEffectInstance copy = new MobEffectInstance(effect);
                    target.m_7292_(copy);
                }
            }
        }

        public JsonObject serialize() {
            JsonObject json = new JsonObject();
            for (Map.Entry<Integer, List<MobEffectInstance>> entry : this.effects.entrySet()) {
                int level = entry.getKey();
                List<MobEffectInstance> list = entry.getValue();
                JsonArray array = new JsonArray();
                for (MobEffectInstance inst : list) {
                    JsonObject obj = new JsonObject();
                    obj.addProperty("effect", NameUtils.from((IForgeRegistryEntry)inst.m_19544_()).toString());
                    obj.addProperty("amplifier", (Number)inst.m_19564_());
                    obj.addProperty("duration", (Number)Float.valueOf((float)inst.m_19557_() / 20.0f));
                    array.add((JsonElement)obj);
                }
                json.add(String.valueOf(level), (JsonElement)array);
            }
            return json;
        }

        static EffectMap deserialize(JsonObject json) {
            LinkedHashMap<Integer, List<MobEffectInstance>> map = new LinkedHashMap<Integer, List<MobEffectInstance>>();
            for (Map.Entry entry : json.entrySet()) {
                int level = Integer.parseInt((String)entry.getKey());
                JsonElement element = (JsonElement)entry.getValue();
                if (element.isJsonArray()) {
                    ArrayList<MobEffectInstance> list = new ArrayList<MobEffectInstance>();
                    for (JsonElement effectJson : element.getAsJsonArray()) {
                        list.add(EffectMap.deserialize(effectJson));
                    }
                    map.put(level, list);
                    continue;
                }
                if (element.isJsonObject()) {
                    map.put(level, Collections.singletonList(EffectMap.deserialize(element)));
                    continue;
                }
                throw new JsonParseException("Expected effects for level element to be either array or object");
            }
            return new EffectMap(map);
        }

        private static MobEffectInstance deserialize(JsonElement jsonElement) {
            if (!jsonElement.isJsonObject()) {
                throw new JsonParseException("Expected effect instance element to be an object");
            }
            JsonObject json = jsonElement.getAsJsonObject();
            ResourceLocation effectId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"effect"));
            MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectId);
            if (effect == null) {
                throw new JsonParseException("Unknown effect ID: " + effectId);
            }
            int level = GsonHelper.m_13824_((JsonObject)json, (String)"amplifier", (int)0);
            float duration = GsonHelper.m_13820_((JsonObject)json, (String)"duration", (float)5.0f);
            return new MobEffectInstance(effect, (int)duration * 20, level);
        }

        public static EffectMap read(FriendlyByteBuf buffer) {
            int mapSize = buffer.readByte();
            LinkedHashMap<Integer, List<MobEffectInstance>> result = new LinkedHashMap<Integer, List<MobEffectInstance>>();
            for (int i = 0; i < mapSize; ++i) {
                byte level = buffer.readByte();
                int listSize = buffer.readByte();
                ArrayList<MobEffectInstance> list = new ArrayList<MobEffectInstance>(listSize);
                for (int j = 0; j < listSize; ++j) {
                    ResourceLocation effectId = buffer.m_130281_();
                    MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectId);
                    if (effect == null) {
                        throw new JsonParseException("Unknown effect ID: " + effectId);
                    }
                    byte amplifier = buffer.readByte();
                    int duration = buffer.m_130242_();
                    list.add(new MobEffectInstance(effect, duration, (int)amplifier));
                }
                result.put(Integer.valueOf(level), list);
            }
            return new EffectMap(result);
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.writeByte(this.effects.size());
            for (Map.Entry<Integer, List<MobEffectInstance>> entry : this.effects.entrySet()) {
                buffer.writeByte(entry.getKey().intValue());
                buffer.writeByte(entry.getValue().size());
                for (MobEffectInstance effect : entry.getValue()) {
                    buffer.m_130085_(NameUtils.from((IForgeRegistryEntry)effect.m_19544_()));
                    buffer.writeByte(effect.m_19564_());
                    buffer.m_130130_(effect.m_19557_());
                }
            }
        }

        public Collection<String> getWikiLines() {
            ArrayList<String> ret = new ArrayList<String>();
            this.effects.forEach((level, list) -> {
                ret.add("    - Level " + level + ":");
                list.forEach(effect -> ret.add("      - " + effect));
            });
            return ret;
        }
    }
}

