/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.ITraitCondition;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.gear.trait.TraitSerializers;

public class SimpleTrait
implements ITrait {
    public static final Serializer<SimpleTrait> SERIALIZER = new Serializer<SimpleTrait>(Serializer.NAME, SimpleTrait::new);
    private final ResourceLocation objId;
    private final ITraitSerializer<?> serializer;
    int maxLevel;
    ImmutableList<ITraitCondition> conditions = ImmutableList.of();
    Set<String> cancelsWith = new HashSet<String>();
    Component displayName;
    Component description;
    boolean hidden;
    final Collection<Component> wikiLines = new ArrayList<Component>();

    @Deprecated
    public SimpleTrait(ResourceLocation id) {
        this(id, SERIALIZER);
    }

    public SimpleTrait(ResourceLocation id, ITraitSerializer<?> serializer) {
        this.objId = id;
        this.serializer = serializer;
    }

    @Override
    public ResourceLocation getId() {
        return this.objId;
    }

    @Override
    public int getMaxLevel() {
        return this.maxLevel;
    }

    @Override
    public Collection<ITraitCondition> getConditions() {
        return this.conditions;
    }

    @Override
    public boolean willCancelWith(ITrait other) {
        return this.cancelsWith.contains(other.getId().toString());
    }

    @Override
    public Collection<String> getCancelsWithSet() {
        return Collections.unmodifiableSet(this.cancelsWith);
    }

    @Override
    public void retainData(@Nullable ITrait oldTrait) {
        if (oldTrait instanceof SimpleTrait) {
            this.wikiLines.addAll(((SimpleTrait)oldTrait).wikiLines);
        }
    }

    @Override
    public MutableComponent getDisplayName(int level) {
        MutableComponent text = this.displayName.m_6881_();
        if (level > 0 && this.maxLevel > 1) {
            text.m_130946_(" ").m_7220_((Component)new TranslatableComponent("enchantment.level." + level));
        }
        return text;
    }

    @Override
    public MutableComponent getDescription(int level) {
        return this.description.m_6881_();
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public ITraitSerializer<?> getSerializer() {
        return this.serializer;
    }

    @Override
    public float onAttackEntity(TraitActionContext context, LivingEntity target, float baseValue) {
        return baseValue;
    }

    @Override
    public float onDurabilityDamage(TraitActionContext context, int damageTaken) {
        return damageTaken;
    }

    @Override
    public void onGearCrafted(TraitActionContext context) {
    }

    @Override
    public void onRecalculatePre(TraitActionContext context) {
    }

    @Override
    public void onRecalculatePost(TraitActionContext context) {
    }

    @Override
    public float onGetStat(TraitActionContext context, ItemStat stat, float value, float damageRatio) {
        return value;
    }

    @Override
    public void onGetAttributeModifiers(TraitActionContext context, Multimap<Attribute, AttributeModifier> modifiers, String slot) {
    }

    @Override
    @Deprecated
    public void onGetAttributeModifiers(TraitActionContext context, Multimap<Attribute, AttributeModifier> modifiers, EquipmentSlot slot) {
    }

    @Override
    public InteractionResult onItemUse(UseOnContext context, int traitLevel) {
        return InteractionResult.PASS;
    }

    @Override
    public void onItemSwing(ItemStack stack, LivingEntity wielder, int traitLevel) {
    }

    @Override
    public void onUpdate(TraitActionContext context, boolean isEquipped) {
    }

    @Override
    public ItemStack addLootDrops(TraitActionContext context, ItemStack stack) {
        return ItemStack.f_41583_;
    }

    @Override
    public Collection<String> getExtraWikiLines() {
        return this.wikiLines.stream().map(Component::getString).collect(Collectors.toCollection(ArrayList::new));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleTrait that = (SimpleTrait)o;
        return this.objId.equals((Object)that.objId);
    }

    public int hashCode() {
        return Objects.hash(this.objId);
    }

    public static final class Serializer<T extends SimpleTrait>
    implements ITraitSerializer<T> {
        private static final ResourceLocation NAME = SilentGear.getId("simple_trait");
        private final ResourceLocation serializerId;
        private final Function<ResourceLocation, T> factory;
        @Nullable
        private final BiConsumer<T, JsonObject> deserializeJson;
        @Nullable
        private final BiConsumer<T, FriendlyByteBuf> readFromNetwork;
        @Nullable
        private final BiConsumer<T, FriendlyByteBuf> writeToNetwork;

        public Serializer(ResourceLocation serializerId, Function<ResourceLocation, T> factory) {
            this(serializerId, factory, null, null, null);
        }

        public Serializer(ResourceLocation serializerId, Function<ResourceLocation, T> factory, @Nullable BiConsumer<T, JsonObject> deserializeJson, @Nullable BiConsumer<T, FriendlyByteBuf> readFromNetwork, @Nullable BiConsumer<T, FriendlyByteBuf> writeToNetwork) {
            this.serializerId = serializerId;
            this.factory = factory;
            this.deserializeJson = deserializeJson;
            this.readFromNetwork = readFromNetwork;
            this.writeToNetwork = writeToNetwork;
        }

        @Override
        public T read(ResourceLocation id, JsonObject json) {
            JsonArray array;
            SimpleTrait trait = (SimpleTrait)this.factory.apply(id);
            trait.maxLevel = GsonHelper.m_13824_((JsonObject)json, (String)"max_level", (int)1);
            trait.displayName = Serializer.deserializeText(json.get("name"));
            trait.description = Serializer.deserializeText(json.get("description"));
            trait.hidden = GsonHelper.m_13855_((JsonObject)json, (String)"hidden", (boolean)false);
            if (json.has("conditions")) {
                ArrayList<ITraitCondition> conditions = new ArrayList<ITraitCondition>();
                JsonArray array2 = json.getAsJsonArray("conditions");
                for (JsonElement elem : array2) {
                    conditions.add(TraitSerializers.deserializeCondition(elem.getAsJsonObject()));
                }
                trait.conditions = ImmutableList.copyOf(conditions);
            }
            if (json.has("cancels_with")) {
                array = json.getAsJsonArray("cancels_with");
                for (JsonElement elem : array) {
                    trait.cancelsWith.add(elem.getAsString());
                }
            }
            if (json.has("extra_wiki_lines")) {
                array = json.getAsJsonArray("extra_wiki_lines");
                for (JsonElement elem : array) {
                    trait.wikiLines.add((Component)Component.Serializer.m_130691_((JsonElement)elem));
                }
            }
            if (this.deserializeJson != null) {
                this.deserializeJson.accept(trait, json);
            }
            return (T)trait;
        }

        @Override
        public T read(ResourceLocation id, FriendlyByteBuf buffer) {
            SimpleTrait trait = (SimpleTrait)this.factory.apply(id);
            trait.maxLevel = buffer.readByte();
            trait.displayName = buffer.m_130238_();
            trait.description = buffer.m_130238_();
            trait.hidden = buffer.readBoolean();
            Object[] conditions = new ITraitCondition[buffer.readByte()];
            for (int i = 0; i < conditions.length; ++i) {
                conditions[i] = TraitSerializers.readCondition(buffer);
            }
            trait.conditions = ImmutableList.copyOf((Object[])conditions);
            int cancelsCount = buffer.m_130242_();
            for (int i = 0; i < cancelsCount; ++i) {
                trait.cancelsWith.add(buffer.m_130136_(255));
            }
            if (this.readFromNetwork != null) {
                this.readFromNetwork.accept(trait, buffer);
            }
            return (T)trait;
        }

        @Override
        public void write(FriendlyByteBuf buffer, T trait) {
            buffer.writeByte(((SimpleTrait)trait).maxLevel);
            buffer.m_130083_(((SimpleTrait)trait).displayName);
            buffer.m_130083_(((SimpleTrait)trait).description);
            buffer.writeBoolean(((SimpleTrait)trait).hidden);
            buffer.writeByte(((SimpleTrait)trait).conditions.size());
            ((SimpleTrait)trait).conditions.forEach(condition -> TraitSerializers.writeCondition(condition, buffer));
            buffer.m_130130_(((SimpleTrait)trait).cancelsWith.size());
            for (String str : ((SimpleTrait)trait).cancelsWith) {
                buffer.m_130070_(str);
            }
            if (this.writeToNetwork != null) {
                this.writeToNetwork.accept(trait, buffer);
            }
        }

        @Override
        public ResourceLocation getName() {
            return this.serializerId;
        }

        private static Component deserializeText(JsonElement json) {
            if (json.isJsonObject() && json.getAsJsonObject().has("name")) {
                boolean translate = GsonHelper.m_13855_((JsonObject)json.getAsJsonObject(), (String)"translate", (boolean)false);
                String name = GsonHelper.m_13906_((JsonObject)json.getAsJsonObject(), (String)"name");
                return translate ? new TranslatableComponent(name) : new TextComponent(name);
            }
            return (Component)Objects.requireNonNull(Component.Serializer.m_130691_((JsonElement)json));
        }

        private static Component readTextComponent(JsonObject json, String name) {
            JsonElement element = json.get(name);
            if (element != null && element.isJsonObject()) {
                JsonObject obj = element.getAsJsonObject();
                boolean translate = GsonHelper.m_13855_((JsonObject)obj, (String)"translate", (boolean)false);
                String value = GsonHelper.m_13906_((JsonObject)obj, (String)"name");
                return translate ? new TranslatableComponent(value) : new TextComponent(value);
            }
            if (element != null) {
                throw new JsonParseException("Expected '" + name + "' to be an object");
            }
            throw new JsonParseException("Missing required object '" + name + "'");
        }

        public String getTypeName() {
            SimpleTrait temp = (SimpleTrait)this.factory.apply(new ResourceLocation("null"));
            return temp.getClass().getCanonicalName();
        }
    }
}

