/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.gear.trait.SimpleTrait;
import net.silentchaos512.lib.util.NameUtils;

public class CancelEffectsTrait
extends SimpleTrait {
    public static final ITraitSerializer<CancelEffectsTrait> SERIALIZER = new SimpleTrait.Serializer<CancelEffectsTrait>(SilentGear.getId("cancel_effects"), CancelEffectsTrait::new, CancelEffectsTrait::deserialize, CancelEffectsTrait::decode, CancelEffectsTrait::encode);
    private final Collection<MobEffect> effects = new ArrayList<MobEffect>();

    public CancelEffectsTrait(ResourceLocation id) {
        super(id, SERIALIZER);
    }

    private static void deserialize(CancelEffectsTrait trait, JsonObject json) {
        JsonArray array = json.getAsJsonArray("effects");
        for (JsonElement element : array) {
            MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(element.getAsString()));
            if (effect == null) continue;
            trait.effects.add(effect);
        }
    }

    private static void decode(CancelEffectsTrait trait, FriendlyByteBuf buffer) {
        int count = buffer.readByte();
        for (int i = 0; i < count; ++i) {
            MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(buffer.m_130281_());
            if (effect == null) continue;
            trait.effects.add(effect);
        }
    }

    private static void encode(CancelEffectsTrait trait, FriendlyByteBuf buffer) {
        buffer.writeByte(trait.effects.size());
        trait.effects.forEach(effect -> buffer.m_130085_(NameUtils.from((IForgeRegistryEntry)effect)));
    }

    @Override
    public void onUpdate(TraitActionContext context, boolean isEquipped) {
        Player player;
        if (isEquipped && (player = context.getPlayer()) != null) {
            for (MobEffect effect : this.effects) {
                player.m_21195_(effect);
            }
        }
    }

    @Override
    public Collection<String> getExtraWikiLines() {
        Collection<String> ret = super.getExtraWikiLines();
        ret.add("  - Cancels these effects: " + this.effects.stream().map(e -> "`" + NameUtils.from((IForgeRegistryEntry)e) + "`").collect(Collectors.joining(", ")));
        return ret;
    }
}

