/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.gear.trait.SimpleTrait;

public final class BonusDropsTrait
extends SimpleTrait {
    public static final ITraitSerializer<BonusDropsTrait> SERIALIZER = new SimpleTrait.Serializer<BonusDropsTrait>(SilentGear.getId("bonus_drops"), BonusDropsTrait::new, (trait, json) -> {
        trait.baseChance = GsonHelper.m_13820_((JsonObject)json, (String)"base_chance", (float)0.0f);
        trait.bonusMultiplier = GsonHelper.m_13820_((JsonObject)json, (String)"bonus_multiplier", (float)1.0f);
        trait.readIngredient(json.get("ingredient"));
    }, (trait, buffer) -> {
        trait.baseChance = buffer.readFloat();
        trait.bonusMultiplier = buffer.readFloat();
        trait.ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        trait.matchedItemsText = buffer.m_130277_();
    }, (trait, buffer) -> {
        buffer.writeFloat(trait.baseChance);
        buffer.writeFloat(trait.bonusMultiplier);
        trait.ingredient.m_43923_(buffer);
        buffer.m_130070_(trait.matchedItemsText);
    });
    private float baseChance;
    private float bonusMultiplier;
    private Ingredient ingredient = Ingredient.f_43901_;
    private String matchedItemsText = "some items";

    private BonusDropsTrait(ResourceLocation id) {
        super(id, SERIALIZER);
    }

    private void readIngredient(JsonElement json) {
        this.ingredient = Ingredient.m_43917_((JsonElement)json);
        if (json.isJsonObject()) {
            JsonObject obj = json.getAsJsonObject();
            if (obj.has("tag")) {
                this.matchedItemsText = "`" + obj.get("tag").getAsString() + "` (tag)";
            } else if (obj.has("item")) {
                this.matchedItemsText = "`" + obj.get("item").getAsString() + "`";
            }
        }
    }

    @Override
    public ItemStack addLootDrops(TraitActionContext context, ItemStack stack) {
        if (this.ingredient.test(stack) && SilentGear.RANDOM.nextFloat() < this.baseChance * (float)context.getTraitLevel()) {
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(Math.round((float)stack.m_41613_() * this.bonusMultiplier));
            return copy;
        }
        return super.addLootDrops(context, stack);
    }

    @Override
    public Collection<String> getExtraWikiLines() {
        Collection<String> ret = super.getExtraWikiLines();
        ret.add(String.format("  - %d%% chance per level of dropping %d%% more of %s", (int)(100.0f * this.baseChance), (int)(100.0f * this.bonusMultiplier), this.matchedItemsText));
        return ret;
    }
}

